/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.summoningrituals.data;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.data.PackOutput;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.neoforged.neoforge.common.data.LanguageProvider;
import org.apache.commons.lang3.StringUtils;

public final class SummoningLang
extends LanguageProvider {
    public static final LangEntry ALTAR = LangEntry.block("altar", "Summoning Altar");
    public static final LangEntry INDESTRUCTIBLE_ALTAR = LangEntry.block("indestructible_altar", "Indestructible Summoning Altar");
    public static final LangEntry IN_PROGRESS = LangEntry.message("in_progress", "The ritual is already in progress.");
    public static final LangEntry MISSING_INPUTS = LangEntry.message("missing_inputs", "Some of the required item inputs couldn't be found in the Altar.");
    public static final LangEntry INVALID_INITIATOR = LangEntry.message("invalid_initiator", "No recipes have been found for this initiator.");
    public static final LangEntry MISSING_SACRIFICES = LangEntry.message("missing_sacrifices", "Not all sacrifices were found for the ritual.");
    public static final LangEntry FAILED_CONDITIONS = LangEntry.message("failed_conditions", "Not all conditions were met for the ritual.");
    public static final LangEntry MULTI_MATCH = LangEntry.message("multi_match", "More than one recipe found for this initiator.");
    public static final LangEntry INITIATOR = LangEntry.label("initiator", "Initiator");
    public static final LangEntry CONDITIONS = LangEntry.label("conditions", "Conditions");
    public static final LangEntry COMMANDS = LangEntry.label("commands", "Commands");
    public static final LangEntry INSERT_LAST = LangEntry.hint("insert_last", "Insert last to start the ritual.");

    SummoningLang(PackOutput output) {
        super(output, "summoningrituals", "en_us");
    }

    protected void addTranslations() {
        for (LangEntry entry : LangEntry.ENTRIES) {
            this.add(entry.key, entry.value);
        }
    }

    public record LangEntry(String key, String value) implements Supplier<MutableComponent>
    {
        private static final Set<LangEntry> ENTRIES = new HashSet<LangEntry>();

        public static LangEntry of(String prefix, String id, String value) {
            LangEntry entry = new LangEntry(String.format("%s.%s.%s", prefix, "summoningrituals", id), value);
            ENTRIES.add(entry);
            return entry;
        }

        private static LangEntry block(String id, String value) {
            return LangEntry.of("block", id, value);
        }

        private static LangEntry message(String id, String value) {
            return LangEntry.of("message", id, value);
        }

        private static LangEntry label(String id, String value) {
            return LangEntry.of("label", id, value);
        }

        private static LangEntry hint(String id, String value) {
            return LangEntry.of("hint", id, value);
        }

        public static LangEntry condition(String id, String value) {
            return LangEntry.of("condition", id, value);
        }

        @SafeVarargs
        public static <T extends Enum<?>> Map<T, LangEntry> enumValues(String prefix, String idPrefix, T ... enumValues) {
            HashMap<T, LangEntry> enumEntries = new HashMap<T, LangEntry>();
            for (T enumValue : enumValues) {
                String id = ((Enum)enumValue).name().toLowerCase(Locale.ROOT);
                String value = StringUtils.capitalize((String)id);
                enumEntries.put(enumValue, LangEntry.of(prefix, idPrefix + "_" + id, value));
            }
            return enumEntries;
        }

        @Override
        public MutableComponent get() {
            return Component.translatable((String)this.key);
        }
    }
}

