/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.summoningrituals.data;

import com.almostreliable.summoningrituals.SummoningRituals;
import com.almostreliable.summoningrituals.altar.AltarBlock;
import com.almostreliable.summoningrituals.core.Registration;
import net.minecraft.core.Direction;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.client.model.generators.BlockModelBuilder;
import net.neoforged.neoforge.client.model.generators.BlockStateProvider;
import net.neoforged.neoforge.client.model.generators.ConfiguredModel;
import net.neoforged.neoforge.client.model.generators.ModelFile;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.registries.DeferredBlock;

class SummoningModels
extends BlockStateProvider {
    SummoningModels(PackOutput output, ExistingFileHelper existingFileHelper) {
        super(output, "summoningrituals", existingFileHelper);
    }

    protected void registerStatesAndModels() {
        DeferredBlock<AltarBlock> altarBlock = Registration.ALTAR_BLOCK;
        ResourceLocation altarBlockId = altarBlock.getId();
        ResourceLocation altarBlockModelPath = SummoningRituals.getRL("block/" + altarBlockId.getPath());
        this.altarBlockStateAndModel(altarBlock, altarBlockModelPath);
        this.itemModels().simpleBlockItem((Block)altarBlock.get());
        DeferredBlock<AltarBlock> indestructibleAltarBlock = Registration.INDESTRUCTIBLE_ALTAR_BLOCK;
        this.altarBlockStateAndModel(indestructibleAltarBlock, altarBlockModelPath);
        this.itemModels().withExistingParent(indestructibleAltarBlock.getId().toString(), altarBlockModelPath);
    }

    private void altarBlockStateAndModel(DeferredBlock<?> block, ResourceLocation modelPath) {
        ModelFile.ExistingModelFile model = this.models().getExistingFile(modelPath);
        String modelPathActive = modelPath.getPath() + "_active";
        BlockModelBuilder modelActive = (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().getBuilder(modelPathActive)).parent((ModelFile)model)).texture("texture", modelPathActive);
        this.getVariantBuilder((Block)block.get()).forAllStatesExcept(state -> {
            Direction facing = (Direction)state.getValue((Property)AltarBlock.FACING);
            boolean active = (Boolean)state.getValue((Property)AltarBlock.ACTIVE);
            return ConfiguredModel.builder().modelFile((ModelFile)(active ? modelActive : model)).rotationY(((int)facing.toYRot() + 180) % 360).build();
        }, new Property[]{AltarBlock.WATERLOGGED});
    }
}

