/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.summoningrituals.network;

import com.almostreliable.summoningrituals.SummoningRituals;
import com.almostreliable.summoningrituals.core.Registration;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record AltarInventorySyncPacket(BlockPos altarPos, CompoundTag inventoryData) implements CustomPacketPayload
{
    static final CustomPacketPayload.Type<AltarInventorySyncPacket> TYPE = new CustomPacketPayload.Type(SummoningRituals.getRL("altar_inventory_sync"));
    static final StreamCodec<FriendlyByteBuf, AltarInventorySyncPacket> STREAM_CODEC = StreamCodec.composite((StreamCodec)BlockPos.STREAM_CODEC, AltarInventorySyncPacket::altarPos, (StreamCodec)ByteBufCodecs.COMPOUND_TAG, AltarInventorySyncPacket::inventoryData, AltarInventorySyncPacket::new);

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public static void handle(AltarInventorySyncPacket packet, IPayloadContext ignoredCtx) {
        ClientLevel level = Minecraft.getInstance().level;
        if (level == null) {
            return;
        }
        level.getBlockEntity(packet.altarPos, (BlockEntityType)Registration.ALTAR_BLOCK_ENTITY.get()).ifPresent(altar -> altar.getInventory().deserializeNBT((HolderLookup.Provider)level.registryAccess(), packet.inventoryData()));
    }
}

