/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.summoningrituals.network;

import com.almostreliable.summoningrituals.network.AltarInventorySyncPacket;
import com.almostreliable.summoningrituals.network.AltarRecipeSyncPacket;
import net.minecraft.core.BlockPos;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.ChunkPos;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.event.RegisterPayloadHandlersEvent;
import net.neoforged.neoforge.network.handling.IPayloadHandler;
import net.neoforged.neoforge.network.registration.PayloadRegistrar;

public final class PacketHandler {
    private static final String PROTOCOL = "1";

    private PacketHandler() {
    }

    public static void init(IEventBus eventBus) {
        eventBus.addListener(PacketHandler::onPacketRegistration);
    }

    private static void onPacketRegistration(RegisterPayloadHandlersEvent event) {
        PayloadRegistrar registrar = event.registrar(PROTOCOL);
        registrar.playToClient(AltarInventorySyncPacket.TYPE, AltarInventorySyncPacket.STREAM_CODEC, PacketHandler.wrapHandler(AltarInventorySyncPacket::handle));
        registrar.playToClient(AltarRecipeSyncPacket.TYPE, AltarRecipeSyncPacket.STREAM_CODEC, PacketHandler.wrapHandler(AltarRecipeSyncPacket::handle));
    }

    private static <T extends CustomPacketPayload> IPayloadHandler<T> wrapHandler(IPayloadHandler<T> handler) {
        return (payload, context) -> context.enqueueWork(() -> handler.handle(payload, context));
    }

    public static void sendToTrackingChunk(ServerLevel level, BlockPos pos, CustomPacketPayload packet) {
        PacketDistributor.sendToPlayersTrackingChunk((ServerLevel)level, (ChunkPos)level.getChunkAt(pos).getPos(), (CustomPacketPayload)packet, (CustomPacketPayload[])new CustomPacketPayload[0]);
    }
}

