/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.summoningrituals.recipe;

import com.almostreliable.summoningrituals.core.Registration;
import com.almostreliable.summoningrituals.recipe.EntityInfo;
import com.almostreliable.summoningrituals.recipe.output.CommandOutput;
import com.almostreliable.summoningrituals.recipe.output.EntityOutput;
import com.almostreliable.summoningrituals.recipe.output.ItemOutput;
import com.almostreliable.summoningrituals.recipe.output.RecipeOutput;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.common.crafting.SizedIngredient;
import org.jetbrains.annotations.Nullable;

public record AltarRecipe(Ingredient initiator, List<ItemOutput> itemOutputs, List<EntityOutput> entityOutputs, Optional<CommandOutput> commands, List<SizedIngredient> itemInputs, List<EntityInfo> entityInputs, List<LootItemCondition> startConditions, BlockPos zone, int ticks) implements Recipe<RecipeInput>
{
    public static final BlockPos DEFAULT_ZONE = new BlockPos(3, 2, 3);
    public static final int DEFAULT_TICKS = 40;
    private static final Set<Item> INITIATORS = new HashSet<Item>();
    private static final Set<Item> INPUTS = new HashSet<Item>();
    private static boolean CACHES_INITIALIZED;

    public boolean matches(RecipeInput inventory, Level level) {
        Ingredient[] matchedItems = new Ingredient[inventory.size()];
        ArrayList<Ingredient> matchedIngredients = new ArrayList<Ingredient>();
        for (int slot = 0; slot < inventory.size(); ++slot) {
            ItemStack stack = inventory.getItem(slot);
            if (stack.isEmpty() || matchedItems[slot] != null) continue;
            for (SizedIngredient input : this.itemInputs) {
                if (matchedIngredients.contains(input.ingredient()) || !input.ingredient().test(stack) || stack.getCount() < input.count()) continue;
                matchedItems[slot] = input.ingredient();
                matchedIngredients.add(input.ingredient());
            }
        }
        return matchedIngredients.size() == this.itemInputs.size();
    }

    public ItemStack assemble(RecipeInput inventory, HolderLookup.Provider registries) {
        return ItemStack.EMPTY;
    }

    public boolean canCraftInDimensions(int width, int height) {
        return false;
    }

    public ItemStack getResultItem(HolderLookup.Provider registries) {
        return ItemStack.EMPTY;
    }

    public boolean isSpecial() {
        return true;
    }

    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)Registration.ALTAR_RECIPE_SERIALIZER.get();
    }

    public RecipeType<?> getType() {
        return (RecipeType)Registration.ALTAR_RECIPE_TYPE.get();
    }

    @Nullable
    public List<Entity> getSacrifices(BlockPos pos, Function<AABB, List<Entity>> entityCollector) {
        if (this.entityInputs.isEmpty()) {
            return List.of();
        }
        AABB region = this.constructRegion(pos);
        List<Entity> entities = entityCollector.apply(region);
        ArrayList<Entity> sacrifices = new ArrayList<Entity>();
        for (EntityInfo input : this.entityInputs) {
            int requiredCount = input.count();
            List<Entity> matchingEntities = entities.stream().filter(input).toList();
            if (matchingEntities.size() < requiredCount) {
                return null;
            }
            sacrifices.addAll(matchingEntities.subList(0, requiredCount));
        }
        return sacrifices;
    }

    public <E extends Entity, T extends RecipeOutput<E>> Collection<E> spawnOutputs(ServerLevel level, BlockPos origin, List<T> outputs) {
        ArrayList result = new ArrayList();
        for (RecipeOutput output : outputs) {
            result.addAll(output.spawn(level, origin));
        }
        return ImmutableList.copyOf(result);
    }

    public void invokeCommands(ServerLevel level, @Nullable ServerPlayer player) {
        if (this.commands.isEmpty()) {
            return;
        }
        this.commands.get().invoke(level, player);
    }

    private AABB constructRegion(BlockPos pos) {
        BlockPos startBounds = pos.offset((Vec3i)this.zone.multiply(-1));
        BlockPos endBounds = pos.offset((Vec3i)this.zone);
        return new AABB(new Vec3((double)startBounds.getX(), (double)startBounds.getY(), (double)startBounds.getZ()), new Vec3((double)endBounds.getX(), (double)endBounds.getY(), (double)endBounds.getZ()));
    }

    public static boolean isInitiator(RecipeManager recipeManager, Item item) {
        if (!CACHES_INITIALIZED) {
            AltarRecipe.initializeCaches(recipeManager);
        }
        return INITIATORS.contains(item);
    }

    public static boolean isInput(RecipeManager recipeManager, Item item) {
        if (!CACHES_INITIALIZED) {
            AltarRecipe.initializeCaches(recipeManager);
        }
        return INPUTS.contains(item);
    }

    private static void initializeCaches(RecipeManager recipeManager) {
        List recipes = recipeManager.getAllRecipesFor((RecipeType)Registration.ALTAR_RECIPE_TYPE.get());
        for (RecipeHolder recipe : recipes) {
            AltarRecipe r = (AltarRecipe)recipe.value();
            for (ItemStack initiator : r.initiator.getItems()) {
                INITIATORS.add(initiator.getItem());
            }
            for (SizedIngredient itemInput : r.itemInputs) {
                for (ItemStack stack : itemInput.getItems()) {
                    INPUTS.add(stack.getItem());
                }
            }
        }
        CACHES_INITIALIZED = true;
    }

    public static void clearCaches() {
        INITIATORS.clear();
        INPUTS.clear();
        CACHES_INITIALIZED = false;
    }
}

