/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.summoningrituals.recipe;

import com.almostreliable.summoningrituals.core.Config;
import com.almostreliable.summoningrituals.recipe.AltarRecipe;
import com.almostreliable.summoningrituals.recipe.EntityInfo;
import com.almostreliable.summoningrituals.recipe.condition.ConditionStreamCodecs;
import com.almostreliable.summoningrituals.recipe.output.CommandOutput;
import com.almostreliable.summoningrituals.recipe.output.EntityOutput;
import com.almostreliable.summoningrituals.recipe.output.ItemOutput;
import com.almostreliable.summoningrituals.util.CodecUtils;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.neoforged.neoforge.common.crafting.SizedIngredient;

public class AltarRecipeSerializer
implements RecipeSerializer<AltarRecipe> {
    public static final MapCodec<AltarRecipe> CODEC = RecordCodecBuilder.mapCodec(i -> i.group((App)Ingredient.CODEC_NONEMPTY.fieldOf("initiator").forGetter(AltarRecipe::initiator), (App)ItemOutput.CODEC.listOf().optionalFieldOf("item_outputs", List.of()).forGetter(AltarRecipe::itemOutputs), (App)EntityOutput.CODEC.listOf().optionalFieldOf("entity_outputs", List.of()).forGetter(AltarRecipe::entityOutputs), (App)CommandOutput.CODEC.optionalFieldOf("commands").forGetter(AltarRecipe::commands), (App)SizedIngredient.FLAT_CODEC.listOf().optionalFieldOf("item_inputs", List.of()).forGetter(AltarRecipe::itemInputs), (App)EntityInfo.CODEC.listOf().optionalFieldOf("entity_inputs", List.of()).forGetter(AltarRecipe::entityInputs), (App)LootItemCondition.DIRECT_CODEC.listOf().optionalFieldOf("conditions", List.of()).forGetter(AltarRecipe::startConditions), (App)BlockPos.CODEC.optionalFieldOf("zone", (Object)AltarRecipe.DEFAULT_ZONE).forGetter(AltarRecipe::zone), (App)Codec.INT.optionalFieldOf("ticks", (Object)40).forGetter(AltarRecipe::ticks)).apply((Applicative)i, AltarRecipe::new)).validate(AltarRecipeSerializer::validateRecipe);
    public static final StreamCodec<RegistryFriendlyByteBuf, AltarRecipe> STREAM_CODEC = CodecUtils.composite(Ingredient.CONTENTS_STREAM_CODEC, AltarRecipe::initiator, ItemOutput.STREAM_CODEC.apply(ByteBufCodecs.list()), AltarRecipe::itemOutputs, EntityOutput.STREAM_CODEC.apply(ByteBufCodecs.list()), AltarRecipe::entityOutputs, ByteBufCodecs.optional(CommandOutput.STREAM_CODEC), AltarRecipe::commands, SizedIngredient.STREAM_CODEC.apply(ByteBufCodecs.list()), AltarRecipe::itemInputs, EntityInfo.STREAM_CODEC.apply(ByteBufCodecs.list()), AltarRecipe::entityInputs, ConditionStreamCodecs.CONDITION_STREAM_CODEC.apply(ByteBufCodecs.list()), AltarRecipe::startConditions, BlockPos.STREAM_CODEC, AltarRecipe::zone, ByteBufCodecs.VAR_INT, AltarRecipe::ticks, AltarRecipe::new);

    private static DataResult<AltarRecipe> validateRecipe(AltarRecipe recipe) {
        if (recipe.initiator().isEmpty()) {
            return DataResult.error(() -> "initiator is empty");
        }
        if (recipe.itemInputs().isEmpty() && recipe.entityInputs().isEmpty()) {
            return DataResult.error(() -> "no item or entity inputs");
        }
        if (recipe.itemInputs().size() > (Integer)Config.COMMON.inventorySize.get()) {
            return DataResult.error(() -> "too many inputs, max is " + String.valueOf(Config.COMMON.inventorySize.get()));
        }
        if (recipe.itemOutputs().isEmpty() && recipe.entityOutputs().isEmpty() && recipe.commands().isEmpty()) {
            return DataResult.error(() -> "no item, entity or command outputs");
        }
        return DataResult.success((Object)recipe);
    }

    public MapCodec<AltarRecipe> codec() {
        return CODEC;
    }

    public StreamCodec<RegistryFriendlyByteBuf, AltarRecipe> streamCodec() {
        return STREAM_CODEC;
    }
}

