/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.summoningrituals.recipe;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;

public record EntityInfo(Holder<EntityType<?>> entity, int count, Optional<CompoundTag> data, List<Component> tooltip) implements Predicate<Entity>
{
    public static final Codec<EntityInfo> CODEC = RecordCodecBuilder.create(i -> i.group((App)BuiltInRegistries.ENTITY_TYPE.holderByNameCodec().fieldOf("id").forGetter(EntityInfo::entity), (App)Codec.INT.fieldOf("count").forGetter(EntityInfo::count), (App)CompoundTag.CODEC.optionalFieldOf("data").forGetter(EntityInfo::data), (App)ComponentSerialization.CODEC.listOf().fieldOf("tooltip").forGetter(EntityInfo::tooltip)).apply((Applicative)i, EntityInfo::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, EntityInfo> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.holderRegistry((ResourceKey)Registries.ENTITY_TYPE), EntityInfo::entity, (StreamCodec)ByteBufCodecs.VAR_INT, EntityInfo::count, (StreamCodec)ByteBufCodecs.optional((StreamCodec)ByteBufCodecs.COMPOUND_TAG), EntityInfo::data, (StreamCodec)ComponentSerialization.STREAM_CODEC.apply(ByteBufCodecs.list()), EntityInfo::tooltip, EntityInfo::new);

    @Override
    public boolean test(Entity entity) {
        return entity.isAlive() && ((EntityType)this.entity.value()).equals(entity.getType());
    }
}

