/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.summoningrituals.recipe;

import com.almostreliable.summoningrituals.data.SummoningLang;
import com.almostreliable.summoningrituals.recipe.RecipeInfoContainer;
import com.google.common.base.Preconditions;
import java.util.Set;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public final class RecipeMatchResult {
    public static final RecipeMatchResult INVALID_INITIATOR = new RecipeMatchResult(Set.of(), MatchIssue.INITIATOR);
    public static final RecipeMatchResult MISSING_SACRIFICES = new RecipeMatchResult(Set.of(), MatchIssue.SACRIFICES);
    public static final RecipeMatchResult FAILED_CONDITIONS = new RecipeMatchResult(Set.of(), MatchIssue.CONDITIONS);
    public static final RecipeMatchResult MULTI_MATCH = new RecipeMatchResult(Set.of(), MatchIssue.MULTI);
    private final Set<RecipeInfoContainer> matchingRecipes;
    private final MatchIssue matchIssue;
    @Nullable
    private ItemStack interactionRemainder;

    private RecipeMatchResult(Set<RecipeInfoContainer> matchingRecipes, MatchIssue matchIssue) {
        this.matchingRecipes = matchingRecipes;
        this.matchIssue = matchIssue;
    }

    public static RecipeMatchResult of(Set<RecipeInfoContainer> matchingRecipes) {
        return new RecipeMatchResult(matchingRecipes, MatchIssue.NONE);
    }

    public boolean hasIssue() {
        return this.matchIssue != MatchIssue.NONE;
    }

    public MatchIssue getMatchIssue() {
        return this.matchIssue;
    }

    public void setInteractionRemainder(@Nullable ItemStack interactionRemainder) {
        this.interactionRemainder = interactionRemainder;
    }

    @Nullable
    public ItemStack getInteractionRemainder() {
        return this.interactionRemainder;
    }

    public RecipeInfoContainer getMatchingRecipe() {
        Preconditions.checkState((this.matchingRecipes.size() == 1 ? 1 : 0) != 0, (Object)"More than one matching recipe");
        return this.matchingRecipes.iterator().next();
    }

    public static enum MatchIssue {
        INITIATOR(SummoningLang.INVALID_INITIATOR),
        SACRIFICES(SummoningLang.MISSING_SACRIFICES),
        CONDITIONS(SummoningLang.FAILED_CONDITIONS),
        MULTI(SummoningLang.MULTI_MATCH),
        NONE(null);

        @Nullable
        private final SummoningLang.LangEntry langEntry;

        private MatchIssue(SummoningLang.LangEntry langEntry) {
            this.langEntry = langEntry;
        }

        public SummoningLang.LangEntry getIssueMessage() {
            Preconditions.checkNotNull((Object)this.langEntry, (Object)"Issue has no message");
            return this.langEntry;
        }
    }
}

