/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.summoningrituals.recipe.condition;

import com.almostreliable.summoningrituals.data.SummoningLang;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;

public interface ConditionHandler<T extends LootItemCondition> {
    public static final SummoningLang.LangEntry YES = SummoningLang.LangEntry.condition("yes", "Yes");
    public static final SummoningLang.LangEntry NO = SummoningLang.LangEntry.condition("no", "No");
    public static final SummoningLang.LangEntry MINIMUM = SummoningLang.LangEntry.condition("minimum", "Minimum");
    public static final SummoningLang.LangEntry MAXIMUM = SummoningLang.LangEntry.condition("maximum", "Maximum");

    public StreamCodec<RegistryFriendlyByteBuf, T> getStreamCodec();

    public void getTooltip(List<Component> var1, T var2);

    default public MutableComponent conditionNameComponent(Component name) {
        return Component.literal((String)"- ").append(name).append(": ");
    }

    default public MutableComponent conditionNamedValueComponent(Component name, Object value) {
        return Component.literal((String)"> ").append(name).append(": ").withStyle(ChatFormatting.GRAY).append((Component)Component.literal((String)value.toString()).withStyle(ChatFormatting.AQUA));
    }

    default public MutableComponent conditionValueComponent(Object value) {
        return Component.literal((String)"> ").withStyle(ChatFormatting.GRAY).append((Component)Component.literal((String)value.toString()).withStyle(ChatFormatting.AQUA));
    }

    default public MutableComponent conditionNameValueComponent(Component name, MutableComponent value) {
        return this.conditionNameComponent(name).append((Component)value.withStyle(ChatFormatting.AQUA));
    }

    default public MutableComponent conditionNameValueComponent(Component name, String value) {
        return this.conditionNameComponent(name).append((Component)Component.literal((String)value).withStyle(ChatFormatting.AQUA));
    }
}

