/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.summoningrituals.recipe.condition;

import com.almostreliable.summoningrituals.recipe.condition.ConditionHandler;
import com.almostreliable.summoningrituals.recipe.condition.LocationCondition;
import com.almostreliable.summoningrituals.recipe.condition.TimeCondition;
import com.almostreliable.summoningrituals.recipe.condition.WeatherCondition;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionType;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditions;

public final class ConditionRegistry {
    public static final Map<LootItemConditionType, ConditionHandler<?>> CONDITION_REGISTRY = new HashMap();

    private ConditionRegistry() {
    }

    public static void init() {
        CONDITION_REGISTRY.put(LootItemConditions.LOCATION_CHECK, LocationCondition.INSTANCE);
        CONDITION_REGISTRY.put(LootItemConditions.TIME_CHECK, TimeCondition.INSTANCE);
        CONDITION_REGISTRY.put(LootItemConditions.WEATHER_CHECK, WeatherCondition.INSTANCE);
    }

    public static <T extends LootItemCondition> ConditionHandler<T> getOrThrow(LootItemConditionType type) {
        ConditionRegistry.validate(type);
        return CONDITION_REGISTRY.get(type);
    }

    public static List<Component> getTooltip(LootItemCondition condition) {
        ArrayList<Component> tooltip = new ArrayList<Component>();
        ConditionHandler<LootItemCondition> handler = ConditionRegistry.getOrThrow(condition.getType());
        handler.getTooltip(tooltip, condition);
        return tooltip;
    }

    private static void validate(LootItemConditionType type) {
        if (!CONDITION_REGISTRY.containsKey(type)) {
            throw new UnsupportedOperationException("missing condition handler for " + String.valueOf(type));
        }
    }
}

