/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.summoningrituals.recipe.condition;

import com.almostreliable.summoningrituals.recipe.condition.ConditionHandler;
import com.almostreliable.summoningrituals.recipe.condition.ConditionRegistry;
import com.almostreliable.summoningrituals.util.CodecUtils;
import com.almostreliable.summoningrituals.util.RawHolderSetStreamCodec;
import com.mojang.serialization.Codec;
import java.util.Optional;
import net.minecraft.advancements.critereon.LocationPredicate;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.storage.loot.IntRange;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionType;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.NumberProviders;

public final class ConditionStreamCodecs {
    public static final StreamCodec<RegistryFriendlyByteBuf, NumberProvider> NUMBER_PROVIDER_STREAM_CODEC = ByteBufCodecs.fromCodecWithRegistries((Codec)NumberProviders.CODEC);
    public static final StreamCodec<RegistryFriendlyByteBuf, IntRange> INT_RANGE_STREAM_CODEC = ByteBufCodecs.fromCodecWithRegistries((Codec)IntRange.CODEC);
    public static final StreamCodec<FriendlyByteBuf, MinMaxBounds.Doubles> DOUBLES_BOUNDS_STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.optional((StreamCodec)ByteBufCodecs.DOUBLE), MinMaxBounds.Doubles::min, (StreamCodec)ByteBufCodecs.optional((StreamCodec)ByteBufCodecs.DOUBLE), MinMaxBounds.Doubles::max, (StreamCodec)ByteBufCodecs.optional((StreamCodec)ByteBufCodecs.DOUBLE), MinMaxBounds.Doubles::minSq, (StreamCodec)ByteBufCodecs.optional((StreamCodec)ByteBufCodecs.DOUBLE), MinMaxBounds.Doubles::maxSq, MinMaxBounds.Doubles::new);
    public static final StreamCodec<FriendlyByteBuf, LocationPredicate.PositionPredicate> POSITION_PREDICATE_STREAM_CODEC = StreamCodec.composite(DOUBLES_BOUNDS_STREAM_CODEC, LocationPredicate.PositionPredicate::x, DOUBLES_BOUNDS_STREAM_CODEC, LocationPredicate.PositionPredicate::y, DOUBLES_BOUNDS_STREAM_CODEC, LocationPredicate.PositionPredicate::z, LocationPredicate.PositionPredicate::new);
    public static final StreamCodec<RegistryFriendlyByteBuf, LocationPredicate> LOCATION_PREDICATE_STREAM_CODEC = CodecUtils.composite(ByteBufCodecs.optional(POSITION_PREDICATE_STREAM_CODEC), LocationPredicate::position, ByteBufCodecs.optional((StreamCodec)ByteBufCodecs.holderSet((ResourceKey)Registries.BIOME)), LocationPredicate::biomes, ByteBufCodecs.optional(new RawHolderSetStreamCodec(Registries.STRUCTURE)), LocationPredicate::structures, ByteBufCodecs.optional((StreamCodec)ResourceKey.streamCodec((ResourceKey)Registries.DIMENSION)), LocationPredicate::dimension, CodecUtils.emptyOptionalStreamCodec(), $ -> Optional.empty(), CodecUtils.emptyOptionalStreamCodec(), $ -> Optional.empty(), CodecUtils.emptyOptionalStreamCodec(), $ -> Optional.empty(), CodecUtils.emptyOptionalStreamCodec(), $ -> Optional.empty(), ByteBufCodecs.optional((StreamCodec)ByteBufCodecs.BOOL), LocationPredicate::canSeeSky, LocationPredicate::new);
    public static final StreamCodec<RegistryFriendlyByteBuf, LootItemCondition> CONDITION_STREAM_CODEC = new StreamCodec<RegistryFriendlyByteBuf, LootItemCondition>(){

        public LootItemCondition decode(RegistryFriendlyByteBuf buffer) {
            LootItemConditionType type = (LootItemConditionType)BuiltInRegistries.LOOT_CONDITION_TYPE.byIdOrThrow((int)buffer.readByte());
            ConditionHandler conditionHandler = ConditionRegistry.getOrThrow(type);
            StreamCodec streamCodec = conditionHandler.getStreamCodec();
            return (LootItemCondition)streamCodec.decode((Object)buffer);
        }

        public void encode(RegistryFriendlyByteBuf buffer, LootItemCondition value) {
            int id = BuiltInRegistries.LOOT_CONDITION_TYPE.getId((Object)value.getType());
            buffer.writeByte(id);
            ConditionHandler conditionHandler = ConditionRegistry.getOrThrow(value.getType());
            StreamCodec streamCodec = conditionHandler.getStreamCodec();
            streamCodec.encode((Object)buffer, (Object)value);
        }
    };

    private ConditionStreamCodecs() {
    }
}

