/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.summoningrituals.recipe.condition;

import com.almostreliable.summoningrituals.data.SummoningLang;
import com.almostreliable.summoningrituals.recipe.condition.ConditionHandler;
import com.almostreliable.summoningrituals.recipe.condition.ConditionStreamCodecs;
import com.almostreliable.summoningrituals.util.RawHolderSet;
import com.google.common.base.CaseFormat;
import com.mojang.datafixers.util.Either;
import java.util.List;
import java.util.Optional;
import net.minecraft.advancements.critereon.LocationPredicate;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.storage.loot.predicates.LocationCheck;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.ModList;

public class LocationCondition
implements ConditionHandler<LocationCheck> {
    public static final LocationCondition INSTANCE = new LocationCondition();
    public static final StreamCodec<RegistryFriendlyByteBuf, LocationCheck> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.optional(ConditionStreamCodecs.LOCATION_PREDICATE_STREAM_CODEC), LocationCheck::predicate, (StreamCodec)BlockPos.STREAM_CODEC, LocationCheck::offset, LocationCheck::new);
    private static final SummoningLang.LangEntry BIOMES = SummoningLang.LangEntry.condition("biomes", "Biomes");
    private static final SummoningLang.LangEntry DIMENSION = SummoningLang.LangEntry.condition("dimension", "Dimension");
    private static final SummoningLang.LangEntry HEIGHT = SummoningLang.LangEntry.condition("height", "Height");
    private static final SummoningLang.LangEntry OPEN_SKY = SummoningLang.LangEntry.condition("open_sky", "Open Sky");
    private static final SummoningLang.LangEntry STRUCTURES = SummoningLang.LangEntry.condition("structures", "Structures");

    @Override
    public StreamCodec<RegistryFriendlyByteBuf, LocationCheck> getStreamCodec() {
        return STREAM_CODEC;
    }

    @Override
    public void getTooltip(List<Component> tooltip, LocationCheck condition) {
        Optional opt = condition.predicate();
        if (opt.isEmpty()) {
            return;
        }
        LocationPredicate predicate = (LocationPredicate)opt.get();
        if (predicate.biomes().isPresent()) {
            tooltip.add((Component)this.conditionNameComponent((Component)BIOMES.get()));
            this.getHolderSetTooltip(tooltip, (HolderSet)predicate.biomes().get());
        }
        if (predicate.dimension().isPresent()) {
            ResourceKey dimension = (ResourceKey)predicate.dimension().get();
            tooltip.add((Component)this.conditionNameValueComponent((Component)DIMENSION.get(), LocationCondition.getReadableId(dimension.location())));
        }
        if (predicate.position().isPresent()) {
            LocationPredicate.PositionPredicate position = (LocationPredicate.PositionPredicate)predicate.position().get();
            MinMaxBounds.Doubles yPos = position.y();
            this.getHeightTooltip(tooltip, yPos);
        }
        if (predicate.canSeeSky().isPresent()) {
            Boolean openSky = (Boolean)predicate.canSeeSky().get();
            MutableComponent value = (openSky != false ? YES : NO).get();
            tooltip.add((Component)this.conditionNameValueComponent((Component)OPEN_SKY.get(), value));
        }
        if (predicate.structures().isPresent()) {
            tooltip.add((Component)this.conditionNameComponent((Component)STRUCTURES.get()));
            this.getHolderSetTooltip(tooltip, (HolderSet)predicate.structures().get());
        }
    }

    private void getHeightTooltip(List<Component> tooltip, MinMaxBounds.Doubles yPos) {
        Optional min = yPos.min();
        Optional max = yPos.max();
        if (min.isPresent() && max.isPresent()) {
            int maxValue;
            int minValue = ((Double)min.get()).intValue();
            if (minValue == (maxValue = ((Double)max.get()).intValue())) {
                tooltip.add((Component)this.conditionNameValueComponent((Component)HEIGHT.get(), String.valueOf(minValue)));
                return;
            }
            tooltip.add((Component)this.conditionNameComponent((Component)HEIGHT.get()));
            tooltip.add((Component)this.conditionNamedValueComponent((Component)MINIMUM.get(), String.valueOf(minValue)));
            tooltip.add((Component)this.conditionNamedValueComponent((Component)MAXIMUM.get(), String.valueOf(maxValue)));
            return;
        }
        if (min.isPresent()) {
            int minValue = ((Double)min.get()).intValue();
            MutableComponent name = MINIMUM.get().append(" ").append((Component)HEIGHT.get());
            tooltip.add((Component)this.conditionNameValueComponent((Component)name, String.valueOf(minValue)));
            return;
        }
        if (max.isPresent()) {
            int maxValue = ((Double)max.get()).intValue();
            MutableComponent name = MAXIMUM.get().append(" ").append((Component)HEIGHT.get());
            tooltip.add((Component)this.conditionNameValueComponent((Component)name, String.valueOf(maxValue)));
        }
    }

    private void getHolderSetTooltip(List<Component> tooltip, HolderSet<?> holders) {
        if (holders instanceof RawHolderSet) {
            RawHolderSet rawHolderSet = (RawHolderSet)holders;
            if (rawHolderSet.tag().isPresent()) {
                TagKey tag2 = rawHolderSet.tag().get();
                String tagId = tag2.location().toString();
                tooltip.add((Component)this.conditionValueComponent("#" + tagId));
                return;
            }
            if (rawHolderSet.ids().isEmpty()) {
                return;
            }
            List<ResourceLocation> ids = rawHolderSet.ids().get();
            for (ResourceLocation id : ids) {
                String readableId = LocationCondition.getReadableId(id);
                tooltip.add((Component)this.conditionValueComponent(readableId));
            }
            return;
        }
        Either holderValue = holders.unwrap();
        holderValue.ifLeft(tag -> {
            String tagId = tag.location().toString();
            tooltip.add((Component)this.conditionValueComponent("#" + tagId));
        });
        holderValue.ifRight(holderList -> {
            for (Holder holder : holderList) {
                Optional resourceKey = holder.unwrapKey();
                if (resourceKey.isEmpty()) {
                    tooltip.add((Component)this.conditionValueComponent("unknown"));
                    continue;
                }
                String readableId = LocationCondition.getReadableId(((ResourceKey)resourceKey.get()).location());
                tooltip.add((Component)this.conditionValueComponent(readableId));
            }
        });
    }

    private static String getReadableId(ResourceLocation id) {
        String namespace = id.getNamespace();
        String path = id.getPath();
        String readableName = CaseFormat.LOWER_UNDERSCORE.to(CaseFormat.UPPER_CAMEL, path);
        if (!namespace.equals("minecraft")) {
            Optional modContainer = ModList.get().getModContainerById(namespace);
            if (modContainer.isEmpty()) {
                return readableName + " (" + namespace + ")";
            }
            String modName = ((ModContainer)modContainer.get()).getModInfo().getDisplayName();
            return readableName + " (" + modName + ")";
        }
        return readableName;
    }
}

