/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.summoningrituals.recipe.condition;

import com.almostreliable.summoningrituals.data.SummoningLang;
import com.almostreliable.summoningrituals.recipe.condition.ConditionHandler;
import com.almostreliable.summoningrituals.recipe.condition.ConditionStreamCodecs;
import java.util.List;
import java.util.Map;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.level.storage.loot.IntRange;
import net.minecraft.world.level.storage.loot.predicates.TimeCheck;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import org.jetbrains.annotations.Nullable;

public class TimeCondition
implements ConditionHandler<TimeCheck> {
    public static final TimeCondition INSTANCE = new TimeCondition();
    private static final StreamCodec<RegistryFriendlyByteBuf, TimeCheck> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.optional((StreamCodec)ByteBufCodecs.VAR_LONG), TimeCheck::period, ConditionStreamCodecs.INT_RANGE_STREAM_CODEC, TimeCheck::value, TimeCheck::new);
    private static final SummoningLang.LangEntry TIME = SummoningLang.LangEntry.condition("time", "Time");
    private static final Map<TimeType, SummoningLang.LangEntry> TIME_TYPES = SummoningLang.LangEntry.enumValues((String)"condition", (String)"time", (Enum[])TimeType.values());

    @Override
    public StreamCodec<RegistryFriendlyByteBuf, TimeCheck> getStreamCodec() {
        return STREAM_CODEC;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void getTooltip(List<Component> tooltip, TimeCheck condition) {
        float minConstant;
        float f;
        float maxConstant;
        NumberProvider max;
        NumberProvider min;
        block9: {
            ConstantValue constantValue;
            block8: {
                IntRange range = condition.value();
                min = range.min;
                max = range.max;
                if (min instanceof ConstantValue) {
                    float f2;
                    constantValue = (ConstantValue)min;
                    float minConstant2 = f2 = constantValue.value();
                    if (max != null) break block8;
                    int minValue2 = (int)minConstant2;
                    MutableComponent name = MINIMUM.get().append(" ").append((Component)TIME.get());
                    tooltip.add((Component)this.conditionNameValueComponent((Component)name, String.valueOf(minValue2)));
                    return;
                }
            }
            if (max instanceof ConstantValue) {
                float minValue2;
                constantValue = (ConstantValue)max;
                maxConstant = minValue2 = constantValue.value();
                if (min != null) break block9;
                int maxValue2 = (int)maxConstant;
                MutableComponent name = MAXIMUM.get().append(" ").append((Component)TIME.get());
                tooltip.add((Component)this.conditionNameValueComponent((Component)name, String.valueOf(maxValue2)));
                return;
            }
        }
        if (!(min instanceof ConstantValue)) return;
        ConstantValue maxValue2 = (ConstantValue)min;
        try {
            minConstant = f = maxValue2.value();
        }
        catch (Throwable throwable) {
            throw new MatchException(throwable.toString(), throwable);
        }
        if (!(max instanceof ConstantValue)) return;
        ConstantValue name = (ConstantValue)max;
        maxConstant = f = name.value();
        int minValue = (int)minConstant;
        int maxValue = (int)maxConstant;
        TimeType timeType = TimeType.of(minValue, maxValue);
        if (timeType != null) {
            tooltip.add((Component)this.conditionNameValueComponent((Component)TIME.get(), TIME_TYPES.get((Object)timeType).get()));
            return;
        }
        tooltip.add((Component)this.conditionNameComponent((Component)TIME.get()));
        tooltip.add((Component)this.conditionNamedValueComponent((Component)MINIMUM.get(), minValue));
        tooltip.add((Component)this.conditionNamedValueComponent((Component)MAXIMUM.get(), maxValue));
    }

    public static enum TimeType {
        DAY(0, 12000),
        NIGHT(12000, 24000),
        MORNING(0, 4000),
        NOON(4000, 8000),
        AFTERNOON(8000, 10000),
        EVENING(10000, 12000),
        MIDNIGHT(17000, 19000);

        private final int min;
        private final int max;
        public final IntRange range;

        private TimeType(int min, int max) {
            this.min = min;
            this.max = max;
            this.range = IntRange.range((int)min, (int)max);
        }

        @Nullable
        private static TimeType of(int min, int max) {
            for (TimeType type : TimeType.values()) {
                if (type.min != min || type.max != max) continue;
                return type;
            }
            return null;
        }
    }
}

