/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.summoningrituals.recipe.condition;

import com.almostreliable.summoningrituals.data.SummoningLang;
import com.almostreliable.summoningrituals.recipe.condition.ConditionHandler;
import java.util.List;
import java.util.Optional;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.level.storage.loot.predicates.WeatherCheck;
import org.jetbrains.annotations.Nullable;

public class WeatherCondition
implements ConditionHandler<WeatherCheck> {
    public static final WeatherCondition INSTANCE = new WeatherCondition();
    private static final StreamCodec<RegistryFriendlyByteBuf, WeatherCheck> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.optional((StreamCodec)ByteBufCodecs.BOOL), WeatherCheck::isRaining, (StreamCodec)ByteBufCodecs.optional((StreamCodec)ByteBufCodecs.BOOL), WeatherCheck::isThundering, WeatherCheck::new);
    private static final SummoningLang.LangEntry WEATHER = SummoningLang.LangEntry.condition("weather", "Weather");
    private static final SummoningLang.LangEntry THUNDERING = SummoningLang.LangEntry.condition("weather_thundering", "Thundering");
    private static final SummoningLang.LangEntry NOT_THUNDERING = SummoningLang.LangEntry.condition("weather_not_thundering", "Not Thundering");
    private static final SummoningLang.LangEntry RAINING = SummoningLang.LangEntry.condition("weather_raining", "Raining");
    private static final SummoningLang.LangEntry CLEAR = SummoningLang.LangEntry.condition("weather_clear", "Clear");

    @Override
    public StreamCodec<RegistryFriendlyByteBuf, WeatherCheck> getStreamCodec() {
        return STREAM_CODEC;
    }

    @Override
    public void getTooltip(List<Component> tooltip, WeatherCheck condition) {
        SummoningLang.LangEntry description = WeatherCondition.getDescription(condition.isRaining(), condition.isThundering());
        if (description != null) {
            tooltip.add((Component)this.conditionNameValueComponent((Component)WEATHER.get(), description.get()));
        }
    }

    @Nullable
    private static SummoningLang.LangEntry getDescription(Optional<Boolean> rain, Optional<Boolean> thunder) {
        if (thunder.isPresent()) {
            if (thunder.get().booleanValue()) {
                return THUNDERING;
            }
            if (rain.isPresent()) {
                if (!rain.get().booleanValue()) {
                    return CLEAR;
                }
                return RAINING;
            }
            return NOT_THUNDERING;
        }
        return rain.map(r -> r != false ? RAINING : CLEAR).orElse(null);
    }

    public static final class Builder {
        private Optional<Boolean> isRaining = Optional.empty();
        private Optional<Boolean> isThundering = Optional.empty();

        public Builder setRaining(boolean isRaining) {
            this.isRaining = Optional.of(isRaining);
            return this;
        }

        public Builder setThundering(boolean isThundering) {
            this.isThundering = Optional.of(isThundering);
            return this;
        }

        public WeatherCheck build() {
            if (this.isRaining.isEmpty() && this.isThundering.isEmpty()) {
                throw new IllegalArgumentException("weather condition must have at least one of raining or thundering");
            }
            if (this.isRaining.isPresent() && this.isThundering.isPresent() && !this.isRaining.get().booleanValue() && this.isThundering.get().booleanValue()) {
                throw new IllegalArgumentException("weather condition cannot be thundering but not raining");
            }
            return new WeatherCheck(this.isRaining, this.isThundering);
        }
    }
}

