/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.summoningrituals.recipe.output;

import com.almostreliable.summoningrituals.SummoningRituals;
import com.almostreliable.summoningrituals.core.Config;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import org.jetbrains.annotations.Nullable;

public record CommandOutput(List<String> commands, List<Component> tooltip, boolean requiresPlayer) {
    public static final Codec<CommandOutput> CODEC = RecordCodecBuilder.create(i -> i.group((App)Codec.STRING.listOf().fieldOf("commands").forGetter(CommandOutput::commands), (App)ComponentSerialization.CODEC.listOf().fieldOf("tooltip").forGetter(CommandOutput::tooltip), (App)Codec.BOOL.optionalFieldOf("requires_player", (Object)true).forGetter(CommandOutput::requiresPlayer)).apply((Applicative)i, CommandOutput::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, CommandOutput> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.STRING_UTF8.apply(ByteBufCodecs.list()), CommandOutput::commands, (StreamCodec)ComponentSerialization.STREAM_CODEC.apply(ByteBufCodecs.list()), CommandOutput::tooltip, (StreamCodec)ByteBufCodecs.BOOL, CommandOutput::requiresPlayer, CommandOutput::new);
    public static final CommandOutput EMPTY = new CommandOutput(List.of(), List.of(), true);

    public CommandOutput(List<String> commands, List<Component> tooltip) {
        this(commands, tooltip, true);
    }

    public CommandOutput(List<String> commands) {
        this(commands, List.of(), true);
    }

    public CommandOutput(String command) {
        this(List.of(command), List.of(), true);
    }

    public void invoke(ServerLevel level, @Nullable ServerPlayer player) {
        CommandSourceStack commandSourceStack = level.getServer().createCommandSourceStack();
        if (this.requiresPlayer) {
            if (player == null) {
                return;
            }
            commandSourceStack = commandSourceStack.withEntity((Entity)player);
        }
        for (String command : this.commands) {
            if (((Boolean)Config.COMMON.announceCommand.get()).booleanValue()) {
                SummoningRituals.LOGGER.info("Executing ritual output command: {}", (Object)command);
            }
            level.getServer().getCommands().performPrefixedCommand(commandSourceStack, command);
        }
    }

    public List<Component> getTooltip() {
        ArrayList<Component> tooltips = new ArrayList<Component>();
        if (this.tooltip.isEmpty()) {
            for (String command : this.commands) {
                tooltips.add((Component)Component.literal((String)"- ").append(command));
            }
        } else {
            tooltips.addAll(this.tooltip);
        }
        return tooltips;
    }
}

