/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.summoningrituals.recipe.output;

import com.almostreliable.summoningrituals.recipe.EntityInfo;
import com.almostreliable.summoningrituals.recipe.output.RecipeOutput;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public record EntityOutput(EntityInfo entityInfo, Optional<BlockPos> offset, Optional<BlockPos> spread) implements RecipeOutput<Entity>
{
    public static final Codec<EntityOutput> CODEC = RecordCodecBuilder.create(i -> i.group((App)EntityInfo.CODEC.fieldOf("entity").forGetter(EntityOutput::entityInfo), (App)BlockPos.CODEC.optionalFieldOf("offset").forGetter(EntityOutput::offset), (App)BlockPos.CODEC.optionalFieldOf("spread").forGetter(EntityOutput::spread)).apply((Applicative)i, EntityOutput::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, EntityOutput> STREAM_CODEC = StreamCodec.composite(EntityInfo.STREAM_CODEC, EntityOutput::entityInfo, (StreamCodec)ByteBufCodecs.optional((StreamCodec)BlockPos.STREAM_CODEC), EntityOutput::offset, (StreamCodec)ByteBufCodecs.optional((StreamCodec)BlockPos.STREAM_CODEC), EntityOutput::spread, EntityOutput::new);

    @Override
    public Collection<Entity> spawn(ServerLevel level, BlockPos origin) {
        ArrayList<Entity> result = new ArrayList<Entity>();
        for (int toSpawn = this.entityInfo.count(); toSpawn > 0; --toSpawn) {
            Entity entity = ((EntityType)this.entityInfo.entity().value()).create((Level)level);
            if (entity == null) {
                return List.of();
            }
            Vec3 pos = this.getRandomPos(origin);
            entity.setPos(pos);
            this.entityInfo.data().ifPresent(data -> {
                CompoundTag newData = new CompoundTag();
                entity.saveWithoutId(newData);
                newData.merge(data);
                entity.load(newData);
            });
            level.addFreshEntity(entity);
            result.add(entity);
        }
        return result;
    }
}

