/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.summoningrituals.recipe.output;

import com.almostreliable.summoningrituals.recipe.output.RecipeOutput;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public record ItemOutput(ItemStack item, Optional<BlockPos> offset, Optional<BlockPos> spread) implements RecipeOutput<ItemEntity>
{
    public static final Codec<ItemOutput> CODEC = RecordCodecBuilder.create(i -> i.group((App)ItemStack.STRICT_CODEC.fieldOf("item").forGetter(ItemOutput::item), (App)BlockPos.CODEC.optionalFieldOf("offset").forGetter(ItemOutput::offset), (App)BlockPos.CODEC.optionalFieldOf("spread").forGetter(ItemOutput::spread)).apply((Applicative)i, ItemOutput::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, ItemOutput> STREAM_CODEC = StreamCodec.composite((StreamCodec)ItemStack.STREAM_CODEC, ItemOutput::item, (StreamCodec)ByteBufCodecs.optional((StreamCodec)BlockPos.STREAM_CODEC), ItemOutput::offset, (StreamCodec)ByteBufCodecs.optional((StreamCodec)BlockPos.STREAM_CODEC), ItemOutput::spread, ItemOutput::new);

    @Override
    public Collection<ItemEntity> spawn(ServerLevel level, BlockPos origin) {
        ItemStack stack;
        ArrayList<ItemEntity> result = new ArrayList<ItemEntity>();
        for (int toSpawn = this.item.getCount(); toSpawn > 0; toSpawn -= stack.getCount()) {
            stack = this.item.copyWithCount(Math.min(toSpawn, 4));
            Vec3 pos = this.getRandomPos(origin);
            ItemEntity entity = new ItemEntity((Level)level, pos.x(), pos.y(), pos.z(), stack);
            level.addFreshEntity((Entity)entity);
            result.add(entity);
        }
        return result;
    }
}

