/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.summoningrituals.recipe.output;

import java.util.Collection;
import java.util.Optional;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3;

public interface RecipeOutput<T extends Entity> {
    public static final BlockPos DEFAULT_OFFSET = new BlockPos(0, 2, 0);
    public static final BlockPos DEFAULT_SPREAD = new BlockPos(1, 0, 1);
    public static final Random RANDOM = new Random();

    default public Vec3 getRandomPos(BlockPos origin) {
        BlockPos offset = this.offset().orElse(DEFAULT_OFFSET);
        Vec3 offsetVector = new Vec3((double)offset.getX(), (double)offset.getY(), (double)offset.getZ());
        BlockPos spread = this.spread().orElse(DEFAULT_SPREAD);
        double x = spread.getX() > 0 ? RANDOM.nextDouble(-spread.getX(), spread.getX()) / 2.0 : 0.0;
        double y = spread.getY() > 0 ? RANDOM.nextDouble(-spread.getY(), spread.getY()) / 2.0 : 0.0;
        double z = spread.getZ() > 0 ? RANDOM.nextDouble(-spread.getZ(), spread.getZ()) / 2.0 : 0.0;
        return Vec3.atCenterOf((Vec3i)origin).add(offsetVector).add(x, y, z);
    }

    public Collection<T> spawn(ServerLevel var1, BlockPos var2);

    public Optional<BlockPos> spread();

    public Optional<BlockPos> offset();
}

