/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.summoningrituals.util;

import com.mojang.datafixers.util.Either;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderOwner;
import net.minecraft.core.HolderSet;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;

public record RawHolderSet<T>(Optional<List<ResourceLocation>> ids, Optional<TagKey<T>> tag, Optional<Tag> otherData) implements HolderSet<T>
{
    public Stream<Holder<T>> stream() {
        return Stream.empty();
    }

    public int size() {
        return 0;
    }

    public Either<TagKey<T>, List<Holder<T>>> unwrap() {
        if (this.tag.isPresent()) {
            return Either.left(this.tag.get());
        }
        return Either.right(Collections.emptyList());
    }

    public Optional<Holder<T>> getRandomElement(RandomSource random) {
        return Optional.empty();
    }

    public Holder<T> get(int index) {
        throw new IndexOutOfBoundsException("RawHolderSet does not support get(int)");
    }

    public boolean contains(Holder<T> holder) {
        return false;
    }

    public boolean canSerializeIn(HolderOwner<T> owner) {
        return false;
    }

    public Optional<TagKey<T>> unwrapKey() {
        return this.tag;
    }

    public Iterator<Holder<T>> iterator() {
        return Collections.emptyIterator();
    }

    @Override
    public String toString() {
        ArrayList<String> holderNames = new ArrayList<String>();
        if (this.ids.isPresent()) {
            for (ResourceLocation id : this.ids.get()) {
                holderNames.add(id.toString());
            }
        }
        if (this.tag.isPresent()) {
            holderNames.add(this.tag.get().location().toString());
        }
        return String.join((CharSequence)", ", holderNames);
    }
}

