/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.summoningrituals.util;

import com.almostreliable.summoningrituals.util.RawHolderSet;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.RegistryCodecs;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtAccounter;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;

public class RawHolderSetStreamCodec<T>
implements StreamCodec<RegistryFriendlyByteBuf, HolderSet<T>> {
    private static final long TWO_MEBIBYTES = 0x200000L;
    private final ResourceKey<? extends Registry<T>> registryKey;
    private final Codec<HolderSet<T>> originalCodec;
    private final StreamCodec<ByteBuf, Tag> nbtCodec = ByteBufCodecs.tagCodec(() -> NbtAccounter.create((long)0x200000L));

    public RawHolderSetStreamCodec(ResourceKey<? extends Registry<T>> registryKey) {
        this.registryKey = registryKey;
        this.originalCodec = RegistryCodecs.homogeneousList(registryKey);
    }

    public HolderSet<T> decode(RegistryFriendlyByteBuf buffer) {
        Tag tag = (Tag)this.nbtCodec.decode((Object)buffer);
        RegistryAccess registryAccess = buffer.registryAccess();
        Optional registry = registryAccess.registry(this.registryKey);
        if (registry.isPresent()) {
            RegistryOps regOps = registryAccess.createSerializationContext((DynamicOps)NbtOps.INSTANCE);
            return (HolderSet)this.originalCodec.parse((DynamicOps)regOps, (Object)tag).getOrThrow();
        }
        if (tag.getType().equals((Object)StringTag.TYPE)) {
            String idOrTag = tag.getAsString();
            if (idOrTag.startsWith("#")) {
                String tagRaw = idOrTag.substring(1);
                TagKey tagKey = TagKey.create(this.registryKey, (ResourceLocation)ResourceLocation.parse((String)tagRaw));
                return new RawHolderSet(Optional.empty(), Optional.of(tagKey), Optional.empty());
            }
            ResourceLocation id = ResourceLocation.parse((String)idOrTag);
            return new RawHolderSet(Optional.of(List.of(id)), Optional.empty(), Optional.empty());
        }
        if (tag instanceof ListTag) {
            ListTag list = (ListTag)tag;
            ArrayList<ResourceLocation> ids = new ArrayList<ResourceLocation>();
            for (Tag t : list) {
                if (!t.getType().equals((Object)StringTag.TYPE)) continue;
                ids.add(ResourceLocation.parse((String)t.getAsString()));
            }
            return new RawHolderSet(Optional.of(ids), Optional.empty(), Optional.empty());
        }
        return new RawHolderSet(Optional.empty(), Optional.empty(), Optional.of(tag));
    }

    public void encode(RegistryFriendlyByteBuf buffer, HolderSet<T> value) {
        RegistryAccess registryAccess = buffer.registryAccess();
        Optional registry = registryAccess.registry(this.registryKey);
        if (registry.isEmpty()) {
            throw new IllegalStateException("registry not found: " + String.valueOf(this.registryKey));
        }
        RegistryOps regOps = registryAccess.createSerializationContext((DynamicOps)NbtOps.INSTANCE);
        try {
            Tag nbt = (Tag)this.originalCodec.encodeStart((DynamicOps)regOps, value).getOrThrow();
            this.nbtCodec.encode((Object)buffer, (Object)nbt);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("failed to encode: " + String.valueOf(value), e);
        }
    }
}

