/*
 * Decompiled with CFR 0.152.
 */
package com.archers_expansion;

import com.archers_expansion.datagen.CraftingRecipeGenerator;
import com.archers_expansion.datagen.SmithingRecipes;
import com.archers_expansion.items.armors.Armors;
import com.archers_expansion.spell.ArchersExpansionSpells;
import java.util.EnumSet;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.fabricmc.fabric.api.datagen.v1.DataGeneratorEntrypoint;
import net.fabricmc.fabric.api.datagen.v1.FabricDataGenerator;
import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput;
import net.fabricmc.fabric.api.datagen.v1.provider.FabricModelProvider;
import net.fabricmc.fabric.api.datagen.v1.provider.FabricRecipeProvider;
import net.fabricmc.fabric.api.datagen.v1.provider.FabricTagProvider;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.models.BlockModelGenerators;
import net.minecraft.data.models.ItemModelGenerators;
import net.minecraft.data.models.model.ModelTemplates;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.spell_engine.api.datagen.SpellGenerator;
import net.spell_engine.api.item.armor.Armor;
import net.spell_engine.rpg_series.datagen.RPGSeriesDataGen;
import net.spell_engine.rpg_series.tags.RPGSeriesItemTags;

public class ArchersExpansionDataGenerator
implements DataGeneratorEntrypoint {
    public void onInitializeDataGenerator(FabricDataGenerator fabricDataGenerator) {
        FabricDataGenerator.Pack pack = fabricDataGenerator.createPack();
        pack.addProvider(ItemTagGenerator::new);
        pack.addProvider(UnsmeltGenerator::new);
        pack.addProvider(SpellGen::new);
        pack.addProvider(ModelProvider::new);
        pack.addProvider(CraftingRecipeGenerator::new);
        pack.addProvider(SmithingRecipes::new);
    }

    public static class UnsmeltGenerator
    extends FabricRecipeProvider {
        public static int UNSMELT_TIME = 300;

        public UnsmeltGenerator(FabricDataOutput output, CompletableFuture<HolderLookup.Provider> registriesFuture) {
            super(output, registriesFuture);
        }

        public void buildRecipes(RecipeOutput exporter) {
            UnsmeltGenerator.disassembleArmor(exporter, Armors.deadeye_t1, Items.LEATHER);
            UnsmeltGenerator.disassembleArmor(exporter, Armors.war_archer_t1, Items.IRON_NUGGET);
            UnsmeltGenerator.disassembleArmor(exporter, Armors.tundra_hunter_t1, Items.LEATHER);
            UnsmeltGenerator.disassembleArmor(exporter, Armors.netherite_deadeye, Items.NETHERITE_SCRAP);
            UnsmeltGenerator.disassembleArmor(exporter, Armors.netherite_war_archer, Items.NETHERITE_SCRAP);
            UnsmeltGenerator.disassembleArmor(exporter, Armors.netherite_tundra_hunter, Items.NETHERITE_SCRAP);
        }

        public String getName() {
            return "Unsmelt Recipes";
        }

        private static void disassembleArmor(RecipeOutput exporter, Armor.Set armorSet, Item output) {
            FabricRecipeProvider.oreSmelting((RecipeOutput)exporter, (List)armorSet.pieces(), (RecipeCategory)RecipeCategory.MISC, (ItemLike)output, (float)0.1f, (int)UNSMELT_TIME, (String)"disassemble");
            FabricRecipeProvider.oreBlasting((RecipeOutput)exporter, (List)armorSet.pieces(), (RecipeCategory)RecipeCategory.MISC, (ItemLike)output, (float)0.1f, (int)(UNSMELT_TIME / 2), (String)"disassemble");
        }
    }

    public static class ItemTagGenerator
    extends RPGSeriesDataGen.ItemTagGenerator {
        public ItemTagGenerator(FabricDataOutput output, CompletableFuture<HolderLookup.Provider> registriesFuture) {
            super(output, registriesFuture);
        }

        public void armorTags(List<Armor.Entry> armors) {
            this.armorTags(armors, EnumSet.noneOf(RPGSeriesItemTags.ArmorMetaType.class));
        }

        public void armorTags(List<Armor.Entry> armors, RPGSeriesItemTags.ArmorMetaType metaType) {
            this.armorTags(armors, EnumSet.of(metaType));
        }

        public void armorTags(List<Armor.Entry> armors, EnumSet<RPGSeriesItemTags.ArmorMetaType> metaTypes) {
            for (Armor.Entry armor : armors) {
                String lootTheme;
                Armor.Set set = armor.armorSet();
                FabricTagProvider.FabricTagBuilder headTag = this.getOrCreateTagBuilder(ItemTags.HEAD_ARMOR);
                headTag.addOptional(set.idOf(set.head));
                FabricTagProvider.FabricTagBuilder chestTag = this.getOrCreateTagBuilder(ItemTags.CHEST_ARMOR);
                chestTag.addOptional(set.idOf(set.chest));
                FabricTagProvider.FabricTagBuilder legsTag = this.getOrCreateTagBuilder(ItemTags.LEG_ARMOR);
                legsTag.addOptional(set.idOf(set.legs));
                FabricTagProvider.FabricTagBuilder feetTag = this.getOrCreateTagBuilder(ItemTags.FOOT_ARMOR);
                feetTag.addOptional(set.idOf(set.feet));
                int tier = armor.lootProperties().tier();
                if (tier >= 0) {
                    FabricTagProvider.FabricTagBuilder tierTag = this.getOrCreateTagBuilder(RPGSeriesItemTags.LootTiers.get((int)tier, (RPGSeriesItemTags.LootCategory)RPGSeriesItemTags.LootCategory.ARMORS));
                    for (Object id : armor.armorSet().pieceIds()) {
                        tierTag.addOptional((ResourceLocation)id);
                    }
                }
                if ((lootTheme = armor.lootProperties().theme()) != null && !lootTheme.isEmpty()) {
                    FabricTagProvider.FabricTagBuilder themeTag = this.getOrCreateTagBuilder(RPGSeriesItemTags.LootThemes.get((String)lootTheme));
                    for (Object id : armor.armorSet().pieceIds()) {
                        themeTag.addOptional((ResourceLocation)id);
                    }
                }
                for (RPGSeriesItemTags.ArmorMetaType metaType : metaTypes) {
                    FabricTagProvider.FabricTagBuilder metaTag = this.getOrCreateTagBuilder(RPGSeriesItemTags.ArmorType.get((RPGSeriesItemTags.ArmorMetaType)metaType));
                    for (Object id : armor.armorSet().pieceIds()) {
                        metaTag.addOptional((ResourceLocation)id);
                    }
                }
            }
        }

        protected void addTags(HolderLookup.Provider wrapperLookup) {
            this.armorTags(Armors.entries, RPGSeriesItemTags.ArmorMetaType.ARCHERY);
        }
    }

    public static class SpellGen
    extends SpellGenerator {
        public SpellGen(FabricDataOutput dataOutput, CompletableFuture<HolderLookup.Provider> registryLookup) {
            super(dataOutput, registryLookup);
        }

        public void generateSpells(SpellGenerator.Builder builder) {
            for (ArchersExpansionSpells.Entry entry : ArchersExpansionSpells.entries) {
                builder.add(entry.id(), entry.spell());
            }
        }
    }

    public static class ModelProvider
    extends FabricModelProvider {
        public ModelProvider(FabricDataOutput output) {
            super(output);
        }

        public void generateBlockStateModels(BlockModelGenerators blockStateModelGenerator) {
        }

        public void generateItemModels(ItemModelGenerators itemModelGenerator) {
            Armors.entries.forEach(entry -> {
                for (Object piece : entry.armorSet().pieces()) {
                    itemModelGenerator.generateFlatItem((Item)piece, ModelTemplates.FLAT_ITEM);
                }
            });
        }
    }
}

