/*
 * Decompiled with CFR 0.152.
 */
package com.archers_expansion.items.armors;

import com.archers_expansion.items.Group;
import com.archers_expansion.items.armors.DeadeyeArmor;
import com.archers_expansion.items.armors.TundraArcherArmor;
import com.archers_expansion.items.armors.WarArcherArmor;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.fabric_extras.ranged_weapon.api.EntityAttributes_RangedWeapon;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.more_rpg_classes.item.MRPGCItems;
import net.spell_engine.api.config.ArmorSetConfig;
import net.spell_engine.api.config.AttributeModifier;
import net.spell_engine.api.entity.SpellEngineAttributes;
import net.spell_engine.api.item.Equipment;
import net.spell_engine.api.item.armor.Armor;
import net.spell_power.api.SpellSchools;

public class Armors {
    private static final Supplier<Ingredient> TUNDRA_INGREDIENTS = () -> Ingredient.of((ItemLike[])new ItemLike[]{MRPGCItems.POLAR_BEAR_FUR});
    private static final Supplier<Ingredient> WAT_ARCHER_INGREDIENTS = () -> Ingredient.of((ItemLike[])new ItemLike[]{Items.IRON_INGOT, Items.CHAIN});
    private static final Supplier<Ingredient> DEADEYE_INGREDIENTS = () -> Ingredient.of((ItemLike[])new ItemLike[]{MRPGCItems.HARDENED_LEATHER, Items.LEATHER});
    private static final ResourceLocation RANGED_HASTE_ID = ResourceLocation.parse((String)EntityAttributes_RangedWeapon.HASTE.id.toString());
    private static final ResourceLocation RANGED_DAMAGE_ID = ResourceLocation.parse((String)EntityAttributes_RangedWeapon.DAMAGE.id.toString());
    private static final ResourceLocation RANGED_VELOCITY_ID = ResourceLocation.parse((String)EntityAttributes_RangedWeapon.VELOCITY.id.toString());
    private static final ResourceLocation KNOCKBACK_ID = ResourceLocation.withDefaultNamespace((String)"generic.knockback_resistance");
    public static final float tundra_ranged_damage_t2 = 0.06f;
    public static final float tundra_haste_t2 = 0.04f;
    private static final float tundra_t2_spell_power = 1.0f;
    public static final float tundra_ranged_damage_t3 = 0.08f;
    public static final float tundra_haste_t3 = 0.05f;
    private static final float tundra_t3_spell_power = 1.0f;
    public static final float war_archer_damage_t2 = 0.1f;
    public static final float war_archer_armorknockback_t2 = 0.1f;
    public static final float war_archer_damage_t3 = 0.12f;
    public static final float war_archer_armorknockback_t3 = 0.1f;
    public static final float war_archer_velocity_t3 = 0.25f;
    public static final float deadeye_damage_t2 = 0.05f;
    public static final float deadeye_evasion_t2 = 0.04f;
    public static final float deadeye_haste_t2 = 0.05f;
    public static final float deadeye_damage_t3 = 0.07f;
    public static final float deadeye_evasion_t3 = 0.05f;
    public static final float deadeye_haste_t3 = 0.07f;
    public static Holder<ArmorMaterial> material_tundra_hunter = Armors.material("tundra_hunter", 2, 3, 3, 2, 10, (Holder<SoundEvent>)SoundEvents.ARMOR_EQUIP_LEATHER, TUNDRA_INGREDIENTS);
    public static Holder<ArmorMaterial> material_war_archer = Armors.material("war_archer", 3, 5, 4, 3, 10, (Holder<SoundEvent>)SoundEvents.ARMOR_EQUIP_LEATHER, WAT_ARCHER_INGREDIENTS);
    public static Holder<ArmorMaterial> material_deadeye = Armors.material("deadeye", 2, 3, 3, 2, 10, (Holder<SoundEvent>)SoundEvents.ARMOR_EQUIP_LEATHER, DEADEYE_INGREDIENTS);
    public static Holder<ArmorMaterial> material_netherite_tundra_hunter = Armors.material("netherite_tundra_hunter", 2, 3, 3, 2, 15, (Holder<SoundEvent>)SoundEvents.ARMOR_EQUIP_NETHERITE, () -> Ingredient.of((ItemLike[])new ItemLike[]{Items.NETHERITE_INGOT}));
    public static Holder<ArmorMaterial> material_netherite_war_archer = Armors.material("netherite_war_archer", 3, 5, 4, 3, 15, (Holder<SoundEvent>)SoundEvents.ARMOR_EQUIP_NETHERITE, () -> Ingredient.of((ItemLike[])new ItemLike[]{Items.NETHERITE_INGOT}));
    public static Holder<ArmorMaterial> material_netherite_deadeye = Armors.material("netherite_deadeye", 2, 3, 3, 2, 15, (Holder<SoundEvent>)SoundEvents.ARMOR_EQUIP_NETHERITE, () -> Ingredient.of((ItemLike[])new ItemLike[]{Items.NETHERITE_INGOT}));
    public static final ArrayList<Armor.Entry> entries = new ArrayList();
    public static final Armor.Set tundra_hunter_t1 = Armors.create(material_tundra_hunter, ResourceLocation.fromNamespaceAndPath((String)"archers_expansion", (String)"tundra_hunter"), 25, TundraArcherArmor::new, ArmorSetConfig.with((ArmorSetConfig.Piece)new ArmorSetConfig.Piece(2).addAll(List.of(AttributeModifier.multiply((ResourceLocation)RANGED_DAMAGE_ID, (float)0.06f), AttributeModifier.multiply((ResourceLocation)RANGED_HASTE_ID, (float)0.04f), AttributeModifier.bonus((ResourceLocation)SpellSchools.FROST.id, (float)1.0f))), (ArmorSetConfig.Piece)new ArmorSetConfig.Piece(3).addAll(List.of(AttributeModifier.multiply((ResourceLocation)RANGED_DAMAGE_ID, (float)0.06f), AttributeModifier.multiply((ResourceLocation)RANGED_HASTE_ID, (float)0.04f), AttributeModifier.bonus((ResourceLocation)SpellSchools.FROST.id, (float)1.0f))), (ArmorSetConfig.Piece)new ArmorSetConfig.Piece(3).addAll(List.of(AttributeModifier.multiply((ResourceLocation)RANGED_DAMAGE_ID, (float)0.06f), AttributeModifier.multiply((ResourceLocation)RANGED_HASTE_ID, (float)0.04f), AttributeModifier.bonus((ResourceLocation)SpellSchools.FROST.id, (float)1.0f))), (ArmorSetConfig.Piece)new ArmorSetConfig.Piece(2).addAll(List.of(AttributeModifier.multiply((ResourceLocation)RANGED_DAMAGE_ID, (float)0.06f), AttributeModifier.multiply((ResourceLocation)RANGED_HASTE_ID, (float)0.04f), AttributeModifier.bonus((ResourceLocation)SpellSchools.FROST.id, (float)1.0f)))), 2).armorSet();
    public static final Armor.Set war_archer_t1 = Armors.create(material_war_archer, ResourceLocation.fromNamespaceAndPath((String)"archers_expansion", (String)"war_archer"), 25, WarArcherArmor::new, ArmorSetConfig.with((ArmorSetConfig.Piece)new ArmorSetConfig.Piece(3).addAll(List.of(AttributeModifier.multiply((ResourceLocation)RANGED_DAMAGE_ID, (float)0.1f), AttributeModifier.multiply((ResourceLocation)KNOCKBACK_ID, (float)0.1f))), (ArmorSetConfig.Piece)new ArmorSetConfig.Piece(5).addAll(List.of(AttributeModifier.multiply((ResourceLocation)RANGED_DAMAGE_ID, (float)0.1f), AttributeModifier.multiply((ResourceLocation)KNOCKBACK_ID, (float)0.1f))), (ArmorSetConfig.Piece)new ArmorSetConfig.Piece(4).addAll(List.of(AttributeModifier.multiply((ResourceLocation)RANGED_DAMAGE_ID, (float)0.1f), AttributeModifier.multiply((ResourceLocation)KNOCKBACK_ID, (float)0.1f))), (ArmorSetConfig.Piece)new ArmorSetConfig.Piece(3).addAll(List.of(AttributeModifier.multiply((ResourceLocation)RANGED_DAMAGE_ID, (float)0.1f), AttributeModifier.multiply((ResourceLocation)KNOCKBACK_ID, (float)0.1f)))), 2).armorSet();
    public static final Armor.Set deadeye_t1 = Armors.create(material_deadeye, ResourceLocation.fromNamespaceAndPath((String)"archers_expansion", (String)"deadeye"), 25, DeadeyeArmor::new, ArmorSetConfig.with((ArmorSetConfig.Piece)new ArmorSetConfig.Piece(2).addAll(List.of(AttributeModifier.multiply((ResourceLocation)RANGED_HASTE_ID, (float)0.05f), AttributeModifier.multiply((ResourceLocation)RANGED_DAMAGE_ID, (float)0.05f), AttributeModifier.multiply((ResourceLocation)SpellEngineAttributes.EVASION_CHANCE.id, (float)0.04f))), (ArmorSetConfig.Piece)new ArmorSetConfig.Piece(3).addAll(List.of(AttributeModifier.multiply((ResourceLocation)RANGED_HASTE_ID, (float)0.05f), AttributeModifier.multiply((ResourceLocation)RANGED_DAMAGE_ID, (float)0.05f), AttributeModifier.multiply((ResourceLocation)SpellEngineAttributes.EVASION_CHANCE.id, (float)0.04f))), (ArmorSetConfig.Piece)new ArmorSetConfig.Piece(3).addAll(List.of(AttributeModifier.multiply((ResourceLocation)RANGED_HASTE_ID, (float)0.05f), AttributeModifier.multiply((ResourceLocation)RANGED_DAMAGE_ID, (float)0.05f), AttributeModifier.multiply((ResourceLocation)SpellEngineAttributes.EVASION_CHANCE.id, (float)0.04f))), (ArmorSetConfig.Piece)new ArmorSetConfig.Piece(2).addAll(List.of(AttributeModifier.multiply((ResourceLocation)RANGED_HASTE_ID, (float)0.05f), AttributeModifier.multiply((ResourceLocation)RANGED_DAMAGE_ID, (float)0.05f), AttributeModifier.multiply((ResourceLocation)SpellEngineAttributes.EVASION_CHANCE.id, (float)0.04f)))), 2).armorSet();
    public static final Armor.Set netherite_tundra_hunter = Armors.create(material_netherite_tundra_hunter, ResourceLocation.fromNamespaceAndPath((String)"archers_expansion", (String)"netherite_tundra_hunter"), 35, TundraArcherArmor::new, ArmorSetConfig.with((ArmorSetConfig.Piece)new ArmorSetConfig.Piece(2).addAll(List.of(AttributeModifier.multiply((ResourceLocation)RANGED_DAMAGE_ID, (float)0.08f), AttributeModifier.multiply((ResourceLocation)RANGED_HASTE_ID, (float)0.05f), AttributeModifier.bonus((ResourceLocation)SpellSchools.FROST.id, (float)1.0f))), (ArmorSetConfig.Piece)new ArmorSetConfig.Piece(3).addAll(List.of(AttributeModifier.multiply((ResourceLocation)RANGED_DAMAGE_ID, (float)0.08f), AttributeModifier.multiply((ResourceLocation)RANGED_HASTE_ID, (float)0.05f), AttributeModifier.bonus((ResourceLocation)SpellSchools.FROST.id, (float)1.0f))), (ArmorSetConfig.Piece)new ArmorSetConfig.Piece(3).addAll(List.of(AttributeModifier.multiply((ResourceLocation)RANGED_DAMAGE_ID, (float)0.08f), AttributeModifier.multiply((ResourceLocation)RANGED_HASTE_ID, (float)0.05f), AttributeModifier.bonus((ResourceLocation)SpellSchools.FROST.id, (float)1.0f))), (ArmorSetConfig.Piece)new ArmorSetConfig.Piece(2).addAll(List.of(AttributeModifier.multiply((ResourceLocation)RANGED_DAMAGE_ID, (float)0.08f), AttributeModifier.multiply((ResourceLocation)RANGED_HASTE_ID, (float)0.05f), AttributeModifier.bonus((ResourceLocation)SpellSchools.FROST.id, (float)1.0f)))), 3).armorSet();
    public static final Armor.Set netherite_war_archer = Armors.create(material_netherite_war_archer, ResourceLocation.fromNamespaceAndPath((String)"archers_expansion", (String)"netherite_war_archer"), 35, WarArcherArmor::new, ArmorSetConfig.with((ArmorSetConfig.Piece)new ArmorSetConfig.Piece(3).addAll(List.of(AttributeModifier.multiply((ResourceLocation)RANGED_DAMAGE_ID, (float)0.12f), AttributeModifier.bonus((ResourceLocation)RANGED_VELOCITY_ID, (float)0.25f), AttributeModifier.multiply((ResourceLocation)KNOCKBACK_ID, (float)0.1f))), (ArmorSetConfig.Piece)new ArmorSetConfig.Piece(5).addAll(List.of(AttributeModifier.multiply((ResourceLocation)RANGED_DAMAGE_ID, (float)0.12f), AttributeModifier.bonus((ResourceLocation)RANGED_VELOCITY_ID, (float)0.25f), AttributeModifier.multiply((ResourceLocation)KNOCKBACK_ID, (float)0.1f))), (ArmorSetConfig.Piece)new ArmorSetConfig.Piece(4).addAll(List.of(AttributeModifier.multiply((ResourceLocation)RANGED_DAMAGE_ID, (float)0.12f), AttributeModifier.bonus((ResourceLocation)RANGED_VELOCITY_ID, (float)0.25f), AttributeModifier.multiply((ResourceLocation)KNOCKBACK_ID, (float)0.1f))), (ArmorSetConfig.Piece)new ArmorSetConfig.Piece(3).addAll(List.of(AttributeModifier.multiply((ResourceLocation)RANGED_DAMAGE_ID, (float)0.12f), AttributeModifier.bonus((ResourceLocation)RANGED_VELOCITY_ID, (float)0.25f), AttributeModifier.multiply((ResourceLocation)KNOCKBACK_ID, (float)0.1f)))), 3).armorSet();
    public static final Armor.Set netherite_deadeye = Armors.create(material_netherite_deadeye, ResourceLocation.fromNamespaceAndPath((String)"archers_expansion", (String)"netherite_deadeye"), 35, DeadeyeArmor::new, ArmorSetConfig.with((ArmorSetConfig.Piece)new ArmorSetConfig.Piece(2).addAll(List.of(AttributeModifier.multiply((ResourceLocation)RANGED_HASTE_ID, (float)0.07f), AttributeModifier.multiply((ResourceLocation)RANGED_DAMAGE_ID, (float)0.07f), AttributeModifier.multiply((ResourceLocation)SpellEngineAttributes.EVASION_CHANCE.id, (float)0.05f))), (ArmorSetConfig.Piece)new ArmorSetConfig.Piece(3).addAll(List.of(AttributeModifier.multiply((ResourceLocation)RANGED_HASTE_ID, (float)0.07f), AttributeModifier.multiply((ResourceLocation)RANGED_DAMAGE_ID, (float)0.07f), AttributeModifier.multiply((ResourceLocation)SpellEngineAttributes.EVASION_CHANCE.id, (float)0.05f))), (ArmorSetConfig.Piece)new ArmorSetConfig.Piece(3).addAll(List.of(AttributeModifier.multiply((ResourceLocation)RANGED_HASTE_ID, (float)0.07f), AttributeModifier.multiply((ResourceLocation)RANGED_DAMAGE_ID, (float)0.07f), AttributeModifier.multiply((ResourceLocation)SpellEngineAttributes.EVASION_CHANCE.id, (float)0.05f))), (ArmorSetConfig.Piece)new ArmorSetConfig.Piece(2).addAll(List.of(AttributeModifier.multiply((ResourceLocation)RANGED_HASTE_ID, (float)0.07f), AttributeModifier.multiply((ResourceLocation)RANGED_DAMAGE_ID, (float)0.07f), AttributeModifier.multiply((ResourceLocation)SpellEngineAttributes.EVASION_CHANCE.id, (float)0.05f)))), 3).armorSet();

    public static Holder<ArmorMaterial> material(String name, int protectionHead, int protectionChest, int protectionLegs, int protectionFeet, int enchantability, Holder<SoundEvent> equipSound, Supplier<Ingredient> repairIngredient) {
        ArmorMaterial material = new ArmorMaterial(Map.of(ArmorItem.Type.HELMET, protectionHead, ArmorItem.Type.CHESTPLATE, protectionChest, ArmorItem.Type.LEGGINGS, protectionLegs, ArmorItem.Type.BOOTS, protectionFeet), enchantability, equipSound, repairIngredient, List.of(new ArmorMaterial.Layer(ResourceLocation.fromNamespaceAndPath((String)"archers_expansion", (String)name))), 0.0f, 0.0f);
        return Registry.registerForHolder((Registry)BuiltInRegistries.ARMOR_MATERIAL, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"archers_expansion", (String)name), (Object)material);
    }

    private static Armor.Entry create(Holder<ArmorMaterial> material, ResourceLocation id, int durability, Armor.Set.ItemFactory factory, ArmorSetConfig defaults, int tier) {
        Armor.Entry entry = Armor.Entry.create(material, (ResourceLocation)id, (int)durability, (Armor.Set.ItemFactory)factory, (ArmorSetConfig)defaults, (Equipment.LootProperties)Equipment.LootProperties.of((int)tier));
        entries.add(entry);
        return entry;
    }

    public static void register(Map<String, ArmorSetConfig> configs) {
        Armor.register(configs, entries, Group.KEY);
    }
}

