/*
 * Decompiled with CFR 0.152.
 */
package com.archers_expansion.client.entity;

import com.archers_expansion.entity.WintersGripEntity;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.resources.ResourceLocation;
import net.spell_engine.api.render.CustomLayers;
import net.spell_engine.api.render.CustomModels;
import net.spell_engine.api.render.LightEmission;

public class WintersGripRenderer<T extends WintersGripEntity>
extends EntityRenderer<T> {
    private final ItemRenderer itemRenderer;
    public static final ResourceLocation baseId = ResourceLocation.fromNamespaceAndPath((String)"archers_expansion", (String)"effect/winters_grip");
    private static final RenderType GLOWING_RENDER_LAYER = CustomLayers.spellEffect((LightEmission)LightEmission.RADIATE, (boolean)false);

    public WintersGripRenderer(EntityRendererProvider.Context context) {
        super(context);
        this.itemRenderer = context.getItemRenderer();
    }

    public ResourceLocation getTexture(T entity) {
        return null;
    }

    public void render(T entity, float yaw, float tickDelta, PoseStack matrixStack, MultiBufferSource vertexConsumers, int light) {
        super.render(entity, yaw, tickDelta, matrixStack, vertexConsumers, light);
        matrixStack.pushPose();
        matrixStack.mulPose(Axis.YP.rotationDegrees(-1.0f * entity.getYRot() + 180.0f));
        matrixStack.translate(0.0f, 0.5f, 0.0f);
        CustomModels.render((RenderType)GLOWING_RENDER_LAYER, (ItemRenderer)this.itemRenderer, (ResourceLocation)baseId, (PoseStack)matrixStack, (MultiBufferSource)vertexConsumers, (int)light, (int)entity.getId());
        matrixStack.translate(0.5, 0.0, 0.5);
        matrixStack.popPose();
    }
}

