/*
 * Decompiled with CFR 0.152.
 */
package com.archers_expansion.datagen;

import com.archers_expansion.items.armors.Armors;
import java.util.concurrent.CompletableFuture;
import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput;
import net.fabricmc.fabric.api.datagen.v1.provider.FabricRecipeProvider;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.data.recipes.ShapelessRecipeBuilder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.more_rpg_classes.item.MRPGCItems;

public class CraftingRecipeGenerator
extends FabricRecipeProvider {
    public CraftingRecipeGenerator(FabricDataOutput output, CompletableFuture<HolderLookup.Provider> registriesFuture) {
        super(output, registriesFuture);
    }

    public void buildRecipes(RecipeOutput exporter) {
        this.generateArmorRecipes(exporter);
        this.generateSpellBookRecipes(exporter);
    }

    private void generateArmorRecipes(RecipeOutput exporter) {
        CraftingRecipeGenerator.createShapedRecipe(exporter, (Item)Armors.deadeye_t1.head, "ABA", "C C", null, Character.valueOf('A'), MRPGCItems.HARDENED_LEATHER, Character.valueOf('B'), Items.SPIDER_EYE, Character.valueOf('C'), Items.RABBIT_HIDE);
        CraftingRecipeGenerator.createShapedRecipe(exporter, (Item)Armors.deadeye_t1.chest, "A A", "BDB", "CBC", Character.valueOf('A'), Items.GOLD_INGOT, Character.valueOf('B'), MRPGCItems.HARDENED_LEATHER, Character.valueOf('C'), Items.RABBIT_HIDE, Character.valueOf('D'), Items.SPIDER_EYE);
        CraftingRecipeGenerator.createShapedRecipe(exporter, (Item)Armors.deadeye_t1.legs, "AAA", "B B", "C C", Character.valueOf('A'), MRPGCItems.HARDENED_LEATHER, Character.valueOf('B'), Items.GOLD_INGOT, Character.valueOf('C'), Items.RABBIT_HIDE);
        CraftingRecipeGenerator.createShapedRecipe(exporter, (Item)Armors.deadeye_t1.feet, "ACA", "B B", null, Character.valueOf('A'), MRPGCItems.HARDENED_LEATHER, Character.valueOf('B'), Items.RABBIT_HIDE, Character.valueOf('C'), Items.GOLD_INGOT);
        CraftingRecipeGenerator.createShapedRecipe(exporter, (Item)Armors.tundra_hunter_t1.head, "AAA", "C C", null, Character.valueOf('A'), "more_rpg_classes:polar_bear_fur", Character.valueOf('C'), Items.PRISMARINE_SHARD);
        CraftingRecipeGenerator.createShapedRecipe(exporter, (Item)Armors.tundra_hunter_t1.chest, "A A", "BAB", "ACA", Character.valueOf('A'), "more_rpg_classes:polar_bear_fur", Character.valueOf('B'), Items.PRISMARINE_SHARD, Character.valueOf('C'), MRPGCItems.HARDENED_LEATHER);
        CraftingRecipeGenerator.createShapedRecipe(exporter, (Item)Armors.tundra_hunter_t1.legs, "AAA", "A A", "C C", Character.valueOf('A'), "more_rpg_classes:polar_bear_fur", Character.valueOf('C'), Items.PRISMARINE_SHARD);
        CraftingRecipeGenerator.createShapedRecipe(exporter, (Item)Armors.tundra_hunter_t1.feet, "A A", "B B", null, Character.valueOf('A'), Items.PRISMARINE_SHARD, Character.valueOf('B'), "more_rpg_classes:polar_bear_fur");
        CraftingRecipeGenerator.createShapedRecipe(exporter, (Item)Armors.war_archer_t1.head, "ABA", "C C", null, Character.valueOf('A'), Items.IRON_INGOT, Character.valueOf('B'), Items.NETHERITE_SCRAP, Character.valueOf('C'), Items.CHAIN);
        CraftingRecipeGenerator.createShapedRecipe(exporter, (Item)Armors.war_archer_t1.chest, "A A", "BAB", "ACA", Character.valueOf('A'), Items.CHAIN, Character.valueOf('B'), Items.LEATHER, Character.valueOf('C'), Items.NETHERITE_SCRAP);
        CraftingRecipeGenerator.createShapedRecipe(exporter, (Item)Armors.war_archer_t1.legs, "AAA", "B B", "C C", Character.valueOf('A'), Items.LEATHER, Character.valueOf('B'), Items.NETHERITE_SCRAP, Character.valueOf('C'), Items.CHAIN);
        CraftingRecipeGenerator.createShapedRecipe(exporter, (Item)Armors.war_archer_t1.feet, "ACA", "B B", null, Character.valueOf('A'), Items.LEATHER, Character.valueOf('B'), Items.CHAIN, Character.valueOf('C'), Items.NETHERITE_SCRAP);
    }

    private void generateSpellBookRecipes(RecipeOutput exporter) {
        ResourceLocation deadeyeSpellBook = ResourceLocation.fromNamespaceAndPath((String)"archers_expansion", (String)"deadeye_spell_book");
        ResourceLocation tundraHunterSpellBook = ResourceLocation.fromNamespaceAndPath((String)"archers_expansion", (String)"tundra_hunter_spell_book");
        ResourceLocation warArcherSpellBook = ResourceLocation.fromNamespaceAndPath((String)"archers_expansion", (String)"war_archer_spell_book");
        CraftingRecipeGenerator.createShapelessRecipe(exporter, deadeyeSpellBook, Items.ARROW, Items.RABBIT_HIDE, Items.BOOK, Items.LAPIS_LAZULI);
        CraftingRecipeGenerator.createShapelessRecipe(exporter, tundraHunterSpellBook, Items.ARROW, "more_rpg_classes:polar_bear_fur", Items.BOOK, Items.LAPIS_LAZULI);
        CraftingRecipeGenerator.createShapelessRecipe(exporter, warArcherSpellBook, Items.ARROW, Items.NETHERITE_SCRAP, Items.BOOK, Items.LAPIS_LAZULI);
    }

    public static ShapedRecipeBuilder shaped(RecipeCategory category, Item result, int count) {
        return ShapedRecipeBuilder.shaped((RecipeCategory)category, (ItemLike)result, (int)count);
    }

    public static ShapelessRecipeBuilder shapeless(RecipeCategory category, Item result, int count) {
        return ShapelessRecipeBuilder.shapeless((RecipeCategory)category, (ItemLike)result, (int)count);
    }

    public static void createShapedRecipe(RecipeOutput exporter, Item result, String pattern1, String pattern2, String pattern3, Object ... keyMappings) {
        ShapedRecipeBuilder builder = ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.COMBAT, (ItemLike)result, (int)1).pattern(pattern1).pattern(pattern2);
        if (pattern3 != null && !pattern3.isEmpty()) {
            builder.pattern(pattern3);
        }
        for (int i = 0; i < keyMappings.length; i += 2) {
            char key = ((Character)keyMappings[i]).charValue();
            Object ingredient = keyMappings[i + 1];
            if (ingredient instanceof Item) {
                Item item = (Item)ingredient;
                builder.define(Character.valueOf(key), (ItemLike)item);
                continue;
            }
            if (ingredient instanceof TagKey) {
                TagKey tag = (TagKey)ingredient;
                builder.define(Character.valueOf(key), tag);
                continue;
            }
            if (!(ingredient instanceof String)) continue;
            String str = (String)ingredient;
            TagKey tag = TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.parse((String)str));
            builder.define(Character.valueOf(key), tag);
        }
        builder.unlockedBy(CraftingRecipeGenerator.getHasName((ItemLike)result), CraftingRecipeGenerator.has((ItemLike)result)).showNotification(true).save(exporter);
    }

    public static void createShapelessRecipe(RecipeOutput exporter, Item result, Object ... ingredients) {
        ShapelessRecipeBuilder builder = ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)result, (int)1);
        for (Object ingredient : ingredients) {
            if (ingredient instanceof Item) {
                Item item = (Item)ingredient;
                builder.requires((ItemLike)item);
                continue;
            }
            if (ingredient instanceof TagKey) {
                TagKey tag = (TagKey)ingredient;
                builder.requires(tag);
                continue;
            }
            if (!(ingredient instanceof String)) continue;
            String str = (String)ingredient;
            TagKey tag = TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.parse((String)str));
            builder.requires(tag);
        }
        builder.unlockedBy(CraftingRecipeGenerator.getHasName((ItemLike)result), CraftingRecipeGenerator.has((ItemLike)result)).save(exporter);
    }

    public static void createShapelessRecipe(RecipeOutput exporter, ResourceLocation resultId, Object ... ingredients) {
        Item result = (Item)BuiltInRegistries.ITEM.get(resultId);
        CraftingRecipeGenerator.createShapelessRecipe(exporter, result, ingredients);
    }

    public String getName() {
        return "Crafting Recipes";
    }
}

