/*
 * Decompiled with CFR 0.152.
 */
package com.archers_expansion;

import com.archers_expansion.config.Default;
import com.archers_expansion.config.EffectsConfig;
import com.archers_expansion.config.TweaksConfig;
import com.archers_expansion.effect.Effects;
import com.archers_expansion.entity.WintersGripEntity;
import com.archers_expansion.items.Group;
import com.archers_expansion.items.Items;
import com.archers_expansion.items.armors.Armors;
import com.archers_expansion.sounds.Sounds;
import net.fabricmc.fabric.api.itemgroup.v1.FabricItemGroup;
import net.fabricmc.fabric.api.object.builder.v1.entity.FabricEntityTypeBuilder;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.spell_engine.api.config.ConfigFile;
import net.tiny_config.ConfigManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ArchersExpansionMod {
    public static final String MOD_ID = "archers_expansion";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"archers_expansion");
    public static ConfigManager<EffectsConfig> effectsConfig = new ConfigManager("effects_v2", (Object)new EffectsConfig()).builder().setDirectory("archers_expansion").sanitize(true).build();
    public static ConfigManager<ConfigFile.Equipment> itemConfig = new ConfigManager("equipment_v2", (Object)Default.itemConfig).builder().setDirectory("archers_expansion").sanitize(true).build();
    public static ConfigManager<TweaksConfig> tweaksConfig = new ConfigManager("tweaks", (Object)new TweaksConfig()).builder().setDirectory("archers_expansion").sanitize(true).build();

    public static void init() {
        effectsConfig.refresh();
        itemConfig.refresh();
        tweaksConfig.refresh();
        if (FabricLoader.getInstance().isDevelopmentEnvironment()) {
            ((TweaksConfig)ArchersExpansionMod.tweaksConfig.value).ignore_items_required_mods = true;
        }
    }

    public static void registerEffects() {
        Effects.register();
        effectsConfig.save();
    }

    public static void registerSounds() {
        Sounds.register();
    }

    public static void registerItems() {
        Items.registerModItems();
        Group.registerItemGroups();
        Group.ARCHERS_EXPANSION = FabricItemGroup.builder().icon(() -> new ItemStack((ItemLike)Armors.war_archer_t1.head.asItem())).title((Component)Component.translatable((String)"itemGroup.archers_expansion.general")).build();
        Registry.register((Registry)BuiltInRegistries.CREATIVE_MODE_TAB, Group.KEY, (Object)Group.ARCHERS_EXPANSION);
        Armors.register(((ConfigFile.Equipment)ArchersExpansionMod.itemConfig.value).armor_sets);
        itemConfig.save();
    }

    public static void registerEntities() {
        WintersGripEntity.ENTITY_TYPE = (EntityType)Registry.register((Registry)BuiltInRegistries.ENTITY_TYPE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)MOD_ID, (String)"winters_grip"), (Object)FabricEntityTypeBuilder.create((MobCategory)MobCategory.MISC, WintersGripEntity::new).dimensions(EntityDimensions.scalable((float)6.0f, (float)0.5f)).fireImmune().trackRangeBlocks(128).trackedUpdateRate(20).build());
    }
}

