/*
 * Decompiled with CFR 0.152.
 */
package com.archers_expansion.effect;

import com.archers_expansion.effect.Effects;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.more_rpg_classes.effect.MRPGCEffects;

public class ChokingGasEffect
extends MobEffect {
    protected ChokingGasEffect(MobEffectCategory category, int color) {
        super(category, color);
    }

    public void onEffectStarted(LivingEntity entity, int amplifier) {
        EntityType type = entity.getType();
        if (type.is(EntityTypeTags.IGNORES_POISON_AND_REGEN)) {
            entity.removeEffect(Effects.CHOKING_GAS.registryEntry);
        }
        super.onEffectStarted(entity, amplifier);
    }

    public boolean applyEffectTick(LivingEntity entity, int amplifier) {
        float damage = 1.0f;
        if (entity.hasEffect(MRPGCEffects.BLEEDING.registryEntry)) {
            damage += 0.5f;
        }
        entity.hurt(entity.damageSources().magic(), damage);
        return true;
    }

    public boolean shouldApplyEffectTickThisTick(int duration, int amplifier) {
        int i = 30 >> amplifier;
        if (i > 0) {
            return duration % i == 0;
        }
        return true;
    }
}

