/*
 * Decompiled with CFR 0.152.
 */
package com.archers_expansion.items.armors;

import com.archers_expansion.items.Group;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.fabric_extras.ranged_weapon.api.EntityAttributes_RangedWeapon;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.spell_engine.api.config.ArmorSetConfig;
import net.spell_engine.api.config.AttributeModifier;
import net.spell_engine.api.entity.SpellEngineAttributes;
import net.spell_engine.api.item.Equipment;
import net.spell_engine.api.item.armor.Armor;
import net.spell_engine.api.spell.SpellDataComponents;
import net.spell_power.api.SpellSchools;

public class ArmoryCompat {
    public static final ArrayList<Armor.Entry> entries = new ArrayList();
    public static ResourceLocation bounty_hunter_passive = ResourceLocation.fromNamespaceAndPath((String)"archers_expansion", (String)"bounty_hunter");
    public static ResourceLocation polar_stalker_passive = ResourceLocation.fromNamespaceAndPath((String)"archers_expansion", (String)"polar_stalker");
    public static ResourceLocation sentinel_archer_passive = ResourceLocation.fromNamespaceAndPath((String)"archers_expansion", (String)"sentinel_archer");
    public static Holder<ArmorMaterial> material_bounty_hunter = ArmoryCompat.material("bounty_hunter", 2, 4, 4, 2, 18, (Holder<SoundEvent>)SoundEvents.ARMOR_EQUIP_NETHERITE, () -> Ingredient.of((ItemLike[])new ItemLike[]{Items.NETHERITE_INGOT}));
    public static Holder<ArmorMaterial> material_polar_stalker = ArmoryCompat.material("polar_stalker", 2, 4, 4, 2, 18, (Holder<SoundEvent>)SoundEvents.ARMOR_EQUIP_NETHERITE, () -> Ingredient.of((ItemLike[])new ItemLike[]{Items.NETHERITE_INGOT}));
    public static Holder<ArmorMaterial> material_sentinel_archer = ArmoryCompat.material("sentinel_archer", 3, 5, 4, 3, 18, (Holder<SoundEvent>)SoundEvents.ARMOR_EQUIP_NETHERITE, () -> Ingredient.of((ItemLike[])new ItemLike[]{Items.NETHERITE_INGOT}));
    public static final float war_archer_damage = 0.14f;
    public static final float war_archer_velocity = 0.25f;
    public static final float war_archer_knockback = 0.1f;
    public static final float deadeye_damage = 0.09f;
    public static final float deadeye_evasion = 0.05f;
    public static final float deadeye_haste = 0.07f;
    public static final float tundra_hunter_spell_power = 1.5f;
    public static final float tundra_hunter_haste = 0.05f;
    public static final float tundra_hunter_damage = 0.1f;
    public static final int durability = 40;
    private static final ResourceLocation RANGED_HASTE_ID = ResourceLocation.parse((String)EntityAttributes_RangedWeapon.HASTE.id.toString());
    private static final ResourceLocation RANGED_DAMAGE_ID = ResourceLocation.parse((String)EntityAttributes_RangedWeapon.DAMAGE.id.toString());
    private static final ResourceLocation RANGED_VELOCITY_ID = ResourceLocation.parse((String)EntityAttributes_RangedWeapon.VELOCITY.id.toString());
    private static final ResourceLocation KNOCKBACK_ID = ResourceLocation.withDefaultNamespace((String)"generic.knockback_resistance");
    public static final Armor.Entry bounty_hunter = ArmoryCompat.create(material_bounty_hunter, ResourceLocation.fromNamespaceAndPath((String)"archers_expansion", (String)"bounty_hunter"), 40, 5, Armor.CustomItem::new, ArmorSetConfig.with((ArmorSetConfig.Piece)new ArmorSetConfig.Piece(2).add(AttributeModifier.multiply((ResourceLocation)RANGED_DAMAGE_ID, (float)0.09f)).add(AttributeModifier.multiply((ResourceLocation)RANGED_HASTE_ID, (float)0.07f)).add(AttributeModifier.multiply((ResourceLocation)SpellEngineAttributes.EVASION_CHANCE.id, (float)0.05f)), (ArmorSetConfig.Piece)new ArmorSetConfig.Piece(4).add(AttributeModifier.multiply((ResourceLocation)RANGED_DAMAGE_ID, (float)0.09f)).add(AttributeModifier.multiply((ResourceLocation)RANGED_HASTE_ID, (float)0.07f)).add(AttributeModifier.multiply((ResourceLocation)SpellEngineAttributes.EVASION_CHANCE.id, (float)0.05f)), (ArmorSetConfig.Piece)new ArmorSetConfig.Piece(4).add(AttributeModifier.multiply((ResourceLocation)RANGED_DAMAGE_ID, (float)0.09f)).add(AttributeModifier.multiply((ResourceLocation)RANGED_HASTE_ID, (float)0.07f)).add(AttributeModifier.multiply((ResourceLocation)SpellEngineAttributes.EVASION_CHANCE.id, (float)0.05f)), (ArmorSetConfig.Piece)new ArmorSetConfig.Piece(2).add(AttributeModifier.multiply((ResourceLocation)RANGED_DAMAGE_ID, (float)0.09f)).add(AttributeModifier.multiply((ResourceLocation)RANGED_HASTE_ID, (float)0.07f)).add(AttributeModifier.multiply((ResourceLocation)SpellEngineAttributes.EVASION_CHANCE.id, (float)0.05f))), ArmoryCompat.commonSettings(bounty_hunter_passive)).translatedName("", "", "", "");
    public static final Armor.Entry polar_stalker = ArmoryCompat.create(material_polar_stalker, ResourceLocation.fromNamespaceAndPath((String)"archers_expansion", (String)"polar_stalker"), 40, 5, Armor.CustomItem::new, ArmorSetConfig.with((ArmorSetConfig.Piece)new ArmorSetConfig.Piece(2).add(AttributeModifier.multiply((ResourceLocation)RANGED_DAMAGE_ID, (float)0.1f)).add(AttributeModifier.multiply((ResourceLocation)RANGED_HASTE_ID, (float)0.05f)).add(AttributeModifier.bonus((ResourceLocation)SpellSchools.FROST.id, (float)1.5f)), (ArmorSetConfig.Piece)new ArmorSetConfig.Piece(4).add(AttributeModifier.multiply((ResourceLocation)RANGED_DAMAGE_ID, (float)0.1f)).add(AttributeModifier.multiply((ResourceLocation)RANGED_HASTE_ID, (float)0.05f)).add(AttributeModifier.bonus((ResourceLocation)SpellSchools.FROST.id, (float)1.5f)), (ArmorSetConfig.Piece)new ArmorSetConfig.Piece(4).add(AttributeModifier.multiply((ResourceLocation)RANGED_DAMAGE_ID, (float)0.1f)).add(AttributeModifier.multiply((ResourceLocation)RANGED_HASTE_ID, (float)0.05f)).add(AttributeModifier.bonus((ResourceLocation)SpellSchools.FROST.id, (float)1.5f)), (ArmorSetConfig.Piece)new ArmorSetConfig.Piece(2).add(AttributeModifier.multiply((ResourceLocation)RANGED_DAMAGE_ID, (float)0.1f)).add(AttributeModifier.multiply((ResourceLocation)RANGED_HASTE_ID, (float)0.05f)).add(AttributeModifier.bonus((ResourceLocation)SpellSchools.FROST.id, (float)1.5f))), ArmoryCompat.commonSettings(polar_stalker_passive)).translatedName("", "", "", "");
    public static final Armor.Entry sentinel_archer = ArmoryCompat.create(material_sentinel_archer, ResourceLocation.fromNamespaceAndPath((String)"archers_expansion", (String)"sentinel_archer"), 40, 5, Armor.CustomItem::new, ArmorSetConfig.with((ArmorSetConfig.Piece)new ArmorSetConfig.Piece(3).add(AttributeModifier.multiply((ResourceLocation)RANGED_DAMAGE_ID, (float)0.14f)).add(AttributeModifier.multiply((ResourceLocation)KNOCKBACK_ID, (float)0.1f)).add(AttributeModifier.multiply((ResourceLocation)RANGED_VELOCITY_ID, (float)0.25f)), (ArmorSetConfig.Piece)new ArmorSetConfig.Piece(5).add(AttributeModifier.multiply((ResourceLocation)RANGED_DAMAGE_ID, (float)0.14f)).add(AttributeModifier.multiply((ResourceLocation)KNOCKBACK_ID, (float)0.1f)).add(AttributeModifier.multiply((ResourceLocation)RANGED_VELOCITY_ID, (float)0.25f)), (ArmorSetConfig.Piece)new ArmorSetConfig.Piece(4).add(AttributeModifier.multiply((ResourceLocation)RANGED_DAMAGE_ID, (float)0.14f)).add(AttributeModifier.multiply((ResourceLocation)KNOCKBACK_ID, (float)0.1f)).add(AttributeModifier.multiply((ResourceLocation)RANGED_VELOCITY_ID, (float)0.25f)), (ArmorSetConfig.Piece)new ArmorSetConfig.Piece(3).add(AttributeModifier.multiply((ResourceLocation)RANGED_DAMAGE_ID, (float)0.14f)).add(AttributeModifier.multiply((ResourceLocation)KNOCKBACK_ID, (float)0.1f)).add(AttributeModifier.multiply((ResourceLocation)RANGED_VELOCITY_ID, (float)0.25f))), ArmoryCompat.commonSettings(sentinel_archer_passive)).translatedName("", "", "", "");

    private static Armor.Entry create(Holder<ArmorMaterial> material, ResourceLocation id, int durability, int tier, Armor.Set.ItemFactory factory, ArmorSetConfig defaults, Armor.ItemSettingsTweaker settings) {
        Armor.Entry entry = Armor.Entry.create(material, (ResourceLocation)id, (int)durability, (Armor.Set.ItemFactory)factory, (ArmorSetConfig)defaults, (Equipment.LootProperties)Equipment.LootProperties.of((int)tier), (Armor.ItemSettingsTweaker)settings);
        entries.add(entry);
        return entry;
    }

    public static Holder<ArmorMaterial> material(String name, int protectionHead, int protectionChest, int protectionLegs, int protectionFeet, int enchantability, Holder<SoundEvent> equipSound, Supplier<Ingredient> repairIngredient) {
        ArmorMaterial material = new ArmorMaterial(Map.of(ArmorItem.Type.HELMET, protectionHead, ArmorItem.Type.CHESTPLATE, protectionChest, ArmorItem.Type.LEGGINGS, protectionLegs, ArmorItem.Type.BOOTS, protectionFeet), enchantability, equipSound, repairIngredient, List.of(new ArmorMaterial.Layer(ResourceLocation.fromNamespaceAndPath((String)"archers_expansion", (String)name))), 0.0f, 0.0f);
        return Registry.registerForHolder((Registry)BuiltInRegistries.ARMOR_MATERIAL, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"archers_expansion", (String)name), (Object)material);
    }

    private static Armor.ItemSettingsTweaker commonSettings(ResourceLocation equipmentSetId) {
        return Armor.ItemSettingsTweaker.standard(itemSettings -> itemSettings.component(SpellDataComponents.EQUIPMENT_SET, (Object)equipmentSetId).component(DataComponents.RARITY, (Object)Rarity.RARE));
    }

    public static void register(Map<String, ArmorSetConfig> configs) {
        Armor.register(configs, entries, Group.KEY);
    }
}

