/*
 * Decompiled with CFR 0.152.
 */
package com.archers_expansion.mixin.client;

import com.archers_expansion.effect.Effects;
import com.llamalad7.mixinextras.injector.v2.WrapWithCondition;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.layers.ItemInHandLayer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.spell_engine.api.effect.Synchronized;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={LivingEntityRenderer.class})
public abstract class LivingEntityRenderStealth<T extends Entity>
extends EntityRenderer<T> {
    protected LivingEntityRenderStealth(EntityRendererProvider.Context ctx) {
        super(ctx);
    }

    @Unique
    private LocalPlayer localPlayer() {
        return Minecraft.getInstance().player;
    }

    @Unique
    private boolean hasStealthEffect(LivingEntity entity) {
        List effects = ((Synchronized.Provider)entity).SpellEngine_syncedStatusEffects();
        for (Synchronized.Effect effect : effects) {
            if (effect.effect() != Effects.INFILTRATORS_ARROW.effect) continue;
            return true;
        }
        return false;
    }

    @Unique
    private boolean visibleForLocalPlayer(LivingEntity entity) {
        return entity == this.localPlayer() || !entity.isInvisibleTo((Player)this.localPlayer());
    }

    @Inject(method={"getRenderType(Lnet/minecraft/world/entity/LivingEntity;ZZZ)Lnet/minecraft/client/renderer/RenderType;"}, at={@At(value="HEAD")}, cancellable=true)
    private void getRenderLayer_HEAD_Stealth(LivingEntity entity, boolean showBody, boolean translucent, boolean showOutline, CallbackInfoReturnable<RenderType> cir) {
        if (this.hasStealthEffect(entity) && this.visibleForLocalPlayer(entity)) {
            ResourceLocation identifier = this.getTextureLocation((Entity)entity);
            RenderType layer = RenderType.itemEntityTranslucentCull((ResourceLocation)identifier);
            cir.setReturnValue((Object)layer);
            cir.cancel();
        }
    }

    @WrapOperation(method={"render(Lnet/minecraft/world/entity/LivingEntity;FFLcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/MultiBufferSource;I)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/model/EntityModel;renderToBuffer(Lcom/mojang/blaze3d/vertex/PoseStack;Lcom/mojang/blaze3d/vertex/VertexConsumer;III)V")})
    private void modelRender_WRAP_STEALTH(EntityModel instance, PoseStack matrices, VertexConsumer vertices, int light, int overlay, int color, Operation<Void> original, LivingEntity entity, float f, float g, PoseStack contextMatrixStack, MultiBufferSource contextVertexConsumerProvider, int contextLight) {
        if (this.hasStealthEffect(entity) && this.visibleForLocalPlayer(entity)) {
            int alpha = FastColor.ARGB32.alpha((int)color);
            int red = FastColor.ARGB32.red((int)color);
            int green = FastColor.ARGB32.green((int)color);
            int blue = FastColor.ARGB32.blue((int)color);
            int newColor = FastColor.ARGB32.color((int)((int)((float)alpha * 0.15f)), (int)red, (int)green, (int)blue);
            original.call(new Object[]{instance, matrices, vertices, light, overlay, newColor});
        } else {
            original.call(new Object[]{instance, matrices, vertices, light, overlay, color});
        }
    }

    @WrapWithCondition(method={"render(Lnet/minecraft/world/entity/LivingEntity;FFLcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/MultiBufferSource;I)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/renderer/entity/layers/RenderLayer;render(Lcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/MultiBufferSource;ILnet/minecraft/world/entity/Entity;FFFFFF)V")})
    private boolean featureRenderer_WRAP_CONDITION_STEALTH(RenderLayer instance, PoseStack matrixStack, MultiBufferSource vertexConsumerProvider, int i, T t, float a, float b, float c, float d, float e, float f) {
        LivingEntity entity = (LivingEntity)t;
        if (this.hasStealthEffect(entity)) {
            if (this.visibleForLocalPlayer(entity)) {
                return instance instanceof ItemInHandLayer;
            }
            return false;
        }
        return true;
    }
}

