/*
 * Decompiled with CFR 0.152.
 */
package com.archers_expansion.effect;

import com.archers_expansion.ArchersExpansionMod;
import com.archers_expansion.config.EffectsConfig;
import com.archers_expansion.effect.ChokingGasEffect;
import com.archers_expansion.effect.CrystalArrowEffect;
import com.archers_expansion.effect.CustomStatusEffect;
import com.archers_expansion.effect.DisablingShotEffect;
import com.archers_expansion.effect.FrozenPactEffect;
import com.archers_expansion.effect.InfiltratorsArrowEffect;
import com.archers_expansion.effect.WintersGraspEffect;
import java.util.ArrayList;
import net.fabric_extras.ranged_weapon.api.EntityAttributes_RangedWeapon;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.spell_engine.api.effect.ActionImpairing;
import net.spell_engine.api.effect.EntityActionsAllowed;
import net.spell_engine.api.effect.OnRemoval;
import net.spell_engine.api.effect.Synchronized;
import net.spell_engine.api.entity.SpellEngineAttributes;
import net.spell_engine.api.event.CombatEvents;
import net.spell_engine.api.spell.event.SpellEvents;

public class Effects {
    private static final ArrayList<Entry> entries = new ArrayList();
    public static final Entry FAST_SHOT = new Entry("fast_shot", new CustomStatusEffect(MobEffectCategory.BENEFICIAL, 8412749));
    public static final Entry CHOKING_GAS = new Entry("choking_gas", new ChokingGasEffect(MobEffectCategory.HARMFUL, 8412749));
    public static final Entry DISABLING_SHOT = new Entry("disabling_shot", new DisablingShotEffect(MobEffectCategory.HARMFUL, 8412749));
    public static final Entry INFILTRATORS_ARROW = new Entry("infiltrators_arrow", new InfiltratorsArrowEffect(MobEffectCategory.BENEFICIAL, 8412749));
    public static final Entry INFILTRATORS_SPEED = new Entry("infiltrators_speed", new CustomStatusEffect(MobEffectCategory.BENEFICIAL, 8412749));
    public static final Entry FROZEN_SHOT = new Entry("frozen_shot", new CustomStatusEffect(MobEffectCategory.BENEFICIAL, 0x99CCFF));
    public static final Entry ENCHANTED_CRSYSTAL_ARROW = new Entry("enchanted_crystal_arrow", new CrystalArrowEffect(MobEffectCategory.HARMFUL, 0x99CCFF));
    public static final Entry FROZEN_PACT = new Entry("frozen_pact", new FrozenPactEffect(MobEffectCategory.HARMFUL, 0x99CCFF));
    public static final Entry WINTERS_GRASP = new Entry("winters_grip", new WintersGraspEffect(MobEffectCategory.HARMFUL, 8412749));
    public static final Entry SMOLDERING_ARROWS = new Entry("smoldering_arrows", new CustomStatusEffect(MobEffectCategory.BENEFICIAL, 8412749));
    public static final Entry PIN_DOWN = new Entry("pin_down", new CustomStatusEffect(MobEffectCategory.HARMFUL, 8412749));

    public static void register() {
        EffectsConfig config = (EffectsConfig)ArchersExpansionMod.effectsConfig.value;
        Effects.FAST_SHOT.effect.addAttributeModifier(EntityAttributes_RangedWeapon.HASTE.entry, FAST_SHOT.modifierId(), (double)((EffectsConfig)ArchersExpansionMod.effectsConfig.value).fast_shot_haste_increase_per_stack, AttributeModifier.Operation.ADD_MULTIPLIED_BASE);
        Effects.DISABLING_SHOT.effect.addAttributeModifier(Attributes.MOVEMENT_SPEED, DISABLING_SHOT.modifierId(), (double)((EffectsConfig)ArchersExpansionMod.effectsConfig.value).disabling_shot_decreased_movement_speed, AttributeModifier.Operation.ADD_MULTIPLIED_BASE);
        Effects.FROZEN_PACT.effect.addAttributeModifier(Attributes.ATTACK_DAMAGE, FROZEN_PACT.modifierId(), (double)((EffectsConfig)ArchersExpansionMod.effectsConfig.value).frozen_pact_decreased_attack, AttributeModifier.Operation.ADD_MULTIPLIED_BASE);
        Effects.PIN_DOWN.effect.addAttributeModifier(Attributes.MOVEMENT_SPEED, PIN_DOWN.modifierId(), -10.0, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL).addAttributeModifier(Attributes.JUMP_STRENGTH, PIN_DOWN.modifierId(), -10.0, AttributeModifier.Operation.ADD_MULTIPLIED_BASE);
        Effects.CHOKING_GAS.effect.addAttributeModifier(SpellEngineAttributes.HEALING_TAKEN.entry, CHOKING_GAS.modifierId(), (double)((EffectsConfig)ArchersExpansionMod.effectsConfig.value).choking_gas_healing_taken, AttributeModifier.Operation.ADD_MULTIPLIED_BASE);
        Effects.INFILTRATORS_ARROW.effect.addAttributeModifier(Attributes.MOVEMENT_SPEED, INFILTRATORS_ARROW.modifierId(), config.stealth_movement_speed_multiplier, AttributeModifier.Operation.ADD_MULTIPLIED_BASE);
        Effects.INFILTRATORS_SPEED.effect.addAttributeModifier(Attributes.MOVEMENT_SPEED, INFILTRATORS_SPEED.modifierId(), 0.5, AttributeModifier.Operation.ADD_MULTIPLIED_BASE);
        Effects.WINTERS_GRASP.effect.addAttributeModifier(Attributes.MOVEMENT_SPEED, WINTERS_GRASP.modifierId(), config.winters_grasp_movement_speed_multiplier, AttributeModifier.Operation.ADD_MULTIPLIED_BASE);
        CombatEvents.ENTITY_ANY_ATTACK.register(args -> {
            LivingEntity attacker = args.attacker();
            if (attacker.hasEffect(Effects.INFILTRATORS_ARROW.registryEntry)) {
                attacker.removeEffect(Effects.INFILTRATORS_ARROW.registryEntry);
            }
        });
        ResourceLocation vanishId = ResourceLocation.fromNamespaceAndPath((String)"archers_expansion", (String)"infiltrators_arrow");
        SpellEvents.SPELL_CAST.register(args -> {
            Player caster = args.caster();
            ResourceLocation spellId = ((ResourceKey)args.spell().unwrapKey().get()).location();
            if (caster.hasEffect(Effects.INFILTRATORS_ARROW.registryEntry) && !spellId.equals((Object)vanishId)) {
                caster.removeEffect(Effects.INFILTRATORS_ARROW.registryEntry);
            }
        });
        CombatEvents.ITEM_USE.register(args -> {
            LivingEntity user = args.user();
            if (user.hasEffect(Effects.INFILTRATORS_ARROW.registryEntry)) {
                user.removeEffect(Effects.INFILTRATORS_ARROW.registryEntry);
            }
        });
        OnRemoval.configure((MobEffect)Effects.INFILTRATORS_ARROW.effect, context -> {
            InfiltratorsArrowEffect.onRemove(context.entity());
            if (context.entity().hasEffect(Effects.INFILTRATORS_SPEED.registryEntry)) {
                context.entity().removeEffect(Effects.INFILTRATORS_SPEED.registryEntry);
            }
        });
        Synchronized.configure((MobEffect)Effects.FAST_SHOT.effect, (boolean)true);
        Synchronized.configure((MobEffect)Effects.CHOKING_GAS.effect, (boolean)true);
        Synchronized.configure((MobEffect)Effects.DISABLING_SHOT.effect, (boolean)true);
        Synchronized.configure((MobEffect)Effects.ENCHANTED_CRSYSTAL_ARROW.effect, (boolean)true);
        Synchronized.configure((MobEffect)Effects.FROZEN_PACT.effect, (boolean)true);
        Synchronized.configure((MobEffect)Effects.FROZEN_SHOT.effect, (boolean)true);
        Synchronized.configure((MobEffect)Effects.SMOLDERING_ARROWS.effect, (boolean)true);
        Synchronized.configure((MobEffect)Effects.PIN_DOWN.effect, (boolean)true);
        Synchronized.configure((MobEffect)Effects.INFILTRATORS_ARROW.effect, (boolean)true);
        Synchronized.configure((MobEffect)Effects.INFILTRATORS_SPEED.effect, (boolean)true);
        Synchronized.configure((MobEffect)Effects.WINTERS_GRASP.effect, (boolean)true);
        ActionImpairing.configure((MobEffect)Effects.CHOKING_GAS.effect, (EntityActionsAllowed)EntityActionsAllowed.SILENCE);
        ActionImpairing.configure((MobEffect)Effects.ENCHANTED_CRSYSTAL_ARROW.effect, (EntityActionsAllowed)EntityActionsAllowed.STUN);
        for (Entry entry : entries) {
            entry.register();
        }
    }

    public static class Entry {
        public final ResourceLocation id;
        public final MobEffect effect;
        public Holder<MobEffect> registryEntry;

        public Entry(String name, MobEffect effect) {
            this.id = ResourceLocation.fromNamespaceAndPath((String)"archers_expansion", (String)name);
            this.effect = effect;
            entries.add(this);
        }

        public void register() {
            this.registryEntry = Registry.registerForHolder((Registry)BuiltInRegistries.MOB_EFFECT, (ResourceLocation)this.id, (Object)this.effect);
        }

        public ResourceLocation modifierId() {
            return ResourceLocation.fromNamespaceAndPath((String)"archers_expansion", (String)("effect." + this.id.getPath()));
        }
    }
}

