// © Copyright 2024 timetravelbeard (contact: https://www.patreon.com/timetravelbeard , https://youtube.com/@timetravelbeard3588 , https://discord.gg/S6F4r6K5yU )

// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT  TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

//NOTE:  In case you don't know, copyright means all rights are reserved. You cannot modify, redistribute, or make derivative works of this. Do not steal any of this code or use "code snippets". 


#define REFLECTIONS_ARE_IN_RAYDIR 1

#include "/settings.glsl"
#include "/noise.glsl"

#if AO >= 1
		/*
	const bool colortex5MipmapEnabled = true;
	*/
	/*
	const bool colortex1MipmapEnabled = true;
	*/
	/*
	const bool depthtex0MipmapEnabled = true;
	*/
#endif

uniform sampler2D colortex11;//ambient_lighting
uniform sampler2D colortex10;//pre-reflection, fog
uniform sampler2D colortex4;//albedo

uniform float nightVision;
uniform vec3 sunPosition;
uniform float frameCounter;
		

uniform float near;
uniform float far;
#if defined IS_IRIS && defined DISTANT_HORIZONS 
	uniform float dhFarPlane;
	uniform float dhNearPlane;
	float far_adjusted = dhFarPlane;
	
#else
	float far_adjusted = far;
#endif

uniform ivec2 eyeBrightnessSmooth;
uniform float eyeBrightnessFast;

#if SSPTGI > 10
	/*
	const bool colortex5MipmapEnabled = true;
	*/
		/*
	const bool colortex6MipmapEnabled = true;
	*/
#endif

vec3 projectAndDivide(mat4 projectionMatrix, in vec3 position)
{
	vec4 position2= projectionMatrix*vec4(position,1.);
	return position2.xyz/position2.w;
}

float linearize_water_d( in float depth, in float n, in float f)
	{
	   return .7* (n * f) / (depth * (n - f) + f);
	}
	
uniform vec3 cameraPosition;
uniform float frameTimeCounter;
varying vec2 texcoord;
uniform float rainStrength;
uniform float thunderStrength;

	uniform sampler2D colortex6;//sky
	#if REFRACTIONS == 1 || AO > 0
		uniform sampler2D colortex2;//normals
	#endif	
	uniform sampler2D colortex5;//solids
	#if REFRACTIONS == 1
	//	uniform sampler2D colortex2;//normals
		uniform sampler2D colortex7;//water
		uniform sampler2D colortex3;//hand
		uniform sampler2D depthtex1;
	#endif

#if defined IS_IRIS && defined DISTANT_HORIZONS && BORDERS_IN_DH == 1	
	uniform sampler2D dhDepthTex1;
#endif
	
#if CLOUDS >= 1 ||  GODRAYS == 1 
	uniform float sunAngle;
#endif

#if CLOUDS >= 5 
	uniform sampler2D colortex0;
#endif

	uniform vec3 fogColor;
	uniform vec3 skyColor;
	
uniform float Foggy=0.;
#if CLOUDS >= 1 || REFLECTION_DETAIL >= 3
	uniform mat4 gbufferProjectionInverse;
#endif
#if CLOUDS >= 1 
	uniform int worldTime;
	uniform int worldDay;
	
	uniform mat4 gbufferModelView;
	uniform mat4 gbufferModelViewInverse;
		uniform vec3 shadowLightPosition;


	#if VANILLA_SUNSETS == 0

		

	#endif

	float fogify(float x, float w) {
		return w / (x * x + w);
	}
	#include "/clouds.glsl"
#else
	float cloudy = 0.;
#endif


#if defined IS_IRIS && defined DISTANT_HORIZONS && BORDERS_IN_DH == 1
	uniform sampler2D colortex1;
	 float Cloud_mask = 9990.0;
#else
	 float Cloud_mask = far_adjusted-.1;

#endif

#if DEBUG_SHADOWS == 1
	uniform sampler2D shadowcolor0;
#endif


#if GODRAYS == 1 
	uniform mat4 gbufferProjection;
	
	uniform sampler2D lightmap;
	
	uniform float rainfall=0.;
	//float Foggy = min(1.,rainfall*.1+rainStrength);
#endif

#if WATER_COL_ABSORB >= 2 
	uniform sampler2D colortex5;
	#if WATER_COL_ABSORB >= 2 && REFRACTIONS == 1
		uniform sampler2D colortex6;
	#endif
#else
	#if CLOUDS < 5 
		uniform sampler2D colortex0;
	#endif
	
#endif
		

uniform sampler2D depthtex0;
#if BORDERS >= 2
	uniform sampler2D colortex1;
#endif


#if defined IS_IRIS && defined DISTANT_HORIZONS && BORDERS_IN_DH == 1
		float far1 = dhFarPlane*DH_FOG_END;
		#else
		float far1 = far;
		#endif
uniform int isEyeInWater;

uniform vec3 focolortex5;
uniform float viewWidth;
uniform float viewHeight;




float linearize_depth_cpf(in float d)
{

    // from gl_FragCoord.z to world measurements
    return 2.0 * near  * far / (far + near - (2.0 * d - 1.0) * (far - near));

}

#if defined IS_IRIS && defined DISTANT_HORIZONS 
float linearize_depth_cpf_dh(in float d)
{

    // from gl_FragCoord.z to world measurements
    return 2.0 * dhNearPlane  * dhFarPlane / (dhFarPlane + dhNearPlane - (2.0 * d - 1.0) * (dhFarPlane - dhNearPlane));

}
#endif
float linearize_depth_cpf2(in float d)
{

    // from gl_FragCoord.z to world measurements
    return 2.0 * near  * far*4. / (far*4. + near - (2.0 * d - 1.0) * (far*4. - near));

}

float get_depth_at(vec2 uv)
{
#if defined IS_IRIS && defined DISTANT_HORIZONS && BORDERS_IN_DH == 1
	return texture2D(colortex1,uv).x;
#else
	return linearize_depth_cpf(texture2D(depthtex0,uv).r);
#endif

}
float get_depth_at_lod(vec2 uv, in float lod)
{
#if defined IS_IRIS && defined DISTANT_HORIZONS && BORDERS_IN_DH == 1
	return texture2DLod(colortex1,uv,lod).x;
#else
	return linearize_depth_cpf(texture2DLod(depthtex0,uv,lod).r);
#endif

}


#if REFRACTIONS == 1
	float get_underwater_depth_at(vec2 uv)
	{
		#if defined IS_IRIS && defined DISTANT_HORIZONS && BORDERS_IN_DH == 1
			float d =  
				min(
				linearize_depth_cpf2(texture2D(depthtex1,uv).r),
				linearize_depth_cpf_dh(texture2D(dhDepthTex1,uv).r) ) ;
				return abs(d) > 0.1 ? d: 10.;
		#else
			return linearize_depth_cpf(texture2D(depthtex1,uv).r);
		#endif
		
		
	}

#endif

float get_depth_at2(vec2 uv)
{
	#if UNDERWATER_GODRAYS == 1
	if(isEyeInWater == 1)
	{
		
		float d1 = texture2D(depthtex1,uv).r;//
		return d1 >.999 ? 1. : clamp(linearize_depth_cpf(d1)/far1,0.,1.);

	}else
	#endif
	{


		#if defined IS_IRIS && defined DISTANT_HORIZONS && BORDERS_IN_DH == 1
			float d = texture2D(colortex1,uv).x;
			return
		//	abs(d-0.) < 0.01 ? 1. :
			pow(clamp(d/far1,0.,1.),1.);
		#else
			float d = texture2D(depthtex0,uv).r;//
			return d >.999 ? 1. : clamp(linearize_depth_cpf(d)/far1,0.,1.);
		#endif

	}
}

void main() {

	vec4 ambient_lighting = texture2D(colortex11, texcoord);
	float fog_amount = texture2D(colortex10, texcoord).a;
	vec3 albedo = texture2D(colortex4, texcoord).rgb;

	bool is_water = false;
		
	#if REFRACTIONS == 1 ||  AO >= 1
		vec4 normals = texture2D(colortex2, texcoord);
		normals.rgb=normals.rgb*2.-1.;
	#endif
	#if REFRACTIONS == 1
			is_water = normals.w > .5 ;
			vec4 color;// = texture2D(colortex5, refracted_coord);
		
		
		
			vec4 water = texture2D(colortex7, texcoord);
			
			
			vec2 refractuv = (normals.xy)*REFRACTION_DISTANCE
				
		
					
					
					* (1.-
					pow(
					clamp(
					vec2( 
					 ((abs(texcoord.x-.5)*2.)-(1.- REFRACTION_DISTANCE*3.) )/(REFRACTION_DISTANCE*3.)
					, ((abs(texcoord.y-.5)*2.)-(1.- REFRACTION_DISTANCE*3.) )/(REFRACTION_DISTANCE*3.)
					
					)
					*1.
					,0.,1.)
					,vec2(1.5))
					)
					
					;
				
			float obscured_refract = 3.;
					float water_d =  get_depth_at(texcoord);
					float opaque_d = get_underwater_depth_at(texcoord-refractuv);
					refractuv/=1.+water_d*.01;
					vec2 starting_refractuv=refractuv;
					for(float i = 1. //3 to step
					; opaque_d < water_d && i >=0.;i-- )
					{
						refractuv= starting_refractuv*i/3.;
						opaque_d = get_underwater_depth_at(texcoord-refractuv);
						//water_d =  get_depth_at(texcoord-refractuv);
							
						obscured_refract--;
					}
					
					vec2 refracted_coord = water.a > 0.001 ? texcoord-refractuv : texcoord;
					
					
					#if ONLY_REFRACT_X == 1
						refracted_coord.y = texcoord.y;
					#else
						refracted_coord.y = mix(texcoord.y,refracted_coord.y,clamp(-(REFRACTION_DISTANCE*3.)+texcoord.y*2.,0.,1.) );//debug
					#endif
					
					//final refracted positions
					opaque_d = get_underwater_depth_at(refracted_coord);
					//water_d =  get_depth_at(refracted_coord);
					
				if(!is_water)
				{	
					refracted_coord = texcoord;
					opaque_d = get_underwater_depth_at(texcoord);
				}
				
				color = texture2D(colortex5, refracted_coord);
			
			
			//float ipbr_id = 10021.;//debug
		
			
			//cololr absorption
			is_water = isEyeInWater == 1? !is_water : is_water;
			float is_water_fog=is_water?1.:0.;//debug 
			
			//float water_fog2 = clamp(.05*(opaque_depth-water_d),0.,1.);
			
			float wf1 =  isEyeInWater == 1 ? opaque_d : opaque_d-water_d;  //linearize_water_d(gl_FragCoord.z, near, far*4.)
			
			//wf1=0.;//debug 4-25
			
			float wf = clamp( wf1 /mix(1.,WATER_VISIBILITY,is_water_fog) ,0.,mix(1.,.3,is_water_fog));
			vec4 water_color = water;
			
			float WATER_COLOR_ABSORB_DISTa=is_water?WATER_COLOR_ABSORB_DIST:1.;
						
						
			
						
			water_color.rgb = is_water ? mix(vec3(0.,.7,1.),water_color.rgb,color.a): water_color.rgb;
			
			vec3 sky = texture2D(colortex6, refracted_coord).rgb;
			
						if(is_water )
						{
							//water color absorb
							color.rgb = 
							 color.rgb * clamp( vec3(1.)-vec3(4.,1.,0.)*wf1/WATER_COLOR_ABSORB_DISTa,0.,1. ) ;
							color.a=1.;
							
							
						}else{
							//glass color
							color.rgb = mix(
							 color.rgb   ,
							  color.rgb * mix(vec3(1.),water_color.rgb, clamp(wf1,0.,1. )),water.a);
							color.a=1.;
							
							sky.rgb = isEyeInWater == 1?
							 sky.rgb * clamp( vec3(1.)-vec3(4.,1.,0.)*pow(1.-float(eyeBrightnessFast)/240.,2.)/WATER_COLOR_ABSORB_DISTa,0.,1. ) 
							 : sky.rgb ;
							 
							 color.rgb = isEyeInWater == 1?
							 color.rgb * clamp( vec3(1.)-vec3(4.,1.,0.)*pow(1.-float(eyeBrightnessFast)/240.,2.)/WATER_COLOR_ABSORB_DISTa,0.,1. ) 
							 : color.rgb ;
			
						}
						
			
			//water blend in
			color.rgb = mix(color.rgb,water.rgb,water.a); 
			
	
			
			//color = (vec3(opaque_d-water_d)*.051);//debug
			
			

			float material = get_depth_at( texcoord) ;
			#if defined IS_IRIS && defined DISTANT_HORIZONS && BORDERS_IN_DH == 1	
				float opaque_depth = min( texture2D(depthtex1,refracted_coord).r,texture2D(dhDepthTex1,refracted_coord).r);
			#else
				float opaque_depth =  texture2D(depthtex1,refracted_coord).r;
			#endif
			
			

			color.a = (opaque_depth < 1. ?1.:0.);


			color.rgb = mix(color.rgb,sky.rgb, is_water?0.: 1.-(color.a+(1.-color.a)*water.a*(is_water?0.:1.)));

			
			//opaque_depth < Cloud_mask ?
			//0. 
			//:1.-water.a
			//);
			//if(water.a >= .5/255.) color.rgb*=.5+.5*water.rgb;
			
			vec4 hand = texture2D(colortex3, texcoord);
			//hand.a = hand.a>.5?.5:0.;//debug
			color.rgb = mix(color.rgb,hand.rgb,hand.a); 

		
	#else
		vec4 color = texture2D(colortex5, texcoord);
		
		vec3 sky = texture2D(colortex6, texcoord).rgb;

		float material = get_depth_at( texcoord) ;
		color.rgb = mix(color.rgb,sky.rgb, material < Cloud_mask ?0.:1.-color.a);
	#endif
	
	#if AO >= 1 || BORDERS >= 1
		vec2 texelSize = float( BACKGROUND_RESOLUTIION_DIVIDER )/ vec2(viewWidth,viewHeight);
	#endif
	#if AO >= 1
		
		float ao_dist = get_depth_at( texcoord) ;
		#if defined IS_IRIS && defined DISTANT_HORIZONS && BORDERS_IN_DH == 1
			float ao_wide =  texture2DLod(colortex1,texcoord,3.).x;
		#else
			float ao_wide =  linearize_depth_cpf(texture2DLod(depthtex0,texcoord,3.).r);
		#endif
		
		#if AO >= 3
			#include "/stuff/ao.glsl"
		#else
			float ao = 0.;
			float total_weight = 0.;
			float ao_steps=7.;
			float qq = -1.;
			
			for(int i = 1;i<ao_steps;i++)
			{
				float m = i;
				qq=-1.*(i/ao_steps);
				vec2 norm_dir = normals.xy*.0*(i/ao_steps);
				ao_wide = ( 
				  get_depth_at_lod(clamp(texcoord+norm_dir-texelSize*vec2(0.,-.9*qq)*pow(2,i),0.,1.),m)
				+ get_depth_at_lod(clamp(texcoord+norm_dir-texelSize*vec2(-.9*qq,0.)*pow(2,i),0.,1.),m)
				+ get_depth_at_lod(clamp(texcoord+norm_dir-texelSize*vec2(qq,qq)*pow(2.,i),0.,1.),m)
				+ get_depth_at_lod(clamp(texcoord+norm_dir-texelSize*vec2(0.,qq)*pow(2.,i),0.,1.),m)
				)*.25;
				float oc = ao_dist - ao_wide;
				float oclussion_dist = .5 +0.*ao_dist;
				#if AO == 1
					//clean
					oc=oc<oclussion_dist?oc: oc-(oc-oclussion_dist)/oclussion_dist;
				#endif	
				#if AO == 2
					//borders
					oc=oc<oclussion_dist?oc: oc-(oc-oclussion_dist);
				#endif	

				oc=ao_dist<2.?oc*(1.+11.*(1.-ao_dist/2.)) : oc;///(ao_dist-5.);
			//	oc/=1.*pow(ao_dist/far,.8);
				float weight = pow(1.-i/ao_steps,1.0);
				total_weight+=weight;
				ao+=max(0.,oc)*weight;
			} 
		#endif
		ao = clamp(1.-AO_DARKNESS*ao/total_weight,0.,1.);
		//ao*=.5;
		//color.rgb*=ao;
		
		//color.rgb=vec3(ao);
		
		#if AOGI == 1
			//gi
			vec3 gi = vec3(0.);
			for(float m = 4.;m<9.;m++)
			{
				vec2 norm_dir = normals.xy*.1*(m/ao_steps);
				gi.rgb+= texture2D(colortex5, texcoord+norm_dir,m).rgb*(3./(1.*m))
				*  mix (pow(max(0., dot(sign(ao_dist-get_depth_at_lod(texcoord+norm_dir,m)),(-normals.z))),.25) ,1.,ambient_lighting.a)
				;
			}
			#if defined IS_IRIS && defined DISTANT_HORIZONS
				gi*=1.-clamp(ao_dist/far,0.,1.);
			#else
				gi*=1.-pow(ao_dist/far,1.);
			#endif
			
			ambient_lighting.rgb+=gi;
		#endif	
		
		
		ambient_lighting.rgb*=mix(ao,1.,ambient_lighting.a*.3);
		
		color.rgb+=albedo* ambient_lighting.rgb*(1.-fog_amount);
		#if AO_DEBUG == 1
			color.rgb=vec3(ao);//ambient_lighting.rgb;
		#endif
		#if AO_DEBUG == 2
			color.rgb=ambient_lighting.rgb;
		#endif
		#if AO_DEBUG == 3 && AOGI == 1
			color.rgb=gi.rgb;
		#endif
		

	#else 
		color.rgb+=albedo* ambient_lighting.rgb*(1.-fog_amount);
	#endif
		
	#if BORDERS >= 1
		
		//vec2 texelSize = float( BORDER_WIDTH )/ vec2(viewWidth,viewHeight);
		 //vec2 floored = floor(texcoord / texelSize) * texelSize;
	
		//float material = get_depth_at( texcoord) ;
		float dist = material;//texture2D(colortex1,texcoord).y;
		
		
		float adjusted_dist = material*BORDERS_SENSITIVITY;//.05
		
		float material1 = get_depth_at( texcoord+texelSize*vec2(1.,0.)) ;
		float material2 = get_depth_at( texcoord+texelSize*vec2(-1.,0.)) ;
		float material3 = get_depth_at( texcoord+texelSize*vec2(0.,1.)) ;
		float material4 =get_depth_at( texcoord+texelSize*vec2(0.,-1.)) ;
		
		#if BORDER_SAMPLES >= 8
			float material11 = get_depth_at( texcoord+texelSize*vec2(2.,0.)) ;
			float material21 = get_depth_at( texcoord+texelSize*vec2(-2.,0.)) ;
			float material31 = get_depth_at( texcoord+texelSize*vec2(0.,2.)) ;
			float material41 =get_depth_at( texcoord+texelSize*vec2(0.,-2.)) ;
			#if BORDER_SAMPLES >= 12
				float material112 = get_depth_at( texcoord+texelSize*vec2(1.,1.)) ;
				float material212 = get_depth_at( texcoord+texelSize*vec2(-1.,-1.)) ;
				float material312 = get_depth_at( texcoord+texelSize*vec2(-1.,1.)) ;
				float material412 =get_depth_at( texcoord+texelSize*vec2(-1.,1.)) ;
				#if BORDER_SAMPLES >= 12
					float material1123 = get_depth_at( texcoord+texelSize*vec2(3.,0.)) ;
					float material2123 = get_depth_at( texcoord+texelSize*vec2(-3.,0.)) ;
					float material3123 = get_depth_at( texcoord+texelSize*vec2(0.,3.)) ;
					float material4123 =get_depth_at( texcoord+texelSize*vec2(0.,-3.)) ;
				#endif
			#endif

		#endif
		
		if(
		abs(material-material1)<adjusted_dist//*-.1
		&&abs(material-material2)<adjusted_dist//*-.1
		&&abs(material-material3)<adjusted_dist//*-.1
		&&abs(material-material4)<adjusted_dist//*-.1
		#if BORDER_SAMPLES >= 8
			&&abs(material-material11)<adjusted_dist//*-.1
			&&abs(material-material21)<adjusted_dist//*-.1
			&&abs(material-material31)<adjusted_dist//*-.1
			&&abs(material-material41)<adjusted_dist//*-.1
			#if BORDER_SAMPLES >= 12
				&&abs(material-material112)<adjusted_dist//*-.1
				&&abs(material-material212)<adjusted_dist//*-.1
				&&abs(material-material312)<adjusted_dist//*-.1
				&&abs(material-material412)<adjusted_dist//*-.1
				#if BORDER_SAMPLES >= 16
					&&abs(material-material1123)<adjusted_dist//*-.1
					&&abs(material-material2123)<adjusted_dist//*-.1
					&&abs(material-material3123)<adjusted_dist//*-.1
					&&abs(material-material4123)<adjusted_dist//*-.1
				#endif
			#endif
		#endif
		)
		{}else{
			
			
			
			
			#if FOG == 12
				float water_fog = isEyeInWater == 1? 30. : isEyeInWater == 2? 20. : isEyeInWater == 1? 10. : 0.;
				water_fog = (water_fog > 1. ) ? clamp((dist)/water_fog,0.,1.) : 0.;
				//focolortex5 FOG_START FOG_END
					float border_fog_amount = clamp((dist-(BORDER_FOG_START*far1))/(((1.-BORDER_FOG_START)*far1)),0.,1.);
					float fog_amount = 
						clamp(
						max(
						water_fog,
						max( 
							clamp((dist-FOG_START)/(FOG_END-FOG_START),0.,FOG_MAX),
							border_fog_amount)
							*(1.+rainStrength)
							)
						,0.,1.)
						;
					#if EXPONENTIAL_FOG == 1
						fog_amount=pow(fog_amount,2.);
					#endif
					//
					#if defined IS_IRIS
						#if defined DISTANT_HORIZONS
							fog_amount = pow(1.-1./dist,DH_FOG_EXPONENT);
						#endif
					#endif
					//
					
			#endif
			
			
			
			#if BORDERS >= 2
				vec3 border_color = texture2D(colortex1, texcoord).rgb;
				color.rgb = 
				mix(
				color.rgb,
				border_color,
	
				clamp(
				1./(dist*.1)
				
				*clamp(1.-(dist-far1*.5)/(far1*.1),0.,1.)
				
				
				,0.,1.)
				
				)
				//,focolortex5, fog_amount)
				;
				
				
			#else
			
				color.rgb *= 
				//mix(
				
				mix(1.,0.,
				#if defined IS_IRIS && defined DISTANT_HORIZONS && BORDERS_IN_DH == 1
					((material)>0.1? BORDER_OPACITY :0.)*
					(1.-
					clamp(dist*DH_BORDERS_FADE/dhFarPlane
					#if FOG == 1
						+fog_amount*FOG_HIDES_DH_BORDERS
					#endif
					,0.,1.)));
				#else
					BORDER_OPACITY * clamp(
					//1.-
					1./(dist*.1)
					*clamp(1.-(dist-far1*.5)/(far1*.1)
					#if FOG == 1
						+fog_amount*FOG_HIDES_DH_BORDERS
					#endif
					,0.,1.)
					
					,0.,1.)
					)
					//,focolortex5, fog_amount)
					;
				#endif
				
				
			#endif
		}
		
	#endif

	
	
	
	
	
	
	#if GODRAYS == 1
	bool amore = !(sunPosition.z<0.001);
	bool sunrise = !amore && sunAngle>.5;
	
					
					#if SUNSET == 22
					#include "/stuff/suncolor.glsl"
					sun_color = mix(sun_color, sun_color_hi,.5)*(1.+1.*
					(clamp((1.-abs(sunAngle-
		  (sunAngle<.5? .25 : .75)
		  
				)*4.)*SUNSET_EXPONENT*11.5
			,0.,1.))
					);
					
					
			
		  
					#endif
					#if SUNSET == 2
					
						vec3 sun_hue = clamp(vec3(SUN_COLOR_R,SUN_COLOR_G,SUN_COLOR_B) 	  -  vec3(SUNSET_FADE_R,SUNSET_FADE_G,SUNSET_FADE_B ) *(1.-clamp((1.-abs(sunAngle- (sunAngle<.5? .25 : .75))*4.)*SUNSET_EXPONENT*3.5,0.,5.)),0.,1.) ;
						sun_hue = sun_hue/max(sun_hue.r,max(sun_hue.g,sun_hue.b));
						vec3 sun_color =
						max(vec3(0.),
						
					
					
							(sunAngle <.5?
							(//day
							!amore?
							(
							
					//		vec3(SUN_COLOR_R,SUN_COLOR_G,SUN_COLOR_B)
							 sun_hue
*SUN_BRIGHTNESS
							 
							
							#if CLOUDS == 6
								//*(material > 9990.?1.-SUN_RAYS_OVER_SKY*color.g : 1.)
								*pow(1.-SUN_RAYS_OVER_SKY*color.g ,.5)
							#endif
							//sunrise
							*(1.+2.*(clamp(
							(1.-abs(sunAngle-(sunAngle>.25? .5:0.))
							*40.
						
							),0.,1.)))
							)
							
							:
							(//moon in daytime
							vec3(MOON_COLOR_R,MOON_COLOR_G,MOON_COLOR_B) *MOON_BRIGHTNESS
							//moonset
							*(1.-clamp(
							abs(sunAngle-(sunAngle<.25? 0. : .5))
							*30.,0.,1.))
							)
							
							)//day
							:
							
							(//pizza pie
							amore?
							vec3(MOON_COLOR_R,MOON_COLOR_G,MOON_COLOR_B)*MOON_BRIGHTNESS
							//no moonset
							
							:
						//	vec3(SUN_COLOR_R,SUN_COLOR_G,SUN_COLOR_B)
							sun_hue
							*SUN_BRIGHTNESS
							#if CLOUDS == 6 
								//*(material > 9990.?1.-SUN_RAYS_OVER_SKY*color.g : 1.)
								*pow(1.-SUN_RAYS_OVER_SKY*color.g ,.5)
							#endif
							//sunrise
							*3.*((clamp(
							(1.-abs(sunAngle-(sunAngle<.75? .5 : 1.))
							
							*40.
					
							),0.,1.)))
							
							)//not love
							)
						

						  -
						  (
						  amore?vec3(0.)
						  
						  :
						  vec3(SUNSET_FADE_R,SUNSET_FADE_G,SUNSET_FADE_B )
						  *(1.-clamp((1.-abs(sunAngle-
						  (sunAngle<.5? .25 : .75)
						  )*4.)*10.,0.,1.))
						  
						  )
						  )
						  
						
						  ;
						  /*
						  float gray = (sun_color.r+sun_color.b+sun_color.g)/3.;
						  vec3 hue = sun_color-vec3(gray);
						  sun_color = (vec3(1.)+hue)
						  *(1.-clamp((1.-abs(sunAngle-
						  (sunAngle<.5? .25 : .75)
						  )*4.)*10.,0.,1.));
						  */
					#endif
						 
		


float l =0.0;
		
		
		//if(!amore )
		{
		vec3 celestial = amore? sunPosition*-1.:sunPosition;
		vec4 sunp = gbufferProjection*vec4(celestial,1.);
		sunp.xyz/=sunp.w;
		vec2 c=.5+.5*sunp.xy;
		//vec2 c=.3+vec2(sin(time*.3),.2*cos(time*1.7));
		
		for(float s=0.;s<GODRAY_SAMPLES;s++)
		{
			float z = s/GODRAY_SAMPLES;
		  l+=
		  GR_STR*
		 // pow(
		#if CLOUDS == 3
		//	min( pow(clamp(cloud_depth/far1,0.,1.),1.0),
		#endif
			get_depth_at2((texcoord-c)
		  	 //texture2D(depth2,(texcoord-c)
		  	*(z-GODRAY_DITHER/GODRAY_SAMPLES*random(random(32.*dot(texcoord,vec2(.718,.1287)))))
        +c)
       // ,5.)
	   #if CLOUDS == 3
		//	)
		#endif
        ;
		  //1.-texture2D(depth,clamp((texcoord-c)*z+c,0.,1.)).r;
		  float os = pow(clamp((1.-distance(c,vec2(0.5))/2.9),0.,1.),GR_VIEW_SMOOTH*(sunrise ? 10.:5.));
		  os= amore? (os > .7?.7+.3*pow((os-.7)/.3,11.):os)
		  :
		 
		   (os > .5?.5+.5*pow((os-.5)/.5,11.):os)
		  ;
		  
		  os= amore? min(os,.75):min(os,.6);
		  l*=1.-(1.-os)
		  *	(.5-.5*z)
		  *	clamp((distance(texcoord,c)-GR_SUN_WIDTH )/ SUN_GR_HAZE ,0.0,1.);

		 l*=pow(os,0.05);
		 // l*=pow( clamp((1.-2.*max(abs(c.x-0.5),abs(c.y-.5)))*7.,0.,1.),.5);
			}

			l/=GODRAY_SAMPLES;
			
			
				color.rgb+=l*(1.-cloudy*.5)*sun_color
				#if UNDERWATER_GODRAYS == 1
					*( isEyeInWater == 1? mix(vec3(1.),fogColor,float(eyeBrightnessFast)/240.) : vec3(1.) )
				#endif
				
				*(sunAngle>.5?1.:max(Foggy,mix(1.,
					#if UNDERWATER_GODRAYS == 1
						( isEyeInWater == 1? 1. : NOON_GODRAYS)
					#else
						NOON_GODRAYS
					#endif
				,1.-clamp(abs(sunAngle-.25)*4.,0.,1.))));
			}
			
	#endif
	
	
	
	
	
	
	
	
	
	
	
	


	//sky fog under water
	if( isEyeInWater == 1 )
	{
		color.rgb=mix(color.rgb,
			fogColor.rgb
			*skyColor*float(eyeBrightnessSmooth.y)/240.
			,(is_water? pow(clamp( material / (WATER_VISIBILITY),0.,1.) ,.75) : 0.)
			)			
			;

		
	}
		
		
	if(nightVision	>0.0)
	{
		color.rgb=pow(color.rgb,vec3(1.-.5*max(0.,nightVision-float(eyeBrightnessSmooth.y)/240.)) ) ;
		color.b*=1.1;
	}	

	#if DEBUG_SHADOWS == 1
		color.rgb=texture2D(shadowcolor0, texcoord).rgb ;
	#endif
	;//(material>0.01?1.:0.)*vec3(1-clamp(material/dhFarPlane,0.,1.));

	#if FIX_COLOR_SPACE == 1
		//color.rgb=pow(color.rgb,vec3(1./2.2));
	#endif
	
	#if DONT_BLOW_OUT_WHITES == 2
		float gray = (color.r +color.g+color.b)/3.;
		float lum = gray/(gray+TONEMAPPING2_STRENGTH);
		color.rgb*=lum;
	#endif
	
	/*
	color.r=color.r<.9?color.r:.9+(color.r-.9)*.1;
	color.g=color.g<.9?color.g:.9+(color.g-.9)*.1;
	color.b=color.b<.9?color.b:.9+(color.b-.9)*.1;
	//color=(color-.5)*1.1+.5;
	*/
	
	//color.rgb = fract(100.0 * vec3(1-clamp(material/dhFarPlane,0.,1.)) );//debug
	//color.rgb = fract(60.0 * vec3(1-clamp(get_underwater_depth_at(texcoord)/dhFarPlane,0.,1.)) );//debug


/* DRAWBUFFERS:0 */
	gl_FragData[0] = vec4(color.rgb, 1.0); 
}