/*
 * Decompiled with CFR 0.152.
 */
package net.juyoh.backoff.block;

import com.simibubi.create.content.kinetics.base.KineticBlock;
import com.simibubi.create.foundation.block.IBE;
import com.simibubi.create.foundation.blockEntity.SyncedBlockEntity;
import java.util.Objects;
import net.createmod.catnip.platform.CatnipServices;
import net.juyoh.backoff.CreateBackOff;
import net.juyoh.backoff.block.ModBlockEntities;
import net.juyoh.backoff.block.ResistorBlockEntity;
import net.juyoh.backoff.item.EntityTypeComponent;
import net.juyoh.backoff.item.ModItemComponents;
import net.juyoh.backoff.network.ResistorConfigPacket;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;

public class ResistorBlock
extends KineticBlock
implements IBE<ResistorBlockEntity> {
    private static VoxelShape empty = Block.box((double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0);

    public ResistorBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public Direction.Axis getRotationAxis(BlockState state) {
        return Direction.Axis.Y;
    }

    public boolean hasShaftTowards(LevelReader world, BlockPos pos, BlockState state, Direction face) {
        return face == Direction.DOWN;
    }

    public Class<ResistorBlockEntity> getBlockEntityClass() {
        return ResistorBlockEntity.class;
    }

    public BlockEntityType<? extends ResistorBlockEntity> getBlockEntityType() {
        return (BlockEntityType)ModBlockEntities.RESISTOR_BE.get();
    }

    @NotNull
    protected VoxelShape getOcclusionShape(BlockState state, BlockGetter level, BlockPos pos) {
        return empty;
    }

    protected boolean isOcclusionShapeFullBlock(BlockState state, BlockGetter level, BlockPos pos) {
        return false;
    }

    protected boolean isCollisionShapeFullBlock(BlockState state, BlockGetter level, BlockPos pos) {
        return true;
    }

    protected VoxelShape getVisualShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return empty;
    }

    protected boolean useShapeForLightOcclusion(BlockState state) {
        return true;
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        if (stack.is(CreateBackOff.RESTRAINING_ORDER.asItem())) {
            ResistorBlockEntity blockEntity = (ResistorBlockEntity)level.getBlockEntity(pos);
            if (blockEntity.shouldResistEntity((Entity)player)) {
                player.displayClientMessage((Component)Component.translatable((String)"tooltip.createbackoff.resistor.deny").withStyle(ChatFormatting.RED), true);
                return ItemInteractionResult.FAIL;
            }
            if (!Objects.equals(blockEntity.filter, "*") && !player.isCreative()) {
                blockEntity.dropStack();
            }
            if (stack.has(ModItemComponents.ENTITY_COMPONENT)) {
                String newFilter;
                player.displayClientMessage((Component)Component.translatable((String)"tooltip.createbackoff.resistor.bound").withStyle(ChatFormatting.GREEN), true);
                blockEntity.filter = newFilter = ((EntityTypeComponent)stack.get(ModItemComponents.ENTITY_COMPONENT)).name();
                stack.consume(1, (LivingEntity)player);
                level.playSound(null, pos, SoundEvents.BEACON_POWER_SELECT, SoundSource.BLOCKS, 1.0f, 1.0f);
                if (player.level().isClientSide) {
                    CatnipServices.NETWORK.sendToServer((CustomPacketPayload)new ResistorConfigPacket(pos.getX(), pos.getY(), pos.getZ(), newFilter));
                } else {
                    this.withBlockEntityDo((BlockGetter)level, pos, SyncedBlockEntity::notifyUpdate);
                }
                this.addParticles(level, pos, level.random, blockEntity.calculateSize(), 320);
                return ItemInteractionResult.SUCCESS;
            }
        }
        return super.useItemOn(stack, state, level, pos, player, hand, hitResult);
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        if (player.isCrouching()) {
            String newFilter;
            ResistorBlockEntity blockEntity = (ResistorBlockEntity)level.getBlockEntity(pos);
            if (blockEntity.shouldResistEntity((Entity)player)) {
                player.displayClientMessage((Component)Component.translatable((String)"tooltip.createbackoff.resistor.deny").withStyle(ChatFormatting.RED), true);
                return InteractionResult.FAIL;
            }
            if (!Objects.equals(blockEntity.filter, "*") && !player.isCreative()) {
                blockEntity.dropStack();
            }
            player.displayClientMessage((Component)Component.translatable((String)"tooltip.createbackoff.restraining_order.wildcard").withStyle(ChatFormatting.GREEN), true);
            blockEntity.filter = newFilter = "*";
            level.playSound(null, pos, SoundEvents.BEACON_POWER_SELECT, SoundSource.BLOCKS, 1.0f, 1.0f);
            if (player.level().isClientSide) {
                CatnipServices.NETWORK.sendToServer((CustomPacketPayload)new ResistorConfigPacket(pos.getX(), pos.getY(), pos.getZ(), newFilter));
            } else {
                this.withBlockEntityDo((BlockGetter)level, pos, SyncedBlockEntity::notifyUpdate);
            }
            this.addParticles(level, pos, level.random, blockEntity.calculateSize(), 320);
            return InteractionResult.SUCCESS;
        }
        return super.useWithoutItem(state, level, pos, player, hitResult);
    }

    public void addParticles(Level level, BlockPos pos, RandomSource random, int size, int amount) {
        if (size == 0) {
            return;
        }
        double x = random.nextDouble() * 3.0;
        double y = random.nextDouble() * 3.0;
        double z = random.nextDouble() * 3.0;
        int l = 0;
        while ((double)l < (double)amount / 3.5) {
            level.addParticle((ParticleOptions)new DustParticleOptions(new Vector3f(0.9f, 0.3f, 0.4f), 0.6f), (double)pos.getX() - 0.5 + x, (double)pos.getY() - 0.5 + y, (double)pos.getZ() - 0.5 + z, x * (double)size, y * (double)size, z * (double)size);
            ++l;
        }
        for (l = 0; l < amount; ++l) {
            level.addParticle((ParticleOptions)new DustParticleOptions(new Vector3f(0.7f, 0.4f, 0.3f), 0.3f), (double)pos.getX() - 0.5 + x, (double)pos.getY() - 0.5 + y, (double)pos.getZ() - 0.5 + z, x * (double)size * 2.0, y * (double)size * 2.0, z * (double)size * 2.0);
        }
    }

    public void onPlace(BlockState state, Level worldIn, BlockPos pos, BlockState oldState, boolean isMoving) {
        super.onPlace(state, worldIn, pos, oldState, isMoving);
        CreateBackOff.resistors.put(pos, (ResourceKey<Level>)worldIn.dimension());
    }

    public void setPlacedBy(Level worldIn, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        super.setPlacedBy(worldIn, pos, state, placer, stack);
        BlockEntity blockEntity = worldIn.getBlockEntity(pos);
        if (blockEntity instanceof ResistorBlockEntity && placer instanceof Player) {
            ((ResistorBlockEntity)blockEntity).owner = placer.getUUID();
        }
    }

    public void onRemove(BlockState pState, Level pLevel, BlockPos pPos, BlockState pNewState, boolean pIsMoving) {
        BlockEntity entity = pLevel.getBlockEntity(pPos);
        if (entity instanceof ResistorBlockEntity) {
            ((ResistorBlockEntity)entity).dropStack();
            CreateBackOff.resistors.remove(pPos, pLevel.dimension());
        }
    }

    public SoundType getSoundType(BlockState state, LevelReader level, BlockPos pos, @Nullable Entity entity) {
        return SoundType.METAL;
    }

    public void animateTick(BlockState state, Level level, BlockPos pos, RandomSource random) {
        super.animateTick(state, level, pos, random);
        this.addParticles(level, pos, random, ((ResistorBlockEntity)level.getBlockEntity(pos)).calculateSize(), 64);
    }
}

