/*
 * Decompiled with CFR 0.152.
 */
package net.juyoh.backoff.block;

import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.infrastructure.config.AllConfigs;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import joptsimple.internal.Strings;
import net.juyoh.backoff.CreateBackOff;
import net.juyoh.backoff.item.EntityTypeComponent;
import net.juyoh.backoff.item.ModItemComponents;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class ResistorBlockEntity
extends KineticBlockEntity {
    String filter = "*";
    UUID owner;
    public boolean isColliding;

    public ResistorBlockEntity(BlockEntityType<?> typeIn, BlockPos pos, BlockState state) {
        super(typeIn, pos, state);
    }

    public void initialize() {
        super.initialize();
        CreateBackOff.resistors.put(this.getBlockPos(), (ResourceKey<Level>)this.level.dimension());
    }

    protected void read(CompoundTag compound, HolderLookup.Provider registries, boolean clientPacket) {
        super.read(compound, registries, clientPacket);
        this.filter = compound.getString("filter");
        this.owner = compound.getUUID("owner");
    }

    protected void write(CompoundTag compound, HolderLookup.Provider registries, boolean clientPacket) {
        super.write(compound, registries, clientPacket);
        compound.putString("filter", this.filter);
        if (this.owner != null) {
            compound.putUUID("owner", this.owner);
        }
    }

    public void writeSafe(CompoundTag tag, HolderLookup.Provider registries) {
        super.writeSafe(tag, registries);
        tag.putString("filter", this.filter);
        if (this.owner != null) {
            tag.putUUID("owner", this.owner);
        }
    }

    public boolean addToGoggleTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        tooltip.add((Component)Component.literal((String)Strings.repeat((char)' ', (int)ResistorBlockEntity.getIndents(Minecraft.getInstance().font))).append((Component)Component.translatable((String)"tooltip.createbackoff.resistor.goggles")));
        tooltip.add((Component)this.getTooltip());
        if (this.isPlayerOwner(Minecraft.getInstance().player.getUUID())) {
            tooltip.add((Component)Component.translatable((String)"tooltip.createbackoff.resistor.owner").withStyle(ChatFormatting.GREEN));
        }
        return super.addToGoggleTooltip(tooltip, isPlayerSneaking);
    }

    static int getIndents(Font font) {
        int spaceWidth = font.width(" ");
        if (4.0f == (float)spaceWidth) {
            return 4;
        }
        return Mth.ceil((float)(16.0f / (float)spaceWidth));
    }

    protected Block getStressConfigKey() {
        return (Block)CreateBackOff.RESISTOR.get();
    }

    public MutableComponent getTooltip() {
        if (Objects.equals(this.filter, "*")) {
            return Component.translatable((String)"tooltip.createbackoff.restraining_order.wildcard");
        }
        return Component.translatable((String)"tooltip.createbackoff.restraining_order.bound").withStyle(ChatFormatting.GOLD).append(this.filter);
    }

    public void onSpeedChanged(float previousSpeed) {
        if (previousSpeed == 0.0f && this.speed != 0.0f) {
            this.level.playSound(null, this.getBlockPos(), SoundEvents.BEACON_ACTIVATE, SoundSource.BLOCKS, 1.0f, 1.0f);
        }
        if (previousSpeed != 0.0f && this.speed == 0.0f) {
            this.level.playSound(null, this.getBlockPos(), SoundEvents.BEACON_DEACTIVATE, SoundSource.BLOCKS, 1.0f, 1.0f);
        }
    }

    public void dropStack() {
        if (!Objects.equals(this.filter, "*")) {
            ItemStack stack = new ItemStack((ItemLike)CreateBackOff.RESTRAINING_ORDER.asItem());
            stack.setCount(1);
            stack.set(ModItemComponents.ENTITY_COMPONENT, (Object)new EntityTypeComponent(this.filter));
            this.level.addFreshEntity((Entity)new ItemEntity(this.level, (double)this.getBlockPos().getX(), (double)this.getBlockPos().getY(), (double)this.getBlockPos().getZ(), stack));
            this.resetFilter();
        }
        this.setChanged();
    }

    public static int getMaxSize() {
        if (!ResistorBlockEntity.isConfigReady()) {
            return 0;
        }
        return ResistorBlockEntity.calculateSize(((Integer)AllConfigs.server().kinetics.maxRotationSpeed.get()).intValue());
    }

    public static boolean isConfigReady() {
        boolean ready;
        try {
            AllConfigs.server().kinetics.maxRotationSpeed.get();
            ready = true;
        }
        catch (Exception e) {
            ready = false;
        }
        return ready;
    }

    public int calculateSize() {
        return ResistorBlockEntity.calculateSize(this.getSpeed());
    }

    public static int calculateSize(float speedIn) {
        return speedIn == 0.0f ? 0 : (int)(Math.abs(speedIn) / 8.0f) + 4;
    }

    public boolean filterEquals(String translatedName) {
        return translatedName.equals(this.filter) || this.filter.equals("*");
    }

    public String getFilter() {
        return this.filter;
    }

    public void setFilter(String filter) {
        this.filter = filter;
    }

    public UUID getOwner() {
        return this.owner;
    }

    public void resetFilter() {
        this.filter = "*";
    }

    public boolean isInside(Vec3 pos) {
        Vec3 thisPos = this.getBlockPos().getBottomCenter();
        int size = this.calculateSize();
        AABB box = new AABB(thisPos.add((double)size, (double)size, (double)size), thisPos.add((double)(-size), (double)(-size), (double)(-size)));
        return box.contains(pos);
    }

    public boolean isInsideWall(Vec3 pos) {
        Vec3 thisPos = this.getBlockPos().getBottomCenter();
        int size = this.calculateSize();
        AABB regularBox = new AABB(thisPos.add((double)size, (double)size, (double)size), thisPos.add((double)(-size), (double)(-size), (double)(-size)));
        AABB smallerBox = new AABB(thisPos.add((double)(size - 1), (double)(size - 1), (double)(size - 1)), thisPos.add((double)(-(size - 1)), (double)(-(size - 1)), (double)(-(size - 1))));
        return !smallerBox.contains(pos) && regularBox.contains(pos);
    }

    public boolean isPlayerOwner(UUID player) {
        if (this.owner == null) {
            return false;
        }
        return this.owner.equals(player);
    }

    public boolean shouldResistEntity(Entity entity) {
        if (entity instanceof Player) {
            if (this.filterEquals(entity.getDisplayName().getString()) && !this.isPlayerOwner(entity.getUUID())) {
                return true;
            }
        } else {
            if (this.filterEquals(entity.getDisplayName().getString())) {
                return true;
            }
            if (!this.filterEquals(entity.getDisplayName().getString()) && this.getFilter().equals("*")) {
                return true;
            }
        }
        return false;
    }

    public void tick() {
        this.isColliding = false;
        super.tick();
        if (this.speed > 0.0f && this.level.getGameTime() % 80L == 0L) {
            this.level.playSound(null, this.getBlockPos(), SoundEvents.BEACON_AMBIENT, SoundSource.BLOCKS, 1.0f, 1.0f);
        }
    }
}

