/*
 * Decompiled with CFR 0.152.
 */
package net.juyoh.backoff.mixin;

import java.util.ConcurrentModificationException;
import java.util.Optional;
import net.juyoh.backoff.CreateBackOff;
import net.juyoh.backoff.block.ModBlockEntities;
import net.juyoh.backoff.block.ResistorBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.EntityCollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={BlockBehaviour.class})
public abstract class IsBlockCollidableMixin {
    @Inject(method={"getCollisionShape"}, at={@At(value="HEAD")}, cancellable=true)
    private void getCollisionShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context, CallbackInfoReturnable<VoxelShape> cir) {
        int maxSize = ResistorBlockEntity.getMaxSize();
        try {
            for (BlockPos entityPos : CreateBackOff.resistors.keySet()) {
                AABB maxBox = AABB.ofSize((Vec3)entityPos.getCenter().add(-0.5, -0.5, -0.5), (double)(maxSize * 2), (double)(maxSize * 2), (double)(maxSize * 2));
                if (!maxBox.contains(pos.getCenter())) continue;
                Optional entity = null;
                try {
                    if (!level.getBlockState(entityPos).hasBlockEntity() || (entity = level.getBlockEntity(entityPos, (BlockEntityType)ModBlockEntities.RESISTOR_BE.get())).isEmpty()) {
                        continue;
                    }
                }
                catch (Exception e) {
                    CreateBackOff.LOGGER.warn("Tried to access block entities in ungenerated chunk");
                }
                if (entity == null || entity.isEmpty() || !((ResistorBlockEntity)((Object)entity.get())).isInsideWall(pos.getCenter())) continue;
                ((ResistorBlockEntity)((Object)entity.get())).isColliding = false;
                if (context instanceof EntityCollisionContext && ((EntityCollisionContext)context).getEntity() != null) {
                    Entity collidingEntity = ((EntityCollisionContext)context).getEntity();
                    if (!((ResistorBlockEntity)((Object)entity.get())).shouldResistEntity(collidingEntity)) continue;
                    cir.setReturnValue((Object)Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0));
                    cir.cancel();
                    ((ResistorBlockEntity)((Object)entity.get())).isColliding = true;
                } else {
                    cir.setReturnValue((Object)Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0));
                    cir.cancel();
                }
                break;
            }
        }
        catch (ConcurrentModificationException e) {
            CreateBackOff.LOGGER.warn("Tried to iterate over Resistors map while it was being changed");
        }
    }
}

