/*
 * Decompiled with CFR 0.152.
 */
package net.juyoh.backoff.mixin;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.ConcurrentModificationException;
import net.createmod.catnip.outliner.Outliner;
import net.juyoh.backoff.CreateBackOff;
import net.juyoh.backoff.block.ResistorBlockEntity;
import net.minecraft.Util;
import net.minecraft.client.Camera;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.RenderBuffers;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix4f;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={LevelRenderer.class})
public abstract class ResistorBoxRenderMixin {
    @Shadow
    @Final
    private RenderBuffers renderBuffers;

    @Inject(method={"renderLevel"}, at={@At(value="INVOKE", target="Lcom/mojang/blaze3d/systems/RenderSystem;getModelViewStack()Lorg/joml/Matrix4fStack;", shift=At.Shift.BEFORE)})
    private void renderLevel(DeltaTracker deltaTracker, boolean renderBlockOutline, Camera camera, GameRenderer gameRenderer, LightTexture lightTexture, Matrix4f frustumMatrix, Matrix4f projectionMatrix, CallbackInfo ci) {
        ResourceLocation BORDER_TEXTURE = ResourceLocation.withDefaultNamespace((String)"textures/misc/forcefield.png");
        LocalPlayer player = Minecraft.getInstance().player;
        VertexConsumer vertexConsumer = this.renderBuffers.bufferSource().getBuffer(RenderType.debugFilledBox());
        Matrix4f matrix4f = RenderSystem.getModelViewMatrix();
        if (camera == null) {
            return;
        }
        try {
            for (BlockPos pos1 : CreateBackOff.resistors.keySet()) {
                float size;
                BlockEntity entity;
                if (CreateBackOff.resistors.get(pos1) != player.level().dimension() || !((entity = CreateBackOff.getBlockEntityAt(pos1, player.level())) instanceof ResistorBlockEntity) || (size = (float)((ResistorBlockEntity)entity).calculateSize()) == 0.0f) continue;
                float ms = Util.getMillis();
                float red = 0.9f;
                float green = 0.3f;
                float blue = 0.4f;
                float alpha = (float)((double)0.4f + Math.sin((double)ms / 2400.0) / 6.0);
                Outliner.getInstance().showAABB((Object)("resistorBox" + pos1.toShortString()), AABB.ofSize((Vec3)pos1.getCenter().add(-0.5, -0.5, -0.5), (double)(size * 2.0f), (double)(size * 2.0f), (double)(size * 2.0f))).colored(8331020).lineWidth(0.0625f).withFaceTextures(() -> BORDER_TEXTURE, () -> BORDER_TEXTURE).disableLineNormals();
                if (((ResistorBlockEntity)entity).isInside(camera.getPosition()) || ((ResistorBlockEntity)entity).isInsideWall(camera.getPosition())) {
                    Outliner.getInstance().showAABB((Object)("resistorBoxInside" + pos1.toShortString()), AABB.ofSize((Vec3)pos1.getCenter().add(-0.5, -0.5, -0.5), (double)(size * 2.0f - 2.0f), (double)(size * 2.0f - 2.0f), (double)(size * 2.0f - 2.0f))).colored(8331020).lineWidth(0.0625f);
                }
                RenderSystem.enableBlend();
                RenderSystem.enableDepthTest();
                RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
                RenderSystem.setShaderTexture((int)0, (ResourceLocation)BORDER_TEXTURE);
                RenderSystem.depthMask((boolean)Minecraft.useShaderTransparency());
                RenderSystem.setShaderColor((float)red, (float)green, (float)blue, (float)alpha);
                RenderSystem.setShader(GameRenderer::getPositionTexShader);
                RenderSystem.enablePolygonOffset();
                RenderSystem.disableCull();
                float x = (float)(pos1.getBottomCenter().x() - camera.getPosition().x());
                float y = (float)(pos1.getBottomCenter().y() - camera.getPosition().y());
                float z = (float)(pos1.getBottomCenter().z() - camera.getPosition().z());
                float minX = x - (size + 0.5f);
                float maxX = x + (size - 0.5f);
                float minY = y - size;
                float maxY = y + size;
                float minZ = z - (size + 0.5f);
                float maxZ = z + (size - 0.5f);
                vertexConsumer.addVertex(matrix4f, minX, minY, minZ).setColor(red, green, blue, alpha);
                vertexConsumer.addVertex(matrix4f, minX, minY, minZ).setColor(red, green, blue, alpha);
                vertexConsumer.addVertex(matrix4f, minX, minY, minZ).setColor(red, green, blue, alpha);
                vertexConsumer.addVertex(matrix4f, minX, minY, maxZ).setColor(red, green, blue, alpha);
                vertexConsumer.addVertex(matrix4f, minX, maxY, minZ).setColor(red, green, blue, alpha);
                vertexConsumer.addVertex(matrix4f, minX, maxY, maxZ).setColor(red, green, blue, alpha);
                vertexConsumer.addVertex(matrix4f, minX, maxY, maxZ).setColor(red, green, blue, alpha);
                vertexConsumer.addVertex(matrix4f, minX, minY, maxZ).setColor(red, green, blue, alpha);
                vertexConsumer.addVertex(matrix4f, maxX, maxY, maxZ).setColor(red, green, blue, alpha);
                vertexConsumer.addVertex(matrix4f, maxX, minY, maxZ).setColor(red, green, blue, alpha);
                vertexConsumer.addVertex(matrix4f, maxX, minY, maxZ).setColor(red, green, blue, alpha);
                vertexConsumer.addVertex(matrix4f, maxX, minY, minZ).setColor(red, green, blue, alpha);
                vertexConsumer.addVertex(matrix4f, maxX, maxY, maxZ).setColor(red, green, blue, alpha);
                vertexConsumer.addVertex(matrix4f, maxX, maxY, minZ).setColor(red, green, blue, alpha);
                vertexConsumer.addVertex(matrix4f, maxX, maxY, minZ).setColor(red, green, blue, alpha);
                vertexConsumer.addVertex(matrix4f, maxX, minY, minZ).setColor(red, green, blue, alpha);
                vertexConsumer.addVertex(matrix4f, minX, maxY, minZ).setColor(red, green, blue, alpha);
                vertexConsumer.addVertex(matrix4f, minX, minY, minZ).setColor(red, green, blue, alpha);
                vertexConsumer.addVertex(matrix4f, minX, minY, minZ).setColor(red, green, blue, alpha);
                vertexConsumer.addVertex(matrix4f, maxX, minY, minZ).setColor(red, green, blue, alpha);
                vertexConsumer.addVertex(matrix4f, minX, minY, maxZ).setColor(red, green, blue, alpha);
                vertexConsumer.addVertex(matrix4f, maxX, minY, maxZ).setColor(red, green, blue, alpha);
                vertexConsumer.addVertex(matrix4f, maxX, minY, maxZ).setColor(red, green, blue, alpha);
                vertexConsumer.addVertex(matrix4f, minX, maxY, minZ).setColor(red, green, blue, alpha);
                vertexConsumer.addVertex(matrix4f, minX, maxY, minZ).setColor(red, green, blue, alpha);
                vertexConsumer.addVertex(matrix4f, minX, maxY, maxZ).setColor(red, green, blue, alpha);
                vertexConsumer.addVertex(matrix4f, maxX, maxY, minZ).setColor(red, green, blue, alpha);
                vertexConsumer.addVertex(matrix4f, maxX, maxY, maxZ).setColor(red, green, blue, alpha);
                vertexConsumer.addVertex(matrix4f, maxX, maxY, maxZ).setColor(red, green, blue, alpha);
                vertexConsumer.addVertex(matrix4f, maxX, maxY, maxZ).setColor(red, green, blue, alpha);
                RenderSystem.enableCull();
                RenderSystem.disableBlend();
                RenderSystem.defaultBlendFunc();
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                RenderSystem.depthMask((boolean)true);
            }
        }
        catch (ConcurrentModificationException e) {
            CreateBackOff.LOGGER.warn("Tried to iterate over Resistors map while it was being changed");
        }
    }
}

