/*
 * Decompiled with CFR 0.152.
 */
package net.typho.vibrancy;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import foundry.veil.api.client.render.VeilRenderSystem;
import foundry.veil.api.client.render.light.PointLight;
import java.util.Collection;
import java.util.Objects;
import java.util.Random;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_287;
import net.minecraft.class_290;
import net.minecraft.class_291;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_3341;
import net.minecraft.class_3532;
import net.minecraft.class_4184;
import net.minecraft.class_5944;
import net.typho.vibrancy.RaytracedLight;
import net.typho.vibrancy.Vibrancy;
import org.joml.Matrix4f;
import org.joml.Vector3d;
import org.joml.Vector3f;
import org.lwjgl.glfw.GLFW;
import org.lwjgl.opengl.GL15;
import org.lwjgl.opengl.GL30;

public abstract class AbstractRaytracedLight
extends PointLight
implements RaytracedLight {
    protected final class_291 geomVBO = new class_291(class_291.class_8555.field_44794);
    protected final class_291 boxVBO = new class_291(class_291.class_8555.field_44794);
    protected final int quadsSSBO = GL15.glGenBuffers();
    protected boolean anyShadows = false;
    protected float flicker = 0.0f;
    protected float flickerMin;
    protected float flickerMax;
    protected float flickerStart = (float)GLFW.glfwGetTime();

    public float getFlicker() {
        return this.flicker;
    }

    public AbstractRaytracedLight setFlicker(float flicker) {
        this.flicker = flicker;
        this.markDirty();
        return this;
    }

    public void upload(class_287 builder, Collection<RaytracedLight.ShadowVolume> volumes) {
        if (volumes.isEmpty()) {
            this.anyShadows = false;
        } else {
            this.anyShadows = true;
            this.upload(builder, volumes, this.geomVBO, this.quadsSSBO, 35048);
        }
    }

    public class_3341 getBox() {
        Vector3d pos = this.getPosition();
        class_2338 lightBlockPos = new class_2338((int)Math.floor(pos.x), (int)Math.floor(pos.y), (int)Math.floor(pos.z));
        int blockRadius = Vibrancy.capShadowDistance((int)Math.ceil(this.radius) - 2);
        class_3341 box = new class_3341(lightBlockPos);
        if (blockRadius > 1) {
            box = box.method_35410(blockRadius);
        }
        return box;
    }

    protected void renderMask(class_2960 fbo, Matrix4f view) {
        Objects.requireNonNull(VeilRenderSystem.renderer().getFramebufferManager().getFramebuffer(fbo)).bind(true);
        GL15.glClearColor((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f);
        GL15.glClear((int)16640);
        this.geomVBO.method_1353();
        this.geomVBO.method_34427(view, RenderSystem.getProjectionMatrix(), RenderSystem.getShader());
        class_291.method_1354();
    }

    protected void renderMask(boolean raytrace, Vector3f lightPos, class_4184 camera, Matrix4f view) {
        if (this.anyShadows && raytrace) {
            VeilRenderSystem.setShader((class_2960)Vibrancy.id("light/ray/mask"));
            class_5944 shader = Objects.requireNonNull(RenderSystem.getShader());
            shader.method_35785("LightPos").method_1249(lightPos.x, lightPos.y, lightPos.z);
            shader.method_35785("LightRadius").method_1251(this.radius);
            shader.method_35785("Detailed").method_35649(1);
            RenderSystem.depthMask((boolean)false);
            RenderSystem.disableDepthTest();
            RenderSystem.enableBlend();
            RenderSystem.blendFunc((GlStateManager.class_4535)GlStateManager.class_4535.ONE, (GlStateManager.class_4534)GlStateManager.class_4534.ONE);
            RenderSystem.blendEquation((int)32774);
            RenderSystem.disableCull();
            GL30.glBindBufferBase((int)37074, (int)0, (int)this.quadsSSBO);
            this.renderMask(Vibrancy.id("shadow_mask"), view);
            RenderSystem.enableCull();
            RenderSystem.depthMask((boolean)true);
            RenderSystem.disableBlend();
            GL30.glBindBufferBase((int)37074, (int)0, (int)0);
        } else {
            Objects.requireNonNull(VeilRenderSystem.renderer().getFramebufferManager().getFramebuffer(Vibrancy.id("shadow_mask"))).bind(false);
            GL15.glClearColor((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f);
            GL15.glClear((int)16640);
        }
    }

    protected void renderLight(Vector3f lightPos, Matrix4f view) {
        Objects.requireNonNull(VeilRenderSystem.renderer().getFramebufferManager().getFramebuffer(Vibrancy.id("ray_light"))).bind(true);
        VeilRenderSystem.setShader((class_2960)Vibrancy.id("light/ray/point"));
        class_5944 shader = Objects.requireNonNull(RenderSystem.getShader());
        float time = (float)GLFW.glfwGetTime();
        while ((double)(time - this.flickerStart) > 0.25) {
            this.flickerStart += 0.25f;
            this.flickerMin = this.flickerMax;
            this.flickerMax = new Random().nextFloat(-1.0f, 1.0f);
        }
        float brightness = this.getBrightness() * (1.0f + this.flicker * class_3532.method_16439((float)((time - this.flickerStart) * 4.0f), (float)this.flickerMin, (float)this.flickerMax));
        shader.method_35785("LightPos").method_1249(lightPos.x, lightPos.y, lightPos.z);
        shader.method_35785("LightColor").method_1249(this.color.x * brightness, this.color.y * brightness, this.color.z * brightness);
        shader.method_35785("LightRadius").method_1251(this.radius);
        shader.method_35785("AnyShadows").method_35649(this.anyShadows ? 1 : 0);
        class_287 builder = RenderSystem.renderThreadTesselator().method_60827(class_293.class_5596.field_27382, class_290.field_1592);
        class_238 box = this.getBoundingBox();
        Vector3f[] vertices = new Vector3f[]{new Vector3f((float)box.field_1320, (float)box.field_1325, (float)box.field_1324), new Vector3f((float)box.field_1323, (float)box.field_1325, (float)box.field_1324), new Vector3f((float)box.field_1323, (float)box.field_1322, (float)box.field_1324), new Vector3f((float)box.field_1320, (float)box.field_1322, (float)box.field_1324), new Vector3f((float)box.field_1320, (float)box.field_1325, (float)box.field_1321), new Vector3f((float)box.field_1323, (float)box.field_1325, (float)box.field_1321), new Vector3f((float)box.field_1323, (float)box.field_1322, (float)box.field_1321), new Vector3f((float)box.field_1320, (float)box.field_1322, (float)box.field_1321)};
        builder.method_60830(vertices[0]).method_60830(vertices[1]).method_60830(vertices[2]).method_60830(vertices[3]);
        builder.method_60830(vertices[1]).method_60830(vertices[5]).method_60830(vertices[6]).method_60830(vertices[2]);
        builder.method_60830(vertices[5]).method_60830(vertices[4]).method_60830(vertices[7]).method_60830(vertices[6]);
        builder.method_60830(vertices[4]).method_60830(vertices[0]).method_60830(vertices[3]).method_60830(vertices[7]);
        builder.method_60830(vertices[1]).method_60830(vertices[0]).method_60830(vertices[4]).method_60830(vertices[5]);
        builder.method_60830(vertices[3]).method_60830(vertices[2]).method_60830(vertices[6]).method_60830(vertices[7]);
        RenderSystem.disableDepthTest();
        GL15.glCullFace((int)1028);
        RenderSystem.enableCull();
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((GlStateManager.class_4535)GlStateManager.class_4535.ONE, (GlStateManager.class_4534)GlStateManager.class_4534.ONE);
        RenderSystem.blendEquation((int)32774);
        this.boxVBO.method_1353();
        this.boxVBO.method_1352(builder.method_60800());
        this.boxVBO.method_34427(view, RenderSystem.getProjectionMatrix(), shader);
        class_291.method_1354();
        GL15.glCullFace((int)1029);
        RenderSystem.disableBlend();
    }

    @Override
    public class_238 getBoundingBox() {
        int rad = Math.max(Vibrancy.capShadowDistance((int)Math.ceil(this.radius) - 2), 0);
        Vector3d pos = this.getPosition();
        return new class_238(pos.x - (double)rad, pos.y - (double)rad, pos.z - (double)rad, pos.x + (double)rad, pos.y + (double)rad, pos.z + (double)rad);
    }

    public void free() {
        this.geomVBO.close();
        GL15.glDeleteBuffers((int)this.quadsSSBO);
    }
}

