/*
 * Decompiled with CFR 0.152.
 */
package net.typho.vibrancy;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.function.Consumer;
import net.minecraft.class_1309;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_310;
import net.minecraft.class_3341;
import net.minecraft.class_4184;
import net.minecraft.class_4588;
import net.minecraft.class_638;
import net.typho.vibrancy.AbstractRaytracedLight;
import net.typho.vibrancy.DynamicLightInfo;
import net.typho.vibrancy.RaytracedLight;
import net.typho.vibrancy.Vibrancy;
import org.joml.Matrix4f;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;

public class RaytracedPointEntityLight
extends AbstractRaytracedLight {
    public final class_1309 entity;
    protected boolean hasLight = false;
    protected Map<class_2338, List<RaytracedLight.Quad>> quads = new LinkedHashMap<class_2338, List<RaytracedLight.Quad>>();
    protected final List<class_2338> dirty = new LinkedList<class_2338>();
    protected class_3341 quadBox;
    protected CompletableFuture<Map<class_2338, List<RaytracedLight.Quad>>> fullRebuildTask;

    public RaytracedPointEntityLight(class_1309 entity) {
        this.entity = entity;
    }

    @Override
    public void updateDirty(Iterable<class_2338> it) {
        class_3341 box = this.getBox();
        for (class_2338 pos : it) {
            if (!box.method_14662((class_2382)pos)) continue;
            this.dirty.add(pos);
        }
    }

    @Override
    public void upload(class_287 builder, Collection<RaytracedLight.ShadowVolume> volumes) {
        if (volumes.isEmpty()) {
            this.anyShadows = false;
        } else {
            this.anyShadows = true;
            this.upload(builder, volumes, this.geomVBO, this.quadsSSBO, 35040);
        }
    }

    public void regenQuadsSync(class_638 world, class_2338 pos, Consumer<RaytracedLight.Quad> out, class_2338 lightBlockPos, Vector3f lightPos) {
        this.quads.remove(pos);
        this.regenQuadsAsync(world, pos, out, lightBlockPos, lightPos);
    }

    public void regenQuadsAsync(class_638 world, class_2338 pos, Consumer<RaytracedLight.Quad> out, class_2338 lightBlockPos, Vector3f lightPos) {
        this.getQuads(world, pos, out, pos.method_10262((class_2382)lightBlockPos), lightBlockPos, lightPos, false);
    }

    public void regenAll(class_638 world, class_3341 box, class_2338 lightBlockPos, Vector3f lightPos) {
        this.fullRebuildTask = CompletableFuture.supplyAsync(() -> {
            LinkedHashMap<class_2338, List<RaytracedLight.Quad>> quads = new LinkedHashMap<class_2338, List<RaytracedLight.Quad>>();
            for (int x = box.method_35415(); x <= box.method_35418(); ++x) {
                for (int y = box.method_35416(); y <= box.method_35419(); ++y) {
                    for (int z = box.method_35417(); z <= box.method_35420(); ++z) {
                        class_2338 pos = new class_2338(x, y, z);
                        List<RaytracedLight.Quad> existing = this.quads.get(pos);
                        if (existing != null && !existing.isEmpty()) {
                            quads.put(pos, existing);
                            continue;
                        }
                        LinkedList list = new LinkedList();
                        this.regenQuadsAsync(world, pos, list::add, lightBlockPos, lightPos);
                        if (list.isEmpty()) continue;
                        quads.put(pos, list);
                    }
                }
            }
            return quads;
        });
    }

    public boolean init(class_1799 stack) {
        class_1747 block;
        class_2680 state;
        DynamicLightInfo info;
        class_1792 class_17922 = stack.method_7909();
        if (class_17922 instanceof class_1747 && (info = DynamicLightInfo.get(state = (block = (class_1747)class_17922).method_7711().method_9564())) != null) {
            info.initLight(this, state);
            this.hasLight = true;
            return true;
        }
        return false;
    }

    @Override
    public void init() {
        float tickDelta = class_310.method_1551().method_60646().method_60637(true);
        class_243 entityPos = this.entity.method_5836(tickDelta).method_1019(this.entity.method_5828(tickDelta));
        this.setPosition(entityPos.field_1352, entityPos.field_1351, entityPos.field_1350);
    }

    @Override
    public boolean render(boolean raytrace) {
        if (!this.init(this.entity.method_6047()) && !this.init(this.entity.method_6079())) {
            return false;
        }
        class_638 world = class_310.method_1551().field_1687;
        if (world != null) {
            class_2338 lightBlockPos = new class_2338((int)Math.floor(this.getPosition().x), (int)Math.floor(this.getPosition().y), (int)Math.floor(this.getPosition().z));
            Vector3f lightPos = new Vector3f((float)this.getPosition().x, (float)this.getPosition().y, (float)this.getPosition().z);
            int blockRadius = Vibrancy.capShadowDistance((int)Math.ceil(this.radius) - 2);
            class_3341 box = this.getBox();
            LinkedList<RaytracedLight.ShadowVolume> volumes = new LinkedList<RaytracedLight.ShadowVolume>();
            class_287 builder = class_289.method_1348().method_60827(class_293.class_5596.field_27382, class_290.field_1592);
            if (this.isVisible()) {
                if (this.fullRebuildTask != null && this.fullRebuildTask.isDone()) {
                    try {
                        this.quads = this.fullRebuildTask.get();
                        this.fullRebuildTask = null;
                    }
                    catch (InterruptedException | ExecutionException e) {
                        throw new RuntimeException(e);
                    }
                } else if (this.hasLight) {
                    if (this.quadBox == null || !this.quadBox.method_14662((class_2382)this.entity.method_24515())) {
                        this.dirty.clear();
                        this.regenAll(world, blockRadius > 1 ? box.method_35410(blockRadius) : box, lightBlockPos, lightPos);
                        this.quadBox = box;
                    } else if (!this.dirty.isEmpty()) {
                        for (class_2338 pos2 : this.dirty) {
                            LinkedList list2 = new LinkedList();
                            this.regenQuadsSync(world, pos2, list2::add, lightBlockPos, lightPos);
                            for (class_2350 dir : class_2350.values()) {
                                this.regenQuadsSync(world, pos2.method_10093(dir), list2::add, lightBlockPos, lightPos);
                            }
                            if (!list2.isEmpty()) {
                                this.quads.put(pos2, list2);
                                continue;
                            }
                            this.quads.remove(pos2);
                        }
                    }
                }
                this.quads.forEach((pos, list) -> {
                    if (box.method_14662((class_2382)pos)) {
                        for (RaytracedLight.Quad quad : list) {
                            RaytracedLight.ShadowVolume volume = quad.toVolume(lightPos, this.radius);
                            volume.render((class_4588)builder);
                            volumes.add(volume);
                        }
                    }
                });
                this.upload(builder, volumes);
                class_4184 camera = class_310.method_1551().field_1773.method_19418();
                Matrix4f view = new Matrix4f().rotate((Quaternionfc)camera.method_23767().invert(new Quaternionf())).translate((float)(-camera.method_19326().field_1352), (float)(-camera.method_19326().field_1351), (float)(-camera.method_19326().field_1350));
                this.renderMask(raytrace, lightPos, camera, view);
                this.renderLight(lightPos, view);
                return true;
            }
        }
        return false;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + String.valueOf(this.entity) + "]";
    }
}

