/*
 * Decompiled with CFR 0.152.
 */
package net.typho.vibrancy;

import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.function.Consumer;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_310;
import net.minecraft.class_3341;
import net.minecraft.class_4184;
import net.minecraft.class_4588;
import net.minecraft.class_638;
import net.typho.vibrancy.AbstractRaytracedLight;
import net.typho.vibrancy.RaytracedLight;
import net.typho.vibrancy.Vibrancy;
import org.joml.Matrix4f;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;

public class RaytracedPointLight
extends AbstractRaytracedLight {
    protected final List<class_2338> dirty = new LinkedList<class_2338>();
    protected boolean remove = false;
    protected List<RaytracedLight.ShadowVolume> volumes = new LinkedList<RaytracedLight.ShadowVolume>();
    protected CompletableFuture<List<RaytracedLight.ShadowVolume>> fullRebuildTask;

    public void regenQuads(class_638 world, class_2338 pos, Consumer<RaytracedLight.ShadowVolume> out, class_2338 lightBlockPos, Vector3f lightPos) {
        this.volumes.removeIf(v -> v.caster().blockPos().equals((Object)pos));
        this.getVolumes(world, pos, out, pos.method_10262((class_2382)lightBlockPos), lightBlockPos, lightPos, this.radius, true);
    }

    @Override
    public void updateDirty(Iterable<class_2338> it) {
        class_3341 box = this.getBox();
        for (class_2338 pos : it) {
            if (!box.method_14662((class_2382)pos)) continue;
            this.dirty.add(pos);
        }
    }

    @Override
    public void init() {
    }

    @Override
    public boolean render(boolean raytrace) {
        class_638 world = class_310.method_1551().field_1687;
        if (world != null) {
            class_287 builder;
            class_2338 lightBlockPos = new class_2338((int)Math.floor(this.getPosition().x), (int)Math.floor(this.getPosition().y), (int)Math.floor(this.getPosition().z));
            Vector3f lightPos = new Vector3f((float)this.getPosition().x, (float)this.getPosition().y, (float)this.getPosition().z);
            int blockRadius = Vibrancy.capShadowDistance((int)Math.ceil(this.radius) - 2);
            class_3341 box = this.getBox();
            if (this.fullRebuildTask != null) {
                ++Vibrancy.NUM_LIGHT_TASKS;
            }
            if (!this.dirty.isEmpty()) {
                for (class_2338 class_23382 : this.dirty) {
                    if (!class_23382.equals((Object)lightBlockPos)) {
                        this.regenQuads(world, class_23382, this.volumes::add, lightBlockPos, lightPos);
                    }
                    for (class_2350 dir : class_2350.values()) {
                        class_2338 pos1 = class_23382.method_10093(dir);
                        if (pos1.equals((Object)lightBlockPos)) continue;
                        this.regenQuads(world, pos1, this.volumes::add, lightBlockPos, lightPos);
                    }
                }
                this.dirty.clear();
                builder = class_289.method_1348().method_60827(class_293.class_5596.field_27382, class_290.field_1592);
                for (RaytracedLight.ShadowVolume volume : this.volumes) {
                    volume.render((class_4588)builder);
                }
                this.upload(builder, this.volumes);
            }
            if (this.fullRebuildTask != null && this.fullRebuildTask.isDone()) {
                try {
                    this.volumes = this.fullRebuildTask.get();
                    this.fullRebuildTask = null;
                    builder = class_289.method_1348().method_60827(class_293.class_5596.field_27382, class_290.field_1592);
                    for (RaytracedLight.ShadowVolume volume : this.volumes) {
                        volume.render((class_4588)builder);
                    }
                    this.upload(builder, this.volumes);
                }
                catch (InterruptedException | ExecutionException e) {
                    throw new RuntimeException(e);
                }
            } else if (raytrace) {
                if (blockRadius < 1) {
                    raytrace = false;
                } else if (this.isDirty()) {
                    this.clean();
                    this.fullRebuildTask = CompletableFuture.supplyAsync(() -> {
                        LinkedList volumes = new LinkedList();
                        for (int x = box.method_35415(); x <= box.method_35418(); ++x) {
                            for (int y = box.method_35416(); y <= box.method_35419(); ++y) {
                                for (int z = box.method_35417(); z <= box.method_35420(); ++z) {
                                    double sqDist;
                                    class_2338 pos = new class_2338(x, y, z);
                                    if (pos.equals((Object)lightBlockPos) || (sqDist = pos.method_10262((class_2382)lightBlockPos)) == 0.0 || !(sqDist < (double)(blockRadius * blockRadius))) continue;
                                    this.getVolumes(world, pos, volumes::add, sqDist, lightBlockPos, lightPos, this.radius, true);
                                }
                            }
                        }
                        return volumes;
                    });
                }
            }
            if (this.isVisible()) {
                class_4184 camera = class_310.method_1551().field_1773.method_19418();
                Matrix4f matrix4f = new Matrix4f().rotate((Quaternionfc)camera.method_23767().invert(new Quaternionf())).translate((float)(-camera.method_19326().field_1352), (float)(-camera.method_19326().field_1351), (float)(-camera.method_19326().field_1350));
                this.renderMask(raytrace, lightPos, camera, matrix4f);
                this.renderLight(lightPos, matrix4f);
                return true;
            }
        }
        return false;
    }
}

