/*
 * Decompiled with CFR 0.152.
 */
package net.typho.vibrancy;

import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.mojang.blaze3d.systems.RenderSystem;
import foundry.veil.api.client.render.VeilRenderSystem;
import foundry.veil.api.client.render.dynamicbuffer.DynamicBufferType;
import foundry.veil.api.client.render.framebuffer.AdvancedFbo;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.Map;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientChunkEvents;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientWorldEvents;
import net.fabricmc.fabric.api.client.particle.v1.ParticleFactoryRegistry;
import net.fabricmc.fabric.api.client.rendering.v1.WorldRenderEvents;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.fabricmc.fabric.api.resource.ResourceManagerHelper;
import net.fabricmc.fabric.api.resource.ResourcePackActivationType;
import net.fabricmc.fabric.api.resource.SimpleSynchronousResourceReloadListener;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.minecraft.class_1011;
import net.minecraft.class_1294;
import net.minecraft.class_1309;
import net.minecraft.class_156;
import net.minecraft.class_1921;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2378;
import net.minecraft.class_2394;
import net.minecraft.class_2396;
import net.minecraft.class_2400;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2826;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_315;
import net.minecraft.class_3264;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_3532;
import net.minecraft.class_3937;
import net.minecraft.class_4076;
import net.minecraft.class_4588;
import net.minecraft.class_5321;
import net.minecraft.class_638;
import net.minecraft.class_6862;
import net.minecraft.class_7172;
import net.minecraft.class_742;
import net.minecraft.class_746;
import net.minecraft.class_761;
import net.minecraft.class_7919;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.typho.vibrancy.AbstractRaytracedLight;
import net.typho.vibrancy.BlockStateFunction;
import net.typho.vibrancy.DimensionLightInfo;
import net.typho.vibrancy.DynamicLightInfo;
import net.typho.vibrancy.RaytracedLight;
import net.typho.vibrancy.RaytracedPointBlockLight;
import net.typho.vibrancy.RaytracedPointEntityLight;
import org.lwjgl.opengl.GL11;

public class Vibrancy
implements ClientModInitializer {
    public static final String MOD_ID = "vibrancy";
    public static final class_2960 LOGO_TEXTURE = Vibrancy.id("textures/gui/title/vibrancy.png");
    public static final class_7172<Boolean> TRANSPARENCY_TEST = class_7172.method_41749((String)"options.vibrancy.transparency_test", value -> class_7919.method_47407((class_2561)class_2561.method_43471((String)"options.vibrancy.transparency_test.tooltip")), (boolean)true);
    public static final class_7172<Boolean> BETTER_FOG = class_7172.method_41749((String)"options.vibrancy.better_fog", value -> class_7919.method_47407((class_2561)class_2561.method_43471((String)"options.vibrancy.better_fog.tooltip")), (boolean)true);
    public static final class_7172<Boolean> ELYTRA_TRAILS = class_7172.method_41749((String)"options.vibrancy.elytra_trails", value -> class_7919.method_47407((class_2561)class_2561.method_43471((String)"options.vibrancy.elytra_trails.tooltip")), (boolean)true);
    public static final class_7172<Integer> RAYTRACE_DISTANCE = new class_7172("options.vibrancy.raytrace_distance", value -> class_7919.method_47407((class_2561)class_2561.method_43471((String)"options.vibrancy.raytrace_distance.tooltip")), (text, value) -> class_315.method_41783((class_2561)text, (class_2561)class_2561.method_43469((String)"options.vibrancy.raytrace_distance.value", (Object[])new Object[]{value * 16})), (class_7172.class_7178)new class_7172.class_7174(1, 32, false), (Object)4, value -> {});
    public static final class_7172<Integer> LIGHT_CULL_DISTANCE = new class_7172("options.vibrancy.light_cull_distance", value -> class_7919.method_47407((class_2561)class_2561.method_43471((String)"options.vibrancy.light_cull_distance.tooltip")), (text, value) -> class_315.method_41783((class_2561)text, (class_2561)class_2561.method_43469((String)"options.vibrancy.light_cull_distance.value", (Object[])new Object[]{value * 16})), (class_7172.class_7178)new class_7172.class_7174(1, 32, false), (Object)12, value -> {});
    public static final class_7172<Integer> MAX_RAYTRACED_LIGHTS = new class_7172("options.vibrancy.max_raytraced_lights", value -> class_7919.method_47407((class_2561)class_2561.method_43471((String)"options.vibrancy.max_raytraced_lights.tooltip")), (text, value) -> class_315.method_41783((class_2561)text, (class_2561)(value > 100 ? class_2561.method_43471((String)"options.vibrancy.max_raytraced_lights.max") : class_2561.method_43469((String)"options.vibrancy.max_raytraced_lights.value", (Object[])new Object[]{value}))), (class_7172.class_7178)new class_7172.class_7174(5, 105, false), (Object)30, value -> {});
    public static final class_7172<Integer> MAX_SHADOW_DISTANCE = new class_7172("options.vibrancy.max_shadow_distance", value -> class_7919.method_47407((class_2561)class_2561.method_43471((String)"options.vibrancy.max_shadow_distance.tooltip")), (text, value) -> class_315.method_41783((class_2561)text, (class_2561)(value > 15 ? class_2561.method_43471((String)"options.vibrancy.max_shadow_distance.max") : class_2561.method_43469((String)"options.vibrancy.max_shadow_distance.value", (Object[])new Object[]{value}))), (class_7172.class_7178)new class_7172.class_7174(1, 16, false), (Object)8, value -> {});
    public static final class_7172<Integer> MAX_LIGHT_RADIUS = new class_7172("options.vibrancy.max_light_radius", value -> class_7919.method_47407((class_2561)class_2561.method_43471((String)"options.vibrancy.max_light_radius.tooltip")), (text, value) -> class_315.method_41783((class_2561)text, (class_2561)(value > 15 ? class_2561.method_43471((String)"options.vibrancy.max_light_radius.max") : class_2561.method_43469((String)"options.vibrancy.max_light_radius.value", (Object[])new Object[]{value}))), (class_7172.class_7178)new class_7172.class_7174(1, 16, false), (Object)15, value -> {});
    public static final class_7172<Double> BLOCK_LIGHT_MULTIPLIER = new class_7172("options.vibrancy.block_light_multiplier", value -> class_7919.method_47407((class_2561)class_2561.method_43471((String)"options.vibrancy.block_light_multiplier.tooltip")), (text, value) -> class_315.method_41783((class_2561)text, (class_2561)class_2561.method_43469((String)"options.vibrancy.block_light_multiplier.value", (Object[])new Object[]{(int)(value * 100.0)})), (class_7172.class_7178)class_7172.class_7177.field_37875, (Object)0.5, value -> {});
    public static boolean SEEN_ALPHA_TEXT = false;
    public static final class_2400 STEAM = (class_2400)class_2378.method_10230((class_2378)class_7923.field_41180, (class_2960)Vibrancy.id("steam"), (Object)new class_2400(false){});
    public static final Map<class_5321<class_2248>, BlockStateFunction<Boolean>> EMISSIVE_OVERRIDES = new LinkedHashMap<class_5321<class_2248>, BlockStateFunction<Boolean>>();
    public static final Map<class_2338, RaytracedPointBlockLight> BLOCK_LIGHTS = new LinkedHashMap<class_2338, RaytracedPointBlockLight>();
    public static final Map<class_1309, RaytracedPointEntityLight> ENTITY_LIGHTS = new LinkedHashMap<class_1309, RaytracedPointEntityLight>();
    public static int NUM_LIGHT_TASKS = 0;
    public static int NUM_RAYTRACED_LIGHTS = 0;
    public static int NUM_VISIBLE_LIGHTS = 0;

    public static class_2960 id(String path) {
        return class_2960.method_60655((String)MOD_ID, (String)path);
    }

    public static int maxLights() {
        int v = (Integer)MAX_RAYTRACED_LIGHTS.method_41753();
        return v > 100 ? Integer.MAX_VALUE : v;
    }

    public static int capShadowDistance(int distance) {
        int v = (Integer)MAX_SHADOW_DISTANCE.method_41753();
        return v > 15 ? distance : Math.min(distance, v);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean shouldRenderLight(RaytracedLight light) {
        class_243 cam = class_310.method_1551().field_1773.method_19418().method_19326();
        if (!(light.getPosition().distanceSquared(cam.field_1352, cam.field_1351, cam.field_1350) / 16.0 < (double)((Integer)LIGHT_CULL_DISTANCE.method_41753() * (Integer)LIGHT_CULL_DISTANCE.method_41753()))) return false;
        if (!VeilRenderSystem.getCullingFrustum().testAab(light.getBoundingBox())) {
            if (!(light instanceof RaytracedPointEntityLight)) return false;
            RaytracedPointEntityLight entity = (RaytracedPointEntityLight)light;
            if (entity.entity != class_310.method_1551().field_1719) return false;
        }
        boolean bl = true;
        boolean b = bl;
        if (!b) return b;
        ++NUM_VISIBLE_LIGHTS;
        return b;
    }

    public static double getLightDistance(RaytracedLight light) {
        class_243 cam = class_310.method_1551().field_1773.method_19418().method_19326();
        return light.getPosition().distanceSquared(cam.field_1352, cam.field_1351, cam.field_1350);
    }

    public static void renderLight(RaytracedLight light, int[] cap) {
        boolean raytrace;
        boolean bl = raytrace = cap[0] < Vibrancy.maxLights();
        if (light.render(raytrace)) {
            if (raytrace) {
                ++NUM_RAYTRACED_LIGHTS;
            }
            cap[0] = cap[0] + 1;
        }
    }

    public static void renderLightDebug(RaytracedLight light, class_4588 consumer) {
        class_243 camera = class_310.method_1551().field_1773.method_19418().method_19326();
        class_761.method_35773((class_4588)consumer, (double)(light.getPosition().x - 0.3 - camera.method_10216()), (double)(light.getPosition().y - 0.3 - camera.method_10214()), (double)(light.getPosition().z - 0.3 - camera.method_10215()), (double)(light.getPosition().x + 0.3 - camera.method_10216()), (double)(light.getPosition().y + 0.3 - camera.method_10214()), (double)(light.getPosition().z + 0.3 - camera.method_10215()), (float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public static boolean pointsToward(class_2338 from, class_2350 dir, class_2338 to) {
        return switch (dir.method_10166()) {
            default -> throw new MatchException(null, null);
            case class_2350.class_2351.field_11048 -> {
                if (dir.method_10171() == class_2350.class_2352.field_11056) {
                    if (from.method_10263() <= to.method_10263()) {
                        yield true;
                    }
                    yield false;
                }
                if (from.method_10263() >= to.method_10263()) {
                    yield true;
                }
                yield false;
            }
            case class_2350.class_2351.field_11052 -> {
                if (dir.method_10171() == class_2350.class_2352.field_11056) {
                    if (from.method_10264() <= to.method_10264()) {
                        yield true;
                    }
                    yield false;
                }
                if (from.method_10264() >= to.method_10264()) {
                    yield true;
                }
                yield false;
            }
            case class_2350.class_2351.field_11051 -> {
                if (dir.method_10171() == class_2350.class_2352.field_11056) {
                    if (from.method_10260() <= to.method_10260()) {
                        yield true;
                    }
                    yield false;
                }
                yield from.method_10260() >= to.method_10260();
            }
        };
    }

    public static void elytraTrail(class_1309 entity) {
        if (Math.random() < Math.min(entity.method_18798().method_1033() - 0.75, (entity.method_23318() - 80.0) / 40.0)) {
            entity.method_37908().method_8406((class_2394)STEAM, entity.method_23317(), entity.method_23318(), entity.method_23321(), 0.0, 0.0, 0.0);
        }
    }

    public static void renderLights() {
        VeilRenderSystem.renderer().getFramebufferManager().getFramebuffer(Vibrancy.id("ray_light")).bind(true);
        RenderSystem.clearColor((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f);
        GL11.glClear((int)16384);
        BLOCK_LIGHTS.values().removeIf(light -> {
            boolean b;
            boolean bl = b = light == null || light.remove;
            if (b && light != null) {
                light.free();
            }
            return b;
        });
        int[] cap = new int[]{0};
        NUM_RAYTRACED_LIGHTS = 0;
        NUM_VISIBLE_LIGHTS = 0;
        for (RaytracedPointBlockLight raytracedPointBlockLight : BLOCK_LIGHTS.values()) {
            raytracedPointBlockLight.updateDirty(RaytracedLight.DIRTY);
            raytracedPointBlockLight.init();
        }
        for (RaytracedPointEntityLight raytracedPointEntityLight : ENTITY_LIGHTS.values()) {
            raytracedPointEntityLight.updateDirty(RaytracedLight.DIRTY);
            raytracedPointEntityLight.init();
        }
        ENTITY_LIGHTS.values().stream().sorted(Comparator.comparingDouble(Vibrancy::getLightDistance)).filter(Vibrancy::shouldRenderLight).forEachOrdered(light -> Vibrancy.renderLight(light, cap));
        BLOCK_LIGHTS.values().stream().sorted(Comparator.comparingDouble(Vibrancy::getLightDistance)).filter(Vibrancy::shouldRenderLight).forEachOrdered(light -> Vibrancy.renderLight(light, cap));
        RaytracedLight.DIRTY.clear();
    }

    public static float[] getTempTint(DimensionLightInfo dimLight, float temp) {
        float[] skyScales = new float[]{1.0f, 1.0f, 1.0f};
        if (dimLight.minTemp() == null || dimLight.maxTemp() == null) {
            return new float[]{1.0f, 1.0f, 1.0f};
        }
        if (temp > 0.8f) {
            float blend = class_3532.method_15363((float)(temp - 0.8f), (float)0.0f, (float)1.0f);
            skyScales = new float[]{class_3532.method_16439((float)blend, (float)skyScales[0], (float)dimLight.maxTemp()[0]), class_3532.method_16439((float)blend, (float)skyScales[1], (float)dimLight.maxTemp()[1]), class_3532.method_16439((float)blend, (float)skyScales[2], (float)dimLight.maxTemp()[2])};
        } else {
            float blend = class_3532.method_15363((float)(0.8f - temp), (float)0.0f, (float)1.0f);
            skyScales = new float[]{class_3532.method_16439((float)blend, (float)skyScales[0], (float)dimLight.minTemp()[0]), class_3532.method_16439((float)blend, (float)skyScales[1], (float)dimLight.minTemp()[1]), class_3532.method_16439((float)blend, (float)skyScales[2], (float)dimLight.minTemp()[2])};
        }
        if (dimLight.skyScale() == null) {
            return skyScales;
        }
        return new float[]{skyScales[0] * dimLight.skyScale()[0], skyScales[1] * dimLight.skyScale()[1], skyScales[2] * dimLight.skyScale()[2]};
    }

    public static float getDay(class_638 world, float delta) {
        return world.method_23783(delta);
    }

    public static void createLightmap(class_638 world, class_746 player, class_315 options, class_1011 image, float temp, float humid, float delta) {
        DimensionLightInfo dimLight = DimensionLightInfo.get((class_1937)world);
        float day = Vibrancy.getDay(world, delta);
        float brightness = class_3532.method_15363((float)(2.0f - ((Double)options.method_42473().method_41753()).floatValue()), (float)1.0f, (float)2.0f);
        float[] tempTint = Vibrancy.getTempTint(dimLight, temp);
        for (int sky = 0; sky < image.method_4323(); ++sky) {
            float[] fArray;
            float fSky = (float)sky / (float)(image.method_4323() - 1);
            if (player.method_6059(class_1294.field_5925)) {
                fSky = 1.0f;
                day = 1.0f;
            } else {
                fSky = (float)Math.pow(fSky, brightness);
            }
            if (dimLight.nightSky() != null) {
                float[] fArray2 = new float[3];
                fArray2[0] = fSky * fSky * class_3532.method_16439((float)day, (float)dimLight.nightSky()[0], (float)tempTint[0]);
                fArray2[1] = fSky * fSky * class_3532.method_16439((float)day, (float)dimLight.nightSky()[1], (float)tempTint[1]);
                fArray = fArray2;
                fArray2[2] = fSky * fSky * class_3532.method_16439((float)day, (float)dimLight.nightSky()[2], (float)tempTint[2]);
            } else {
                float[] fArray3 = new float[3];
                fArray3[0] = tempTint[0] * fSky * fSky;
                fArray3[1] = tempTint[1] * fSky * fSky;
                fArray = fArray3;
                fArray3[2] = tempTint[2] * fSky * fSky;
            }
            float[] skyTint = fArray;
            for (int block = 0; block < image.method_4307(); ++block) {
                float fBlock = (float)Math.pow((float)block / (float)(image.method_4307() - 1), brightness) * ((Double)BLOCK_LIGHT_MULTIPLIER.method_41753()).floatValue();
                float red = fBlock * dimLight.block()[0] + skyTint[0];
                float green = fBlock * dimLight.block()[1] + skyTint[1];
                float blue = fBlock * dimLight.block()[2] + skyTint[2];
                image.method_4305(block, sky, 0xFF000000 | (int)class_3532.method_15363((float)(blue * 255.0f), (float)0.0f, (float)255.0f) << 16 | (int)class_3532.method_15363((float)(green * 255.0f), (float)0.0f, (float)255.0f) << 8 | (int)class_3532.method_15363((float)(red * 255.0f), (float)0.0f, (float)255.0f));
            }
        }
    }

    public static void updateBlock(class_2338 pos, class_2680 oldBlock, class_2680 newBlock) {
        DynamicLightInfo info = DynamicLightInfo.get(newBlock);
        if (info != null) {
            info.addBlockLight(pos, newBlock);
        }
    }

    public void onInitializeClient() {
        ParticleFactoryRegistry.getInstance().register((class_2396)STEAM, class_3937.class_3995::new);
        WorldRenderEvents.LAST.register(context -> {
            if (class_310.method_1551().method_53526().method_53536() && FabricLoader.getInstance().isDevelopmentEnvironment()) {
                RenderSystem.disableBlend();
                RenderSystem.disableDepthTest();
                AdvancedFbo.unbind();
                ENTITY_LIGHTS.values().forEach(light -> Vibrancy.renderLightDebug(light, context.consumers().getBuffer(class_1921.method_23594())));
                BLOCK_LIGHTS.values().forEach(light -> Vibrancy.renderLightDebug(light, context.consumers().getBuffer(class_1921.method_23594())));
            }
            NUM_LIGHT_TASKS = 0;
            class_2960 id = Vibrancy.id("ray_light");
            VeilRenderSystem.renderer().enableBuffers(id, new DynamicBufferType[]{DynamicBufferType.NORMAL, DynamicBufferType.ALBEDO});
            Vibrancy.renderLights();
        });
        ClientChunkEvents.CHUNK_LOAD.register((world, chunk) -> {
            for (int i = chunk.method_32891(); i < chunk.method_31597(); ++i) {
                class_2826 section = chunk.method_38259(chunk.method_31603(i));
                if (!section.method_19523(state -> DynamicLightInfo.MAP.keySet().stream().anyMatch(p -> p.test(state)))) continue;
                class_2338 minPos = class_4076.method_18681((class_1923)chunk.method_12004(), (int)i).method_19767();
                for (int x = 0; x < 16; ++x) {
                    for (int y = 0; y < 16; ++y) {
                        for (int z = 0; z < 16; ++z) {
                            class_2680 state2 = section.method_12254(x, y, z);
                            DynamicLightInfo info = DynamicLightInfo.get(state2);
                            if (info == null) continue;
                            info.addBlockLight(new class_2338(x + minPos.method_10263(), y + minPos.method_10264(), z + minPos.method_10260()), state2);
                        }
                    }
                }
            }
        });
        ClientChunkEvents.CHUNK_UNLOAD.register((world, chunk) -> {
            BLOCK_LIGHTS.values().removeIf(light -> {
                boolean b = new class_1923(light.blockPos).equals((Object)chunk.method_12004());
                if (b) {
                    light.free();
                }
                return b;
            });
            ENTITY_LIGHTS.values().removeIf(light -> {
                boolean b = light.entity.method_31476().equals((Object)chunk.method_12004());
                if (b) {
                    light.free();
                }
                return b;
            });
        });
        ClientWorldEvents.AFTER_CLIENT_WORLD_CHANGE.register((client, world) -> {
            BLOCK_LIGHTS.values().forEach(AbstractRaytracedLight::free);
            BLOCK_LIGHTS.clear();
            ENTITY_LIGHTS.values().forEach(AbstractRaytracedLight::free);
            ENTITY_LIGHTS.clear();
            for (class_742 player : world.method_18456()) {
                System.out.println(player);
                ENTITY_LIGHTS.put((class_1309)player, new RaytracedPointEntityLight((class_1309)player));
            }
        });
        ResourceManagerHelper.get((class_3264)class_3264.field_14188).registerReloadListener((IdentifiableResourceReloadListener)new SimpleSynchronousResourceReloadListener(this){

            public class_2960 getFabricId() {
                return Vibrancy.id("dynamic_lights");
            }

            public void method_14491(class_3300 manager) {
                BufferedReader reader;
                DynamicLightInfo.MAP.clear();
                for (class_3298 resource : manager.method_14489(Vibrancy.id("dynamic_lights.json"))) {
                    try {
                        reader = resource.method_43039();
                        try {
                            JsonParser.parseReader((Reader)reader).getAsJsonObject().asMap().forEach((key, value) -> {
                                if (key.startsWith("#")) {
                                    class_6862 tagKey = class_6862.method_40092((class_5321)class_7924.field_41254, (class_2960)class_2960.method_60654((String)key.substring(1)));
                                    DynamicLightInfo.MAP.put(state -> state.method_26164(tagKey), class_156.method_34866(state -> new DynamicLightInfo.Builder().load((class_2248)state.method_41520().comp_349(), (JsonElement)value).build()));
                                } else {
                                    class_5321 regKey = class_5321.method_29179((class_5321)class_7924.field_41254, (class_2960)class_2960.method_60654((String)key));
                                    DynamicLightInfo info = new DynamicLightInfo.Builder().load((class_2248)class_7923.field_41175.method_29107(regKey), (JsonElement)value).build();
                                    DynamicLightInfo.MAP.put(state -> state.method_54097(regKey), state -> info);
                                }
                            });
                        }
                        finally {
                            if (reader == null) continue;
                            reader.close();
                        }
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
                EMISSIVE_OVERRIDES.clear();
                for (class_3298 resource : manager.method_14489(Vibrancy.id("emissive_blocks.json"))) {
                    try {
                        reader = resource.method_43039();
                        try {
                            JsonParser.parseReader((Reader)reader).getAsJsonObject().asMap().forEach((key, value) -> {
                                class_5321 regKey = class_5321.method_29179((class_5321)class_7924.field_41254, (class_2960)class_2960.method_60654((String)key));
                                EMISSIVE_OVERRIDES.put((class_5321<class_2248>)regKey, BlockStateFunction.parseJson((class_2248)class_7923.field_41175.method_29107(regKey), value, JsonElement::getAsBoolean, () -> false));
                            });
                        }
                        finally {
                            if (reader == null) continue;
                            reader.close();
                        }
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
            }
        });
        ModContainer mod = (ModContainer)FabricLoader.getInstance().getModContainer(MOD_ID).orElseThrow();
        ResourceManagerHelper.registerBuiltinResourcePack((class_2960)Vibrancy.id("vibrant_textures"), (ModContainer)mod, (class_2561)class_2561.method_43471((String)"pack.name.vibrancy.textures"), (ResourcePackActivationType)ResourcePackActivationType.NORMAL);
        ResourceManagerHelper.registerBuiltinResourcePack((class_2960)Vibrancy.id("ripple"), (ModContainer)mod, (class_2561)class_2561.method_43471((String)"pack.name.vibrancy.ripple"), (ResourcePackActivationType)ResourcePackActivationType.DEFAULT_ENABLED);
    }
}

