package net.typho.vibrancy;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.class_2248;
import net.minecraft.class_2680;
import net.minecraft.class_3545;
import net.minecraft.class_9824;

public interface BlockStateFunction<T> {
    T apply(class_2680 state);

    static <T> BlockStateFunction<T> parse(class_2248 block, String key, Supplier<T> success, Supplier<T> fail) {
        Predicate<class_2680> predicate = class_9824.method_61057(block.method_9595(), key);
        return state -> {
            if (predicate.test(state)) {
                return success.get();
            } else {
                return fail.get();
            }
        };
    }

    static <T> BlockStateFunction<T> parse(Map<Predicate<class_2680>, Supplier<T>> map, Supplier<T> def) {
        return state -> map.entrySet().stream()
                .filter(entry -> entry.getKey().test(state))
                .map(Map.Entry::getValue)
                .findAny()
                .orElse(def)
                .get();
    }

    static <T> BlockStateFunction<T> parseJson(class_2248 block, JsonElement json, Function<JsonElement, T> toT, Supplier<T> def) {
        if (json.isJsonObject()) {
            JsonObject obj = json.getAsJsonObject();
            JsonElement defElement = obj.get("default");

            if (defElement != null) {
                T t = toT.apply(defElement);
                def = () -> t;
            }

            return parse(
                    obj.asMap().entrySet().stream()
                            .filter(entry -> !entry.getKey().equals("default"))
                            .map(entry -> {
                                T value = toT.apply(entry.getValue());
                                return new class_3545<Predicate<class_2680>, Supplier<T>>(class_9824.method_61057(block.method_9595(), entry.getKey()), () -> value);
                            })
                            .collect(
                                    LinkedHashMap::new,
                                    (map, value) -> map.put(value.method_15442(), value.method_15441()),
                                    HashMap::putAll
                            ),
                    def
            );
        } else {
            T t = toT.apply(json);
            return state -> t;
        }
    }
}
