package net.typho.vibrancy;

import foundry.veil.api.client.render.light.Light;
import org.lwjgl.system.NativeResource;

import java.util.Collection;
import java.util.Comparator;
import net.minecraft.class_310;

public abstract class RaytracedLightRenderer<T extends Light & RaytracedLight> implements NativeResource {
    public void render() {
        Vibrancy.blitViewPos();
        int[] cap = {0};

        getLights().stream()
                .sorted(Comparator.comparingDouble(light -> light.lazyDistance(class_310.method_1551().field_1773.method_19418().method_19326())))
                .forEachOrdered(light -> light.render(cap[0]++ < Vibrancy.maxLights()));
    }

    public abstract Collection<? extends T> getLights();
}
