package net.typho.vibrancy;

import com.mojang.blaze3d.systems.RenderSystem;
import foundry.veil.api.client.render.VeilRenderSystem;
import foundry.veil.api.client.render.framebuffer.VeilFramebuffers;
import foundry.veil.api.client.render.light.PointLight;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1921;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_291;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3341;
import net.minecraft.class_3532;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4696;
import net.minecraft.class_5819;
import net.minecraft.class_5944;
import net.minecraft.class_638;
import net.minecraft.client.render.*;
import org.joml.Matrix4f;
import org.joml.Quaternionf;
import org.joml.Vector2f;
import org.joml.Vector3f;
import org.lwjgl.glfw.GLFW;
import org.lwjgl.system.MemoryUtil;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.nio.ByteBuffer;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;

import static org.lwjgl.opengl.GL11.*;
import static org.lwjgl.opengl.GL15.*;
import static org.lwjgl.opengl.GL30.glBindBufferBase;
import static org.lwjgl.opengl.GL43.GL_SHADER_STORAGE_BUFFER;

public class RaytracedPointLight extends PointLight implements RaytracedLight {
    public static final class_291 SCREEN_VBO = new class_291(class_291.class_8555.field_44793);
    protected final class_291 geomVBO = new class_291(class_291.class_8555.field_44794);
    protected final int quadsSSBO = glGenBuffers();
    protected boolean remove = false, anyShadows = false;
    protected float flicker = 0, flickerMin, flickerMax, flickerStart = (float) GLFW.glfwGetTime();

    static {
        class_287 bufferBuilder = RenderSystem.renderThreadTesselator().method_60827(class_293.class_5596.field_27380, class_290.field_1592);
        bufferBuilder.method_22912(-1, 1, 0);
        bufferBuilder.method_22912(-1, -1, 0);
        bufferBuilder.method_22912(1, 1, 0);
        bufferBuilder.method_22912(1, -1, 0);

        SCREEN_VBO.method_1353();
        SCREEN_VBO.method_1352(bufferBuilder.method_60800());
        class_291.method_1354();
    }

    public float getFlicker() {
        return flicker;
    }

    public RaytracedPointLight setFlicker(float flicker) {
        this.flicker = flicker;
        markDirty();
        return this;
    }

    @Override
    public double lazyDistance(class_243 vec) {
        return getPosition().distanceSquared(vec.field_1352, vec.field_1351, vec.field_1350);
    }

    @Override
    public void render(boolean raytrace) {
        class_2338 lightBlockPos = new class_2338((int) Math.floor(getPosition().x), (int) Math.floor(getPosition().y), (int) Math.floor(getPosition().z));

        if (isDirty() && raytrace) {
            clean();

            class_638 world = class_310.method_1551().field_1687;

            if (world != null) {
                int numQuads = 0;
                Vector3f lightPos = new Vector3f((float) getPosition().x, (float) getPosition().y, (float) getPosition().z);
                int blockRadius = (int) Math.ceil(radius) - 4;

                if (blockRadius < 1) {
                    raytrace = false;
                } else {
                    class_3341 box = new class_3341(lightBlockPos).method_35410(blockRadius);
                    class_4587 stack = new class_4587();
                    class_287 builder = class_289.method_1348().method_60827(class_293.class_5596.field_27382, class_290.field_1592);
                    List<Quad> quads = new LinkedList<>();
                    PrintWriter out;

                    try {
                        out = FabricLoader.getInstance().isDevelopmentEnvironment() && new File("mesh.obj").exists() ? null : new PrintWriter("mesh.obj");
                    } catch (FileNotFoundException e) {
                        throw new RuntimeException(e);
                    }

                    for (int x = box.method_35415(); x <= box.method_35418(); x++) {
                        for (int y = box.method_35416(); y <= box.method_35419(); y++) {
                            for (int z = box.method_35417(); z <= box.method_35420(); z++) {
                                class_2338 pos = new class_2338(x, y, z);
                                double sqDist = pos.method_10262(lightBlockPos);

                                if (sqDist != 0 && sqDist < blockRadius * blockRadius) {
                                    class_2680 state = world.method_8320(pos);

                                    stack.method_22903();
                                    stack.method_46416(pos.method_10263(), pos.method_10264(), pos.method_10260());

                                    List<Vector3f> flatVertices = new LinkedList<>(), normals = new LinkedList<>();
                                    List<Vector2f> flatTexCoords = new LinkedList<>();

                                    class_1921 layer = class_4696.method_23679(state);

                                    class_310.method_1551().method_1541().method_3355(
                                            state,
                                            pos,
                                            world,
                                            stack,
                                            new class_4588() {
                                                @Override
                                                public class_4588 method_22912(float x, float y, float z) {
                                                    flatVertices.add(new Vector3f(x, y, z));
                                                    return this;
                                                }

                                                @Override
                                                public class_4588 method_1336(int red, int green, int blue, int alpha) {
                                                    return this;
                                                }

                                                @Override
                                                public class_4588 method_22913(float u, float v) {
                                                    flatTexCoords.add(new Vector2f(u, v));
                                                    return this;
                                                }

                                                @Override
                                                public class_4588 method_60796(int u, int v) {
                                                    return this;
                                                }

                                                @Override
                                                public class_4588 method_22921(int u, int v) {
                                                    return this;
                                                }

                                                @Override
                                                public class_4588 method_22914(float x, float y, float z) {
                                                    normals.add(new Vector3f(x, y, z));
                                                    return this;
                                                }
                                            },
                                            sqDist != 1,
                                            class_5819.method_43049(lightBlockPos.hashCode())
                                    );

                                    if (flatVertices.size() % 4 != 0) {
                                        System.err.println("[Vibrancy] Block " + state + " doesn't use quads for rendering, skipping it for raytracing");
                                    } else {
                                        for (int j = 0; j < flatVertices.size(); j += 4) {
                                            for (int k = j; k < j + 4; k++) {
                                                if (normals.get(k).dot(lightPos.sub(flatVertices.get(k), new Vector3f())) > 0 || flatVertices.get(k).distanceSquared(lightPos) < 4) {

                                                    Vector3f[] vertices = new Vector3f[]{
                                                            flatVertices.get(j),
                                                            flatVertices.get(j + 1),
                                                            flatVertices.get(j + 2),
                                                            flatVertices.get(j + 3),
                                                            null,
                                                            null,
                                                            null,
                                                            null
                                                    };

                                                    for (int i = 0; i < 4; i++) {
                                                        Vector3f vertex = new Vector3f(vertices[i]);
                                                        Vector3f off = vertex.sub(lightPos, new Vector3f());
                                                        vertices[i + 4] = vertex.add(off.normalize((radius) - off.length() + 1));
                                                    }

                                                    quads.add(new Quad(vertices[0], vertices[1], vertices[2], vertices[3], flatTexCoords.get(j), flatTexCoords.get(j + 1), flatTexCoords.get(j + 2), flatTexCoords.get(j + 3), layer.method_60894() || layer != class_1921.method_23577()));

                                                    builder.method_60830(vertices[0])
                                                            .method_60830(vertices[1])
                                                            .method_60830(vertices[2])
                                                            .method_60830(vertices[3]);

                                                    builder.method_60830(vertices[1])
                                                            .method_60830(vertices[5])
                                                            .method_60830(vertices[6])
                                                            .method_60830(vertices[2]);

                                                    builder.method_60830(vertices[5])
                                                            .method_60830(vertices[4])
                                                            .method_60830(vertices[7])
                                                            .method_60830(vertices[6]);

                                                    builder.method_60830(vertices[4])
                                                            .method_60830(vertices[0])
                                                            .method_60830(vertices[3])
                                                            .method_60830(vertices[7]);

                                                    builder.method_60830(vertices[1])
                                                            .method_60830(vertices[0])
                                                            .method_60830(vertices[4])
                                                            .method_60830(vertices[5]);

                                                    builder.method_60830(vertices[3])
                                                            .method_60830(vertices[2])
                                                            .method_60830(vertices[6])
                                                            .method_60830(vertices[7]);

                                                    if (out != null) {
                                                        int i = numQuads * 4 + 1;

                                                        out.println("v " + vertices[0].x + " " + vertices[0].y + " " + vertices[0].z);
                                                        out.println("v " + vertices[1].x + " " + vertices[1].y + " " + vertices[1].z);
                                                        out.println("v " + vertices[2].x + " " + vertices[2].y + " " + vertices[2].z);
                                                        out.println("v " + vertices[3].x + " " + vertices[3].y + " " + vertices[3].z);
                                                        out.println("v " + vertices[1].x + " " + vertices[1].y + " " + vertices[1].z);
                                                        out.println("v " + vertices[5].x + " " + vertices[5].y + " " + vertices[5].z);
                                                        out.println("v " + vertices[6].x + " " + vertices[6].y + " " + vertices[6].z);
                                                        out.println("v " + vertices[2].x + " " + vertices[2].y + " " + vertices[2].z);
                                                        out.println("v " + vertices[5].x + " " + vertices[5].y + " " + vertices[5].z);
                                                        out.println("v " + vertices[4].x + " " + vertices[4].y + " " + vertices[4].z);
                                                        out.println("v " + vertices[7].x + " " + vertices[7].y + " " + vertices[7].z);
                                                        out.println("v " + vertices[6].x + " " + vertices[6].y + " " + vertices[6].z);
                                                        out.println("v " + vertices[4].x + " " + vertices[4].y + " " + vertices[4].z);
                                                        out.println("v " + vertices[0].x + " " + vertices[0].y + " " + vertices[0].z);
                                                        out.println("v " + vertices[3].x + " " + vertices[3].y + " " + vertices[3].z);
                                                        out.println("v " + vertices[7].x + " " + vertices[7].y + " " + vertices[7].z);
                                                        out.println("v " + vertices[1].x + " " + vertices[1].y + " " + vertices[1].z);
                                                        out.println("v " + vertices[0].x + " " + vertices[0].y + " " + vertices[0].z);
                                                        out.println("v " + vertices[4].x + " " + vertices[4].y + " " + vertices[4].z);
                                                        out.println("v " + vertices[5].x + " " + vertices[5].y + " " + vertices[5].z);
                                                        out.println("v " + vertices[3].x + " " + vertices[3].y + " " + vertices[3].z);
                                                        out.println("v " + vertices[2].x + " " + vertices[2].y + " " + vertices[2].z);
                                                        out.println("v " + vertices[6].x + " " + vertices[6].y + " " + vertices[6].z);
                                                        out.println("v " + vertices[7].x + " " + vertices[7].y + " " + vertices[7].z);

                                                        out.println("f " + i++ + " " + i++ + " " + i++ + " " + i++);
                                                        out.println("f " + i++ + " " + i++ + " " + i++ + " " + i++);
                                                        out.println("f " + i++ + " " + i++ + " " + i++ + " " + i++);
                                                        out.println("f " + i++ + " " + i++ + " " + i++ + " " + i++);
                                                        out.println("f " + i++ + " " + i++ + " " + i++ + " " + i++);
                                                        out.println("f " + i++ + " " + i++ + " " + i++ + " " + i++);
                                                    }

                                                    numQuads += 6;

                                                    break;
                                                }
                                            }
                                        }
                                    }

                                    stack.method_22909();
                                }
                            }
                        }
                    }

                    if (numQuads == 0) {
                        anyShadows = false;
                    } else {
                        anyShadows = true;
                        geomVBO.method_1353();
                        geomVBO.method_1352(builder.method_60800());
                        class_291.method_1354();

                        ByteBuffer buf = MemoryUtil.memAlloc(quads.size() * Quad.BYTES);

                        for (Quad quad : quads) {
                            quad.put(buf);
                        }

                        glBindBuffer(GL_SHADER_STORAGE_BUFFER, quadsSSBO);
                        glBufferData(GL_SHADER_STORAGE_BUFFER, buf.flip(), GL_DYNAMIC_DRAW);
                        glBindBuffer(GL_SHADER_STORAGE_BUFFER, 0);

                        MemoryUtil.memFree(buf);
                    }
                }
            }
        }

        if (isVisible()) {
            class_4184 camera = class_310.method_1551().field_1773.method_19418();
            Matrix4f view = new Matrix4f()
                    .rotate(camera.method_23767().invert(new Quaternionf()))
                    .translate((float) -camera.method_19326().field_1352, (float) -camera.method_19326().field_1351, (float) -camera.method_19326().field_1350);
            class_5944 shader;

            if (anyShadows && raytrace) {
                VeilRenderSystem.setShader(class_2960.method_60655(Vibrancy.MOD_ID, "light/ray/mask"));
                shader = Objects.requireNonNull(RenderSystem.getShader());

                shader.method_35785("LightPos").method_1249((float) position.x, (float) position.y, (float) position.z);
                shader.method_35785("Detailed").method_35649(position.distanceSquared(camera.method_19326().field_1352, camera.method_19326().field_1351, camera.method_19326().field_1350) < class_3532.method_34954(Vibrancy.RAYTRACE_DISTANCE.method_41753() * 16) ? 1 : 0);

                RenderSystem.depthMask(true);
                RenderSystem.enableDepthTest();
                RenderSystem.disableBlend();

                glBindBufferBase(GL_SHADER_STORAGE_BUFFER, 0, quadsSSBO);

                glCullFace(GL_FRONT);
                glDepthFunc(GL_GEQUAL);
                renderMask(class_2960.method_60655(Vibrancy.MOD_ID, "shadow_mask_back"), view, 0);

                glCullFace(GL_BACK);
                glDepthFunc(GL_LEQUAL);
                renderMask(class_2960.method_60655(Vibrancy.MOD_ID, "shadow_mask_front"), view, 1);

                RenderSystem.depthMask(false);
                RenderSystem.enableBlend();
                glBindBufferBase(GL_SHADER_STORAGE_BUFFER, 0, 0);
            }

            Objects.requireNonNull(VeilRenderSystem.renderer().getFramebufferManager().getFramebuffer(VeilFramebuffers.LIGHT)).bind(true);
            VeilRenderSystem.setShader(class_2960.method_60655(Vibrancy.MOD_ID, "light/ray/point"));
            shader = Objects.requireNonNull(RenderSystem.getShader());

            float time = (float) GLFW.glfwGetTime();

            while (time - flickerStart > 0.25) {
                flickerStart += 0.25f;
                flickerMin = flickerMax;
                flickerMax = new java.util.Random().nextFloat(-1, 1);
            }

            float brightness = getBrightness() * (1 + flicker * class_3532.method_16439((time - flickerStart) * 4, flickerMin, flickerMax));

            shader.method_35785("LightPos").method_1249((float) position.x, (float) position.y, (float) position.z);
            shader.method_35785("LightColor").method_1249(color.x * brightness, color.y * brightness, color.z * brightness);
            shader.method_35785("LightRadius").method_1251(radius);
            shader.method_35785("AnyShadows").method_35649(anyShadows ? 1 : 0);

            SCREEN_VBO.method_1353();
            SCREEN_VBO.method_34427(view, RenderSystem.getProjectionMatrix(), shader);
            class_291.method_1354();
        }
    }

    protected void renderMask(class_2960 fbo, Matrix4f view, double depthClear) {
        Objects.requireNonNull(VeilRenderSystem.renderer().getFramebufferManager().getFramebuffer(fbo)).bind(true);
        glClearColor(0f, 0f, 0f, 0f);
        glClearDepth(depthClear);
        glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);

        geomVBO.method_1353();
        geomVBO.method_34427(view, RenderSystem.getProjectionMatrix(), RenderSystem.getShader());
        class_291.method_1354();
    }

    @Override
    public void free() {
        geomVBO.close();
        glDeleteBuffers(quadsSSBO);
    }
}
