package net.typho.vibrancy;

import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.mojang.blaze3d.systems.RenderSystem;
import foundry.veil.api.client.render.VeilRenderSystem;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientWorldEvents;
import net.fabricmc.fabric.api.client.keybinding.v1.KeyBindingHelper;
import net.fabricmc.fabric.api.resource.ResourceManagerHelper;
import net.fabricmc.fabric.api.resource.ResourcePackActivationType;
import net.fabricmc.fabric.api.resource.SimpleSynchronousResourceReloadListener;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1011;
import net.minecraft.class_1294;
import net.minecraft.class_156;
import net.minecraft.class_2248;
import net.minecraft.class_2561;
import net.minecraft.class_291;
import net.minecraft.class_2960;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_315;
import net.minecraft.class_3264;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_3532;
import net.minecraft.class_4184;
import net.minecraft.class_5321;
import net.minecraft.class_638;
import net.minecraft.class_6862;
import net.minecraft.class_7172;
import net.minecraft.class_746;
import net.minecraft.class_7919;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import org.joml.Matrix4f;
import org.joml.Quaternionf;
import org.lwjgl.glfw.GLFW;

import java.io.BufferedReader;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;

public class Vibrancy implements ClientModInitializer {
    public static final String MOD_ID = "vibrancy";

    public static final class_2960 LOGO_TEXTURE = class_2960.method_60655(MOD_ID, "textures/gui/title/vibrancy.png");
    public static final class_7172<Boolean> DYNAMIC_LIGHTMAP = class_7172.method_42402("options.vibrancy.dynamic_lightmap", true);
    public static final class_7172<Integer> RAYTRACE_DISTANCE = new class_7172<>(
            "options.vibrancy.raytrace_distance",
            value -> class_7919.method_47407(class_2561.method_43471("options.vibrancy.raytrace_distance.tooltip")),
            (text, value) -> class_315.method_41783(text, class_2561.method_43469("options.chunks", value)),
            new class_7172.class_7174(1, 16, false),
            4,
            value -> {}
    );
    public static final class_7172<Integer> LIGHT_CULL_DISTANCE = new class_7172<>(
            "options.vibrancy.light_cull_distance",
            value -> class_7919.method_47407(class_2561.method_43471("options.vibrancy.light_cull_distance.tooltip")),
            (text, value) -> class_315.method_41783(text, class_2561.method_43469("options.chunks", value)),
            new class_7172.class_7174(1, 16, false),
            8,
            value -> {}
    );
    public static final class_7172<Integer> MAX_RAYTRACED_LIGHTS = new class_7172<>(
            "options.vibrancy.max_raytraced_lights",
            value -> class_7919.method_47407(class_2561.method_43471("options.vibrancy.max_raytraced_lights.tooltip")),
            (text, value) -> class_315.method_41783(text, value > 100 ? class_2561.method_43471("options.vibrancy.max_raytraced_lights.max") : class_2561.method_43469("options.vibrancy.max_raytraced_lights.value", value)),
            new class_7172.class_7174(5, 105, false),
            50,
            value -> {}
    );
    public static boolean SEEN_ALPHA_TEXT = false;
    public static final class_304 SAVE_LIGHTMAP = !FabricLoader.getInstance().isDevelopmentEnvironment() ? null : KeyBindingHelper.registerKeyBinding(new class_304(
            "key.vibrancy.debug.save_lightmap",
            GLFW.GLFW_KEY_F9,
            "key.categories.misc"
    ));
    public static final Map<class_5321<class_2248>, BlockStateFunction<Boolean>> EMISSIVE_OVERRIDES = new LinkedHashMap<>();

    public static int maxLights() {
        int v = MAX_RAYTRACED_LIGHTS.method_41753();
        return v > 100 ? Integer.MAX_VALUE : v;
    }

    @Override
    public void onInitializeClient() {
        ClientWorldEvents.AFTER_CLIENT_WORLD_CHANGE.register((client, world) -> RaytracedPointBlockLightRenderer.INSTANCE.lights.clear());
        ResourceManagerHelper.get(class_3264.field_14188).registerReloadListener(new SimpleSynchronousResourceReloadListener() {
            @Override
            public class_2960 getFabricId() {
                return class_2960.method_60655(Vibrancy.MOD_ID, "dynamic_lights");
            }

            @Override
            public void method_14491(class_3300 manager) {
                DynamicLightInfo.MAP.clear();

                for (class_3298 resource : manager.method_14489(class_2960.method_60655(Vibrancy.MOD_ID, "dynamic_lights.json"))) {
                    try (BufferedReader reader = resource.method_43039()) {
                        JsonParser.parseReader(reader).getAsJsonObject().asMap().forEach((key, value) -> {
                            if (key.startsWith("#")) {
                                class_6862<class_2248> tagKey = class_6862.method_40092(class_7924.field_41254, class_2960.method_60654(key.substring(1)));
                                DynamicLightInfo.MAP.put(state -> state.method_26164(tagKey), class_156.method_34866(state -> new DynamicLightInfo.Builder().load(state.method_41520().comp_349(), value).build()));
                            } else {
                                class_5321<class_2248> regKey = class_5321.method_29179(class_7924.field_41254, class_2960.method_60654(key));
                                DynamicLightInfo info = new DynamicLightInfo.Builder().load(class_7923.field_41175.method_29107(regKey), value).build();
                                DynamicLightInfo.MAP.put(state -> state.method_54097(regKey), state -> info);
                            }
                        });
                    } catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }

                EMISSIVE_OVERRIDES.clear();

                for (class_3298 resource : manager.method_14489(class_2960.method_60655(Vibrancy.MOD_ID, "emissive_blocks.json"))) {
                    try (BufferedReader reader = resource.method_43039()) {
                        JsonParser.parseReader(reader).getAsJsonObject().asMap().forEach((key, value) -> {
                            class_5321<class_2248> regKey = class_5321.method_29179(class_7924.field_41254, class_2960.method_60654(key));
                            EMISSIVE_OVERRIDES.put(regKey, BlockStateFunction.parseJson(class_7923.field_41175.method_29107(regKey), value, JsonElement::getAsBoolean, () -> false));
                        });
                    } catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
            }
        });
        ResourceManagerHelper.registerBuiltinResourcePack(class_2960.method_60655(Vibrancy.MOD_ID, "vibrant_textures"), FabricLoader.getInstance().getModContainer(Vibrancy.MOD_ID).orElseThrow(), class_2561.method_43471("pack.name.vibrancy.textures"), ResourcePackActivationType.NORMAL);
        ResourceManagerHelper.registerBuiltinResourcePack(class_2960.method_60655(Vibrancy.MOD_ID, "ripple"), FabricLoader.getInstance().getModContainer(Vibrancy.MOD_ID).orElseThrow(), class_2561.method_43471("pack.name.vibrancy.ripple"), ResourcePackActivationType.DEFAULT_ENABLED);
        ResourceManagerHelper.registerBuiltinResourcePack(class_2960.method_60655(Vibrancy.MOD_ID, "bare_bones"), FabricLoader.getInstance().getModContainer(Vibrancy.MOD_ID).orElseThrow(), class_2561.method_43471("pack.name.vibrancy.bare_bones"), ResourcePackActivationType.DEFAULT_ENABLED);
    }

    public static void blitViewPos() {
        RenderSystem.disableDepthTest();

        class_4184 camera = class_310.method_1551().field_1773.method_19418();
        Matrix4f view = new Matrix4f()
                .rotate(camera.method_23767().invert(new Quaternionf()))
                .translate((float) -camera.method_19326().field_1352, (float) -camera.method_19326().field_1351, (float) -camera.method_19326().field_1350);

        VeilRenderSystem.setShader(class_2960.method_60655(Vibrancy.MOD_ID, "view_pos"));
        Objects.requireNonNull(VeilRenderSystem.renderer().getFramebufferManager().getFramebuffer(class_2960.method_60655(MOD_ID, "view_pos"))).bind(true);

        RaytracedPointLight.SCREEN_VBO.method_1353();
        RaytracedPointLight.SCREEN_VBO.method_34427(view, RenderSystem.getProjectionMatrix(), RenderSystem.getShader());
        class_291.method_1354();
    }

    public static float[] getTempTint(DimensionLightInfo dimLight, float temp) {
        float[] skyScales = new float[]{1, 1, 1};

        if (dimLight.minTemp() == null || dimLight.maxTemp() == null) {
            return new float[]{1, 1, 1};
        } else {
            if (temp > 0.8f) {
                float blend = class_3532.method_15363(temp - 0.8f, 0, 1);
                skyScales = new float[]{
                        class_3532.method_16439(blend, skyScales[0], dimLight.maxTemp()[0]),
                        class_3532.method_16439(blend, skyScales[1], dimLight.maxTemp()[1]),
                        class_3532.method_16439(blend, skyScales[2], dimLight.maxTemp()[2])
                };
            } else {
                float blend = class_3532.method_15363(0.8f - temp, 0, 1);
                skyScales = new float[]{
                        class_3532.method_16439(blend, skyScales[0], dimLight.minTemp()[0]),
                        class_3532.method_16439(blend, skyScales[1], dimLight.minTemp()[1]),
                        class_3532.method_16439(blend, skyScales[2], dimLight.minTemp()[2])
                };
            }
        }

        if (dimLight.skyScale() == null) {
            return skyScales;
        } else {
            return new float[]{
                    skyScales[0] * dimLight.skyScale()[0],
                    skyScales[1] * dimLight.skyScale()[1],
                    skyScales[2] * dimLight.skyScale()[2]
            };
        }
    }

    public static float getDay(class_638 world, float delta) {
        return world.method_23783(delta);
    }

    public static void createLightmap(class_638 world, class_746 player, class_315 options, class_1011 image, float temp, float humid, float delta) {
        DimensionLightInfo dimLight = DimensionLightInfo.get(world);
        float day = getDay(world, delta);
        float brightness = class_3532.method_15363(2 - options.method_42473().method_41753().floatValue(), 1, 2);
        float[] tempTint = getTempTint(dimLight, temp);

        for (int sky = 0; sky < image.method_4323(); sky++) {
            float fSky = (float) sky / (image.method_4323() - 1);

            if (player.method_6059(class_1294.field_5925)) {
                fSky = 1;
                day = 1;
            } else {
                fSky = (float) Math.pow(fSky, brightness);
            }

            float[] skyTint = dimLight.hasDay() && dimLight.nightSky() != null ? new float[]{
                    fSky * fSky * class_3532.method_16439(day, dimLight.nightSky()[0], tempTint[0]),
                    fSky * fSky * class_3532.method_16439(day, dimLight.nightSky()[1], tempTint[1]),
                    fSky * fSky * class_3532.method_16439(day, dimLight.nightSky()[2], tempTint[2])
            } : tempTint;

            for (int block = 0; block < image.method_4307(); block++) {
                float fBlock = (float) Math.pow((float) block / (image.method_4307() - 1), brightness);

                float red = fBlock * dimLight.block()[0] + skyTint[0];
                float green = fBlock * dimLight.block()[1] + skyTint[1];
                float blue = fBlock * dimLight.block()[2] + skyTint[2];

                image.method_4305(block, sky, 0xFF000000 | ((int) class_3532.method_15363(blue * 255, 0, 255) << 16) | ((int) class_3532.method_15363(green * 255, 0, 255) << 8) | (int) class_3532.method_15363(red * 255, 0, 255));
            }
        }
    }
}
