package net.typho.vibrancy.mixin;

import com.llamalad7.mixinextras.injector.wrapmethod.WrapMethod;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import net.minecraft.class_1011;
import net.minecraft.class_1043;
import net.minecraft.class_1959;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_765;
import net.typho.vibrancy.Vibrancy;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;

import java.io.File;
import java.io.IOException;

@Mixin(class_765.class)
public class LightmapTextureManagerMixin {
    @Shadow
    @Final
    private class_1011 image;

    @Shadow
    private boolean dirty;

    @Shadow
    @Final
    private class_310 client;

    @Shadow
    @Final
    private class_1043 texture;

    @Unique
    private float temp, humid;

    @WrapMethod(
            method = "update"
    )
    private void update(float delta, Operation<Void> original) {
        if (Vibrancy.DYNAMIC_LIGHTMAP.method_41753()) {
            if (client.field_1687 != null && client.field_1724 != null) {
                class_1959 biome = client.field_1687.method_23753(client.field_1724.method_24515()).comp_349();

                temp = class_3532.method_16439(delta / 50, temp, biome.method_8712());
                humid = class_3532.method_16439(delta / 50, humid, biome.field_26393.comp_846());

                if (dirty) {
                    dirty = false;

                    client.method_16011().method_15396("lightTex");

                    Vibrancy.createLightmap(client.field_1687, client.field_1724, client.field_1690, image, temp, humid, delta);

                    texture.method_4524();
                    client.method_16011().method_15407();

                    if (Vibrancy.SAVE_LIGHTMAP != null && Vibrancy.SAVE_LIGHTMAP.method_1434()) {
                        try (class_1011 big = new class_1011(1024, 1024, false)) {
                            Vibrancy.createLightmap(client.field_1687, client.field_1724, client.field_1690, big, temp, humid, delta);
                            File file = new File("lightmap.png").getAbsoluteFile();
                            big.method_4325(file);
                            client.field_1724.method_43496(class_2561.method_43469("debug.vibrancy.save_lightmap", file));
                        } catch (IOException e) {
                            throw new RuntimeException(e);
                        }
                    }
                }
            }
        } else {
            original.call(delta);

            if (client.field_1724 != null && Vibrancy.SAVE_LIGHTMAP != null && Vibrancy.SAVE_LIGHTMAP.method_1434()) {
                try {
                    File file = new File("lightmap.png").getAbsoluteFile();
                    image.method_4325(file);
                    client.field_1724.method_43496(class_2561.method_43469("debug.vibrancy.save_lightmap", file));
                } catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }
}
