package net.typho.vibrancy.mixin;

import foundry.veil.api.client.render.shader.processor.ShaderImportProcessor;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.ModifyArg;

@Mixin(ShaderImportProcessor.class)
public class ShaderImportProcessorMixin {
    @ModifyArg(
            method = "modify",
            at = @At(
                    value = "INVOKE",
                    target = "Lnet/minecraft/util/Identifier;of(Ljava/lang/String;)Lnet/minecraft/util/Identifier;"
            )
    )
    private String modify(String s) {
        if (s.startsWith("\"") && s.endsWith("\"")) {
            return s.substring(1, s.length() - 1);
        }

        return s;
    }
}

