package net.typho.vibrancy.mixin;

import foundry.veil.api.client.render.VeilRenderSystem;
import foundry.veil.api.client.render.dynamicbuffer.DynamicBufferType;
import foundry.veil.impl.client.render.dynamicbuffer.DynamicBufferManger;
import net.minecraft.class_1041;
import net.minecraft.class_284;
import net.minecraft.class_293;
import net.minecraft.class_310;
import net.minecraft.class_5912;
import net.minecraft.class_5944;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Vector3f;
import org.lwjgl.glfw.GLFW;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(class_5944.class)
public abstract class ShaderProgramMixin {
    @Shadow
    public abstract @Nullable class_284 getUniform(String name);

    @Shadow public abstract void addSampler(String name, Object sampler);

    @Unique
    private class_284 camPos;
    @Unique
    private class_284 renderTime;

    @Inject(
            method = "<init>",
            at = @At("TAIL")
    )
    private void init(class_5912 factory, String name, class_293 format, CallbackInfo ci) {
        camPos = getUniform("CameraPos");
        renderTime = getUniform("RenderTime");
    }

    @Inject(
            method = "initializeUniforms",
            at = @At("TAIL")
    )
    private void initializeUniforms(class_293.class_5596 drawMode, Matrix4f viewMatrix, Matrix4f projectionMatrix, class_1041 window, CallbackInfo ci) {
        if (camPos != null) {
            Vector3f vec = class_310.method_1551().field_1773.method_19418().method_19326().method_46409();
            camPos.method_1249(vec.z, vec.y, vec.x);
        }

        if (renderTime != null) {
            renderTime.method_1251((float) GLFW.glfwGetTime());
        }

        DynamicBufferManger bufferManger = VeilRenderSystem.renderer().getDynamicBufferManger();
        for (DynamicBufferType dynamicBuffer : DynamicBufferType.values()) {
            addSampler(dynamicBuffer.getSourceName() + "Sampler", bufferManger.getBufferTexture(dynamicBuffer));
        }
    }
}
