package net.typho.vibrancy;

import com.google.common.collect.ImmutableList;
import net.caffeinemc.mods.sodium.client.gui.options.OptionGroup;
import net.caffeinemc.mods.sodium.client.gui.options.OptionImpact;
import net.caffeinemc.mods.sodium.client.gui.options.OptionImpl;
import net.caffeinemc.mods.sodium.client.gui.options.OptionPage;
import net.caffeinemc.mods.sodium.client.gui.options.control.ControlValueFormatter;
import net.caffeinemc.mods.sodium.client.gui.options.control.SliderControl;
import net.caffeinemc.mods.sodium.client.gui.options.control.TickBoxControl;
import net.caffeinemc.mods.sodium.client.gui.options.storage.MinecraftOptionsStorage;
import net.minecraft.class_2561;
import java.util.LinkedList;
import java.util.List;

public final class SodiumCompat {
    private SodiumCompat() {
    }

    public static OptionPage rtxPage(MinecraftOptionsStorage vanillaOpts) {
        List<OptionGroup> groups = new LinkedList<>();

        groups.add(OptionGroup.createBuilder()
                .add(OptionImpl.createBuilder(boolean.class, vanillaOpts)
                        .setName(class_2561.method_43471("options.vibrancy.dynamic_lightmap"))
                        .setTooltip(class_2561.method_43471("options.vibrancy.dynamic_lightmap.tooltip"))
                        .setControl(TickBoxControl::new)
                        .setBinding((opts, value) -> Vibrancy.DYNAMIC_LIGHTMAP.method_41748(value), opts -> Vibrancy.DYNAMIC_LIGHTMAP.method_41753())
                        .build())
                .build());

        groups.add(OptionGroup.createBuilder()
                .add(OptionImpl.createBuilder(int.class, vanillaOpts)
                        .setName(class_2561.method_43471("options.vibrancy.raytrace_distance"))
                        .setTooltip(class_2561.method_43471("options.vibrancy.raytrace_distance.tooltip"))
                        .setControl(option -> new SliderControl(option, 1, 16, 1, ControlValueFormatter.translateVariable("options.chunks")))
                        .setBinding((opts, value) -> Vibrancy.RAYTRACE_DISTANCE.method_41748(value), opts -> Vibrancy.RAYTRACE_DISTANCE.method_41753())
                        .setImpact(OptionImpact.HIGH)
                        .build())
                .add(OptionImpl.createBuilder(int.class, vanillaOpts)
                        .setName(class_2561.method_43471("options.vibrancy.light_cull_distance"))
                        .setTooltip(class_2561.method_43471("options.vibrancy.light_cull_distance.tooltip"))
                        .setControl(option -> new SliderControl(option, 1, 16, 1, ControlValueFormatter.translateVariable("options.chunks")))
                        .setBinding((opts, value) -> Vibrancy.LIGHT_CULL_DISTANCE.method_41748(value), opts -> Vibrancy.LIGHT_CULL_DISTANCE.method_41753())
                        .setImpact(OptionImpact.HIGH)
                        .build())
                .add(OptionImpl.createBuilder(int.class, vanillaOpts)
                        .setName(class_2561.method_43471("options.vibrancy.max_raytraced_lights"))
                        .setTooltip(class_2561.method_43471("options.vibrancy.max_raytraced_lights.tooltip"))
                        .setControl(option -> new SliderControl(option, 5, 105, 5, v -> v > 100 ? class_2561.method_43471("options.vibrancy.max_raytraced_lights.max") : class_2561.method_43469("options.vibrancy.max_raytraced_lights.value", v)))
                        .setBinding((opts, value) -> Vibrancy.MAX_RAYTRACED_LIGHTS.method_41748(value), opts -> Vibrancy.MAX_RAYTRACED_LIGHTS.method_41753())
                        .setImpact(OptionImpact.HIGH)
                        .build())
                .build());

        return new OptionPage(class_2561.method_43471("options.vibrancy.page"), ImmutableList.copyOf(groups));
    }
}
