/*
 * Decompiled with CFR 0.152.
 */
package net.typho.vibrancy;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import foundry.veil.api.client.render.VeilRenderSystem;
import foundry.veil.api.client.render.framebuffer.AdvancedFbo;
import foundry.veil.api.client.render.light.PointLight;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.function.Consumer;
import net.minecraft.class_1309;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_291;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3341;
import net.minecraft.class_3532;
import net.minecraft.class_4184;
import net.minecraft.class_4588;
import net.minecraft.class_5944;
import net.minecraft.class_638;
import net.typho.vibrancy.DynamicLightInfo;
import net.typho.vibrancy.RaytracedLight;
import net.typho.vibrancy.Vibrancy;
import org.joml.Matrix4f;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3d;
import org.joml.Vector3dc;
import org.joml.Vector3f;
import org.lwjgl.glfw.GLFW;
import org.lwjgl.opengl.GL30;

public class RaytracedPointEntityLight
extends PointLight
implements RaytracedLight {
    public final class_1309 entity;
    protected final class_291 geomVBO = new class_291(class_291.class_8555.field_44794);
    protected final int quadsSSBO = GL30.glGenBuffers();
    protected boolean anyShadows = false;
    protected boolean hasLight = false;
    protected float flicker = 0.0f;
    protected float flickerMin;
    protected float flickerMax;
    protected float flickerStart = (float)GLFW.glfwGetTime();
    protected List<RaytracedLight.Quad> quads = new LinkedList<RaytracedLight.Quad>();
    protected final List<class_2338> dirty = new LinkedList<class_2338>();
    protected class_3341 quadBox;
    protected CompletableFuture<List<RaytracedLight.Quad>> fullRebuildTask;

    public RaytracedPointEntityLight(class_1309 entity) {
        this.entity = entity;
    }

    public class_3341 getBox() {
        class_2338 lightBlockPos = new class_2338((int)Math.floor(this.getPosition().x), (int)Math.floor(this.getPosition().y), (int)Math.floor(this.getPosition().z));
        int blockRadius = Vibrancy.capShadowDistance((int)Math.ceil(this.radius) - 2);
        class_3341 box = new class_3341(lightBlockPos);
        if (blockRadius > 1) {
            box = box.method_35410(blockRadius);
        }
        return box;
    }

    @Override
    public void updateDirty(Iterable<class_2338> it) {
        class_3341 box = this.getBox();
        for (class_2338 pos : it) {
            if (!box.method_14662((class_2382)pos)) continue;
            this.dirty.add(pos);
        }
    }

    public void upload(class_287 builder, Collection<RaytracedLight.ShadowVolume> volumes) {
        if (volumes.isEmpty()) {
            this.anyShadows = false;
        } else {
            this.anyShadows = true;
            this.upload(builder, volumes, this.geomVBO, this.quadsSSBO, 35040);
        }
    }

    public void regenQuadsSync(class_638 world, class_2338 pos, Consumer<RaytracedLight.Quad> out, class_2338 lightBlockPos, Vector3f lightPos) {
        this.quads.removeIf(q -> q.blockPos().equals((Object)pos));
        this.regenQuadsAsync(world, pos, out, lightBlockPos, lightPos);
    }

    public void regenQuadsAsync(class_638 world, class_2338 pos, Consumer<RaytracedLight.Quad> out, class_2338 lightBlockPos, Vector3f lightPos) {
        this.getQuads(world, pos, out, pos.method_10262((class_2382)lightBlockPos), lightBlockPos, lightPos, false);
    }

    public void regenAll(class_638 world, class_3341 box, class_2338 lightBlockPos, Vector3f lightPos) {
        this.fullRebuildTask = CompletableFuture.supplyAsync(() -> {
            LinkedList quads = new LinkedList();
            for (int x = box.method_35415(); x <= box.method_35418(); ++x) {
                for (int y = box.method_35416(); y <= box.method_35419(); ++y) {
                    for (int z = box.method_35417(); z <= box.method_35420(); ++z) {
                        this.regenQuadsAsync(world, new class_2338(x, y, z), quads::add, lightBlockPos, lightPos);
                    }
                }
            }
            return quads;
        });
    }

    @Override
    public boolean render(boolean raytrace) {
        DynamicLightInfo info;
        class_2680 state;
        this.hasLight = false;
        class_1792 class_17922 = this.entity.method_6047().method_7909();
        if (class_17922 instanceof class_1747) {
            class_1747 block = (class_1747)class_17922;
            state = block.method_7711().method_9564();
            info = DynamicLightInfo.get(state);
            if (info == null) {
                return false;
            }
        } else {
            return false;
        }
        info.initLight(this, state);
        this.hasLight = true;
        class_638 world = class_310.method_1551().field_1687;
        if (world != null) {
            class_2338 lightBlockPos = new class_2338((int)Math.floor(this.getPosition().x), (int)Math.floor(this.getPosition().y), (int)Math.floor(this.getPosition().z));
            Vector3f lightPos = new Vector3f((float)this.getPosition().x, (float)this.getPosition().y, (float)this.getPosition().z);
            int blockRadius = Vibrancy.capShadowDistance((int)Math.ceil(this.radius) - 2);
            class_3341 box = this.getBox();
            LinkedList<RaytracedLight.ShadowVolume> volumes = new LinkedList<RaytracedLight.ShadowVolume>();
            class_287 builder = class_289.method_1348().method_60827(class_293.class_5596.field_27382, class_290.field_1592);
            if (this.isVisible()) {
                class_5944 shader;
                if (this.fullRebuildTask != null && this.fullRebuildTask.isDone()) {
                    try {
                        this.quads = this.fullRebuildTask.get();
                        this.fullRebuildTask = null;
                    }
                    catch (InterruptedException | ExecutionException e) {
                        throw new RuntimeException(e);
                    }
                } else if (this.hasLight) {
                    if (this.quadBox == null || !this.quadBox.method_14662((class_2382)this.entity.method_24515())) {
                        this.dirty.clear();
                        this.quadBox = box;
                        this.regenAll(world, blockRadius > 1 ? box.method_35410(blockRadius) : box, lightBlockPos, lightPos);
                    } else if (!this.dirty.isEmpty()) {
                        for (class_2338 pos : this.dirty) {
                            this.regenQuadsSync(world, pos, this.quads::add, lightBlockPos, lightPos);
                            for (class_2350 dir : class_2350.values()) {
                                this.regenQuadsSync(world, pos.method_10093(dir), this.quads::add, lightBlockPos, lightPos);
                            }
                        }
                    }
                }
                for (RaytracedLight.Quad quad : this.quads) {
                    if (!box.method_14662((class_2382)quad.blockPos())) continue;
                    RaytracedLight.ShadowVolume volume = quad.toVolume(lightPos, this.radius * 2.0f);
                    volume.render((class_4588)builder);
                    volumes.add(volume);
                }
                this.upload(builder, volumes);
                class_4184 camera = class_310.method_1551().field_1773.method_19418();
                Matrix4f view = new Matrix4f().rotate((Quaternionfc)camera.method_23767().invert(new Quaternionf())).translate((float)(-camera.method_19326().field_1352), (float)(-camera.method_19326().field_1351), (float)(-camera.method_19326().field_1350));
                if (this.anyShadows && raytrace) {
                    VeilRenderSystem.setShader((class_2960)Vibrancy.id("light/ray/mask"));
                    shader = Objects.requireNonNull(RenderSystem.getShader());
                    shader.method_35785("LightPos").method_1249(lightPos.x, lightPos.y, lightPos.z);
                    shader.method_35785("Detailed").method_35649(this.getPosition().distanceSquared(camera.method_19326().field_1352, camera.method_19326().field_1351, camera.method_19326().field_1350) < (double)class_3532.method_34954((int)((Integer)Vibrancy.RAYTRACE_DISTANCE.method_41753() * 16)) ? 1 : 0);
                    RenderSystem.depthMask((boolean)true);
                    RenderSystem.disableDepthTest();
                    RenderSystem.enableBlend();
                    RenderSystem.blendFunc((GlStateManager.class_4535)GlStateManager.class_4535.ONE, (GlStateManager.class_4534)GlStateManager.class_4534.ONE);
                    RenderSystem.blendEquation((int)32774);
                    GL30.glBindBufferBase((int)37074, (int)0, (int)this.quadsSSBO);
                    GL30.glCullFace((int)1028);
                    GL30.glDepthFunc((int)518);
                    this.renderMask(Vibrancy.id("shadow_mask"), view);
                    GL30.glCullFace((int)1029);
                    GL30.glDepthFunc((int)515);
                    RenderSystem.depthMask((boolean)false);
                    RenderSystem.enableBlend();
                    GL30.glBindBufferBase((int)37074, (int)0, (int)0);
                } else {
                    Objects.requireNonNull(VeilRenderSystem.renderer().getFramebufferManager().getFramebuffer(Vibrancy.id("shadow_mask"))).bind(false);
                    GL30.glClearColor((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f);
                    GL30.glClear((int)16640);
                }
                Objects.requireNonNull(VeilRenderSystem.renderer().getFramebufferManager().getFramebuffer(Vibrancy.id("ray_light"))).bind(true);
                VeilRenderSystem.setShader((class_2960)Vibrancy.id("light/ray/point"));
                shader = Objects.requireNonNull(RenderSystem.getShader());
                float time = (float)GLFW.glfwGetTime();
                while ((double)(time - this.flickerStart) > 0.25) {
                    this.flickerStart += 0.25f;
                    this.flickerMin = this.flickerMax;
                    this.flickerMax = new Random().nextFloat(-1.0f, 1.0f);
                }
                float brightness = this.getBrightness() * (1.0f + this.flicker * class_3532.method_16439((float)((time - this.flickerStart) * 4.0f), (float)this.flickerMin, (float)this.flickerMax));
                shader.method_35785("LightPos").method_1249(lightPos.x, lightPos.y, lightPos.z);
                shader.method_35785("LightColor").method_1249(this.color.x * brightness, this.color.y * brightness, this.color.z * brightness);
                shader.method_35785("LightRadius").method_1251(this.radius);
                shader.method_35785("AnyShadows").method_35649(this.anyShadows ? 1 : 0);
                Vibrancy.SCREEN_VBO.method_1353();
                Vibrancy.SCREEN_VBO.method_34427(view, RenderSystem.getProjectionMatrix(), shader);
                class_291.method_1354();
                return true;
            }
        }
        return false;
    }

    protected void renderMask(class_2960 fbo, Matrix4f view) {
        AdvancedFbo main = Objects.requireNonNull(VeilRenderSystem.renderer().getFramebufferManager().getFramebuffer(class_2960.method_60654((String)"main")));
        AdvancedFbo to = Objects.requireNonNull(VeilRenderSystem.renderer().getFramebufferManager().getFramebuffer(fbo));
        GL30.glBindFramebuffer((int)36008, (int)main.getId());
        GL30.glBindFramebuffer((int)36009, (int)to.getId());
        GL30.glBlitFramebuffer((int)0, (int)0, (int)main.getWidth(), (int)main.getHeight(), (int)0, (int)0, (int)to.getWidth(), (int)to.getHeight(), (int)256, (int)9728);
        to.bind(true);
        GL30.glClearColor((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f);
        GL30.glClear((int)16640);
        this.geomVBO.method_1353();
        this.geomVBO.method_34427(view, RenderSystem.getProjectionMatrix(), RenderSystem.getShader());
        class_291.method_1354();
    }

    public void free() {
        this.geomVBO.close();
        GL30.glDeleteBuffers((int)this.quadsSSBO);
    }

    public final PointLight setPosition(Vector3dc position) {
        throw new UnsupportedOperationException("Can't move an entity light");
    }

    public final PointLight setPosition(double x, double y, double z) {
        throw new UnsupportedOperationException("Can't move an entity light");
    }

    @Override
    public Vector3d getPosition() {
        class_243 pos = this.entity.method_33571();
        return new Vector3d(pos.field_1352, pos.field_1351, pos.field_1350);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + String.valueOf(this.entity) + "]";
    }
}

