/*
 * Decompiled with CFR 0.152.
 */
package net.typho.vibrancy;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import foundry.veil.api.client.render.VeilRenderSystem;
import foundry.veil.api.client.render.framebuffer.AdvancedFbo;
import foundry.veil.api.client.render.light.PointLight;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.function.Consumer;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_291;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3341;
import net.minecraft.class_3532;
import net.minecraft.class_4184;
import net.minecraft.class_4588;
import net.minecraft.class_5944;
import net.minecraft.class_638;
import net.typho.vibrancy.RaytracedLight;
import net.typho.vibrancy.Vibrancy;
import org.joml.Matrix4f;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.lwjgl.glfw.GLFW;
import org.lwjgl.opengl.GL30;

public class RaytracedPointLight
extends PointLight
implements RaytracedLight {
    protected final List<class_2338> dirty = new LinkedList<class_2338>();
    protected final class_291 geomVBO = new class_291(class_291.class_8555.field_44794);
    protected final int quadsSSBO = GL30.glGenBuffers();
    protected boolean remove = false;
    protected boolean anyShadows = false;
    protected float flicker = 0.0f;
    protected float flickerMin;
    protected float flickerMax;
    protected float flickerStart = (float)GLFW.glfwGetTime();
    protected List<RaytracedLight.ShadowVolume> volumes = new LinkedList<RaytracedLight.ShadowVolume>();
    protected CompletableFuture<List<RaytracedLight.ShadowVolume>> fullRebuildTask;

    public float getFlicker() {
        return this.flicker;
    }

    public RaytracedPointLight setFlicker(float flicker) {
        this.flicker = flicker;
        this.markDirty();
        return this;
    }

    public class_3341 getBox() {
        class_2338 lightBlockPos = new class_2338((int)Math.floor(this.getPosition().x), (int)Math.floor(this.getPosition().y), (int)Math.floor(this.getPosition().z));
        int blockRadius = Vibrancy.capShadowDistance((int)Math.ceil(this.radius) - 2);
        class_3341 box = new class_3341(lightBlockPos);
        if (blockRadius > 1) {
            box = box.method_35410(blockRadius);
        }
        return box;
    }

    public void upload(class_287 builder, Collection<RaytracedLight.ShadowVolume> volumes) {
        if (volumes.isEmpty()) {
            this.anyShadows = false;
        } else {
            this.anyShadows = true;
            this.upload(builder, volumes, this.geomVBO, this.quadsSSBO, 35048);
        }
    }

    public void regenQuads(class_638 world, class_2338 pos, Consumer<RaytracedLight.ShadowVolume> out, class_2338 lightBlockPos, Vector3f lightPos) {
        this.volumes.removeIf(v -> v.caster().blockPos().equals((Object)pos));
        this.getVolumes(world, pos, out, pos.method_10262((class_2382)lightBlockPos), lightBlockPos, lightPos, this.radius, true);
    }

    @Override
    public void updateDirty(Iterable<class_2338> it) {
        class_3341 box = this.getBox();
        for (class_2338 pos : it) {
            if (!box.method_14662((class_2382)pos)) continue;
            this.dirty.add(pos);
        }
    }

    @Override
    public boolean render(boolean raytrace) {
        class_638 world = class_310.method_1551().field_1687;
        if (world != null) {
            class_287 builder;
            class_2338 lightBlockPos = new class_2338((int)Math.floor(this.getPosition().x), (int)Math.floor(this.getPosition().y), (int)Math.floor(this.getPosition().z));
            Vector3f lightPos = new Vector3f((float)this.getPosition().x, (float)this.getPosition().y, (float)this.getPosition().z);
            int blockRadius = Vibrancy.capShadowDistance((int)Math.ceil(this.radius) - 2);
            class_3341 box = this.getBox();
            if (this.fullRebuildTask != null) {
                ++Vibrancy.NUM_LIGHT_TASKS;
            }
            if (!this.dirty.isEmpty()) {
                for (class_2338 class_23382 : this.dirty) {
                    if (!class_23382.equals((Object)lightBlockPos)) {
                        this.regenQuads(world, class_23382, this.volumes::add, lightBlockPos, lightPos);
                    }
                    for (class_2350 dir : class_2350.values()) {
                        class_2338 pos1 = class_23382.method_10093(dir);
                        if (pos1.equals((Object)lightBlockPos)) continue;
                        this.regenQuads(world, pos1, this.volumes::add, lightBlockPos, lightPos);
                    }
                }
                this.dirty.clear();
                builder = class_289.method_1348().method_60827(class_293.class_5596.field_27382, class_290.field_1592);
                for (RaytracedLight.ShadowVolume volume : this.volumes) {
                    volume.render((class_4588)builder);
                }
                this.upload(builder, this.volumes);
            }
            if (this.fullRebuildTask != null && this.fullRebuildTask.isDone()) {
                try {
                    this.volumes = this.fullRebuildTask.get();
                    this.fullRebuildTask = null;
                    builder = class_289.method_1348().method_60827(class_293.class_5596.field_27382, class_290.field_1592);
                    for (RaytracedLight.ShadowVolume volume : this.volumes) {
                        volume.render((class_4588)builder);
                    }
                    this.upload(builder, this.volumes);
                }
                catch (InterruptedException | ExecutionException e) {
                    throw new RuntimeException(e);
                }
            } else if (raytrace) {
                if (blockRadius < 1) {
                    raytrace = false;
                } else if (this.isDirty()) {
                    this.clean();
                    this.fullRebuildTask = CompletableFuture.supplyAsync(() -> {
                        LinkedList volumes = new LinkedList();
                        for (int x = box.method_35415(); x <= box.method_35418(); ++x) {
                            for (int y = box.method_35416(); y <= box.method_35419(); ++y) {
                                for (int z = box.method_35417(); z <= box.method_35420(); ++z) {
                                    double sqDist;
                                    class_2338 pos = new class_2338(x, y, z);
                                    if (pos.equals((Object)lightBlockPos) || (sqDist = pos.method_10262((class_2382)lightBlockPos)) == 0.0 || !(sqDist < (double)(blockRadius * blockRadius))) continue;
                                    this.getVolumes(world, pos, volumes::add, sqDist, lightBlockPos, lightPos, this.radius, true);
                                }
                            }
                        }
                        return volumes;
                    });
                }
            }
            if (this.isVisible()) {
                class_5944 shader;
                class_4184 camera = class_310.method_1551().field_1773.method_19418();
                Matrix4f matrix4f = new Matrix4f().rotate((Quaternionfc)camera.method_23767().invert(new Quaternionf())).translate((float)(-camera.method_19326().field_1352), (float)(-camera.method_19326().field_1351), (float)(-camera.method_19326().field_1350));
                if (this.anyShadows && raytrace) {
                    VeilRenderSystem.setShader((class_2960)Vibrancy.id("light/ray/mask"));
                    shader = Objects.requireNonNull(RenderSystem.getShader());
                    shader.method_35785("LightPos").method_1249(lightPos.x, lightPos.y, lightPos.z);
                    shader.method_35785("Detailed").method_35649(this.getPosition().distanceSquared(camera.method_19326().field_1352, camera.method_19326().field_1351, camera.method_19326().field_1350) < (double)class_3532.method_34954((int)((Integer)Vibrancy.RAYTRACE_DISTANCE.method_41753() * 16)) ? 1 : 0);
                    RenderSystem.depthMask((boolean)true);
                    RenderSystem.disableDepthTest();
                    RenderSystem.enableBlend();
                    RenderSystem.blendFunc((GlStateManager.class_4535)GlStateManager.class_4535.ONE, (GlStateManager.class_4534)GlStateManager.class_4534.ONE);
                    RenderSystem.blendEquation((int)32774);
                    GL30.glBindBufferBase((int)37074, (int)0, (int)this.quadsSSBO);
                    GL30.glCullFace((int)1028);
                    GL30.glDepthFunc((int)518);
                    this.renderMask(Vibrancy.id("shadow_mask"), matrix4f);
                    GL30.glCullFace((int)1029);
                    GL30.glDepthFunc((int)515);
                    RenderSystem.depthMask((boolean)false);
                    RenderSystem.enableBlend();
                    GL30.glBindBufferBase((int)37074, (int)0, (int)0);
                } else {
                    Objects.requireNonNull(VeilRenderSystem.renderer().getFramebufferManager().getFramebuffer(Vibrancy.id("shadow_mask"))).bind(false);
                    GL30.glClearColor((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f);
                    GL30.glClear((int)16640);
                }
                Objects.requireNonNull(VeilRenderSystem.renderer().getFramebufferManager().getFramebuffer(Vibrancy.id("ray_light"))).bind(true);
                VeilRenderSystem.setShader((class_2960)Vibrancy.id("light/ray/point"));
                shader = Objects.requireNonNull(RenderSystem.getShader());
                float time = (float)GLFW.glfwGetTime();
                while ((double)(time - this.flickerStart) > 0.25) {
                    this.flickerStart += 0.25f;
                    this.flickerMin = this.flickerMax;
                    this.flickerMax = new Random().nextFloat(-1.0f, 1.0f);
                }
                float brightness = this.getBrightness() * (1.0f + this.flicker * class_3532.method_16439((float)((time - this.flickerStart) * 4.0f), (float)this.flickerMin, (float)this.flickerMax));
                shader.method_35785("LightPos").method_1249(lightPos.x, lightPos.y, lightPos.z);
                shader.method_35785("LightColor").method_1249(this.color.x * brightness, this.color.y * brightness, this.color.z * brightness);
                shader.method_35785("LightRadius").method_1251(this.radius);
                shader.method_35785("AnyShadows").method_35649(this.anyShadows ? 1 : 0);
                Vibrancy.SCREEN_VBO.method_1353();
                Vibrancy.SCREEN_VBO.method_34427(matrix4f, RenderSystem.getProjectionMatrix(), shader);
                class_291.method_1354();
                return true;
            }
        }
        return false;
    }

    protected void renderMask(class_2960 fbo, Matrix4f view) {
        AdvancedFbo main = Objects.requireNonNull(VeilRenderSystem.renderer().getFramebufferManager().getFramebuffer(class_2960.method_60654((String)"main")));
        AdvancedFbo to = Objects.requireNonNull(VeilRenderSystem.renderer().getFramebufferManager().getFramebuffer(fbo));
        GL30.glBindFramebuffer((int)36008, (int)main.getId());
        GL30.glBindFramebuffer((int)36009, (int)to.getId());
        GL30.glBlitFramebuffer((int)0, (int)0, (int)main.getWidth(), (int)main.getHeight(), (int)0, (int)0, (int)to.getWidth(), (int)to.getHeight(), (int)256, (int)9728);
        to.bind(true);
        GL30.glClearColor((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f);
        GL30.glClear((int)16640);
        this.geomVBO.method_1353();
        this.geomVBO.method_34427(view, RenderSystem.getProjectionMatrix(), RenderSystem.getShader());
        class_291.method_1354();
    }

    public void free() {
        this.geomVBO.close();
        GL30.glDeleteBuffers((int)this.quadsSSBO);
    }
}

