package net.typho.vibrancy.mixin;

import com.mojang.blaze3d.platform.GlDebug;
import org.slf4j.Logger;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(GlDebug.class)
public class GlDebugMixin {
    @Shadow
    @Final
    private static Logger LOGGER;

    @Inject(
            method = "printDebugLog",
            at = @At("TAIL")
    )
    private static void printDebugLog(int source, int type, int id, int severity, int messageLength, long message, long l, CallbackInfo ci) {
        for (StackTraceElement ste : Thread.currentThread().getStackTrace()) {
            if (ste.getClassName().startsWith("java") || ste.getClassName().startsWith("org.lwjgl") || ste.getClassName().startsWith("lwjgl") || ste.getClassName().startsWith("com.mojang.blaze3d.platform.GlDebug")) {
                continue;
            }

            LOGGER.info("at {}", ste);
            break;
        }
    }
}
