/*
 * Decompiled with CFR 0.152.
 */
package net.typho.vibrancy;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.VertexBuffer;
import com.mojang.blaze3d.vertex.VertexFormat;
import foundry.veil.api.client.render.VeilRenderSystem;
import foundry.veil.api.client.render.framebuffer.AdvancedFbo;
import foundry.veil.api.client.render.light.PointLight;
import foundry.veil.api.client.render.rendertype.VeilRenderType;
import java.util.Collection;
import java.util.Objects;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.core.BlockBox;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.phys.AABB;
import net.typho.vibrancy.RaytracedLight;
import net.typho.vibrancy.Vibrancy;
import org.joml.Matrix4f;
import org.joml.Vector3d;
import org.joml.Vector3f;
import org.lwjgl.glfw.GLFW;
import org.lwjgl.opengl.GL15;
import org.lwjgl.opengl.GL30;

public abstract class AbstractRaytracedPointLight
extends PointLight
implements RaytracedLight {
    protected final VertexBuffer geomVBO = new VertexBuffer(VertexBuffer.Usage.STATIC);
    protected final VertexBuffer entitiesVBO = new VertexBuffer(VertexBuffer.Usage.DYNAMIC);
    protected final VertexBuffer boxVBO = new VertexBuffer(VertexBuffer.Usage.STATIC);
    protected final int quadsSSBO = GL15.glGenBuffers();
    protected int shadowCount = 0;
    protected boolean anyShadows = false;
    protected float flicker = 0.0f;
    protected float flickerMin;
    protected float flickerMax;
    protected float flickerStart = (float)GLFW.glfwGetTime();

    public float getFlicker() {
        return this.flicker;
    }

    public AbstractRaytracedPointLight setFlicker(float flicker) {
        this.flicker = flicker;
        this.markDirty();
        return this;
    }

    public void upload(BufferBuilder builder, Collection<RaytracedLight.ShadowVolume> volumes) {
        if (volumes.isEmpty()) {
            this.anyShadows = false;
        } else {
            this.anyShadows = true;
            this.upload(builder, volumes, this.geomVBO, this.quadsSSBO, 35044);
        }
    }

    public BlockBox getBox() {
        Vector3d pos = this.getPosition();
        BlockPos lightBlockPos = new BlockPos((int)Math.floor(pos.x), (int)Math.floor(pos.y), (int)Math.floor(pos.z));
        int blockRadius = Vibrancy.capShadowDistance((int)Math.ceil(this.radius) - 2);
        BlockBox box = BlockBox.of((BlockPos)lightBlockPos);
        if (blockRadius > 1) {
            box = new BlockBox(new BlockPos(box.min().getX() - blockRadius, box.min().getY() - blockRadius, box.min().getZ() - blockRadius), new BlockPos(box.max().getX() + blockRadius, box.max().getY() + blockRadius, box.max().getZ() + blockRadius));
        }
        return box;
    }

    protected void renderMask(boolean raytrace, Vector3f lightPos, Matrix4f view) {
        AdvancedFbo fbo = Objects.requireNonNull(VeilRenderSystem.renderer().getFramebufferManager().getFramebuffer(Vibrancy.id("shadow_mask")));
        fbo.bind(true);
        GL15.glClearColor((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f);
        GL15.glClearStencil((int)0);
        GL15.glClear((int)17664);
        if (this.anyShadows && raytrace) {
            GL15.glEnable((int)2960);
            GL15.glStencilMask((int)255);
            GL15.glStencilFunc((int)519, (int)1, (int)255);
            GL15.glStencilOp((int)7680, (int)7680, (int)7681);
            RenderType stencilType = VeilRenderType.get((ResourceLocation)Vibrancy.id("shadow_stencil"), (Object[])new Object[0]);
            stencilType.setupRenderState();
            ShaderInstance shader = Objects.requireNonNull(RenderSystem.getShader());
            shader.safeGetUniform("LightPos").set(lightPos.x, lightPos.y, lightPos.z);
            shader.safeGetUniform("LightRadius").set(this.radius);
            Vibrancy.SCREEN_VBO.bind();
            Vibrancy.SCREEN_VBO.drawWithShader(view, RenderSystem.getProjectionMatrix(), RenderSystem.getShader());
            VertexBuffer.unbind();
            stencilType.clearRenderState();
            RenderType type = VeilRenderType.get((ResourceLocation)Vibrancy.id("shadow"), (Object[])new Object[0]);
            type.setupRenderState();
            GL15.glEnable((int)2960);
            GL15.glStencilMask((int)255);
            GL15.glStencilFunc((int)514, (int)1, (int)255);
            GL15.glStencilOp((int)7680, (int)7680, (int)7680);
            shader = Objects.requireNonNull(RenderSystem.getShader());
            shader.safeGetUniform("LightPos").set(lightPos.x, lightPos.y, lightPos.z);
            shader.safeGetUniform("LightRadius").set(this.radius);
            GL30.glBindBufferBase((int)37074, (int)0, (int)this.quadsSSBO);
            shader.setSampler("AtlasSampler", (Object)Minecraft.getInstance().getModelManager().getAtlas(InventoryMenu.BLOCK_ATLAS));
            this.geomVBO.bind();
            this.geomVBO.drawWithShader(view, RenderSystem.getProjectionMatrix(), RenderSystem.getShader());
            VertexBuffer.unbind();
            GL30.glBindBufferBase((int)37074, (int)0, (int)0);
            type.clearRenderState();
            GL15.glDisable((int)2960);
            Vibrancy.SHADOW_COUNT += this.shadowCount;
        }
    }

    protected void renderLight(Vector3f lightPos, Matrix4f view) {
        Objects.requireNonNull(VeilRenderSystem.renderer().getFramebufferManager().getFramebuffer(Vibrancy.id("ray_light"))).bind(true);
        VeilRenderSystem.setShader((ResourceLocation)Vibrancy.id("light/ray/point"));
        ShaderInstance shader = Objects.requireNonNull(RenderSystem.getShader());
        float time = (float)GLFW.glfwGetTime();
        while ((double)(time - this.flickerStart) > 0.25) {
            this.flickerStart += 0.25f;
            this.flickerMin = this.flickerMax;
            this.flickerMax = new Random().nextFloat(-1.0f, 1.0f);
        }
        float brightness = this.getBrightness() * (1.0f + this.flicker * Mth.lerp((float)((time - this.flickerStart) * 4.0f), (float)this.flickerMin, (float)this.flickerMax));
        shader.safeGetUniform("LightPos").set(lightPos.x, lightPos.y, lightPos.z);
        shader.safeGetUniform("LightColor").set(this.color.x * brightness, this.color.y * brightness, this.color.z * brightness);
        shader.safeGetUniform("LightRadius").set(this.radius);
        shader.safeGetUniform("AnyShadows").set(this.anyShadows ? 1 : 0);
        BufferBuilder builder = RenderSystem.renderThreadTesselator().begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION);
        AABB box = this.getBoundingBox();
        Vector3f[] vertices = new Vector3f[]{new Vector3f((float)box.maxX, (float)box.maxY, (float)box.maxZ), new Vector3f((float)box.minX, (float)box.maxY, (float)box.maxZ), new Vector3f((float)box.minX, (float)box.minY, (float)box.maxZ), new Vector3f((float)box.maxX, (float)box.minY, (float)box.maxZ), new Vector3f((float)box.maxX, (float)box.maxY, (float)box.minZ), new Vector3f((float)box.minX, (float)box.maxY, (float)box.minZ), new Vector3f((float)box.minX, (float)box.minY, (float)box.minZ), new Vector3f((float)box.maxX, (float)box.minY, (float)box.minZ)};
        builder.addVertex(vertices[0]).addVertex(vertices[1]).addVertex(vertices[2]).addVertex(vertices[3]);
        builder.addVertex(vertices[1]).addVertex(vertices[5]).addVertex(vertices[6]).addVertex(vertices[2]);
        builder.addVertex(vertices[5]).addVertex(vertices[4]).addVertex(vertices[7]).addVertex(vertices[6]);
        builder.addVertex(vertices[4]).addVertex(vertices[0]).addVertex(vertices[3]).addVertex(vertices[7]);
        builder.addVertex(vertices[1]).addVertex(vertices[0]).addVertex(vertices[4]).addVertex(vertices[5]);
        builder.addVertex(vertices[3]).addVertex(vertices[2]).addVertex(vertices[6]).addVertex(vertices[7]);
        RenderSystem.disableDepthTest();
        GL15.glCullFace((int)1028);
        RenderSystem.enableCull();
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
        RenderSystem.blendEquation((int)32774);
        this.boxVBO.bind();
        this.boxVBO.upload(builder.build());
        this.boxVBO.drawWithShader(view, RenderSystem.getProjectionMatrix(), shader);
        VertexBuffer.unbind();
        GL15.glCullFace((int)1029);
        RenderSystem.disableBlend();
    }

    @Override
    public AABB getBoundingBox() {
        Vector3d pos = this.getPosition();
        return new AABB(pos.x - (double)this.radius, pos.y - (double)this.radius, pos.z - (double)this.radius, pos.x + (double)this.radius, pos.y + (double)this.radius, pos.z + (double)this.radius);
    }

    public void free() {
        this.geomVBO.close();
        GL15.glDeleteBuffers((int)this.quadsSSBO);
    }
}

